/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.item.model;

import net.minecraft.client.render.EntityRenderDispatcher;
import net.minecraft.client.render.ItemRenderer;
import net.minecraft.client.render.TextureManager;
import net.minecraft.client.render.font.FontRenderer;
import net.minecraft.client.render.tessellator.Tessellator;
import net.minecraft.client.render.texture.stitcher.IconCoordinate;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.item.Item;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.util.helper.MathHelper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.opengl.GL11;

public abstract class ItemModel {
    public Item item;

    public ItemModel(Item item) {
        this.item = item;
    }

    public abstract void render(@NotNull Tessellator var1, @Nullable Entity var2, @NotNull ItemStack var3, @NotNull String var4, boolean var5, int var6, float var7, float var8, float var9, boolean var10);

    public abstract void renderItemOverlayIntoGUI(@NotNull Tessellator var1, @NotNull FontRenderer var2, @NotNull TextureManager var3, @NotNull ItemStack var4, int var5, int var6, @Nullable String var7, float var8);

    public void renderGui(@NotNull Tessellator tessellator, @Nullable Entity holder, @NotNull ItemStack itemStack, int x, int y, float brightness, float alpha, float partialTick) {
        GL11.glPushMatrix();
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glDisable((int)2896);
        GL11.glEnable((int)3042);
        GL11.glEnable((int)2884);
        GL11.glTranslatef((float)(x + 8), (float)(y + 8), (float)0.0f);
        GL11.glScalef((float)16.0f, (float)-16.0f, (float)1.0f);
        this.render(tessellator, holder, itemStack, "gui", false, 1, brightness, alpha, partialTick, false);
        GL11.glEnable((int)2896);
        GL11.glDisable((int)2884);
        GL11.glDisable((int)3042);
        GL11.glPopMatrix();
    }

    public void renderItemEntity(@NotNull Tessellator tessellator, @NotNull ItemStack itemStack, boolean items3d, int clusterSize, int ticks, float yaw, float brightness, float alpha, float partialTick) {
        GL11.glEnable((int)32826);
        GL11.glEnable((int)3042);
        if (items3d) {
            GL11.glRotated((double)yaw, (double)0.0, (double)1.0, (double)0.0);
        } else {
            GL11.glRotatef((float)(180.0f - EntityRenderDispatcher.instance.viewLerpYaw), (float)0.0f, (float)1.0f, (float)0.0f);
        }
        this.render(tessellator, null, itemStack, "ground", items3d, clusterSize, brightness, alpha, partialTick, false);
        GL11.glDisable((int)3042);
        GL11.glDisable((int)32826);
    }

    public void renderFirstPerson(@NotNull Tessellator tessellator, @NotNull ItemRenderer itemRenderer, @NotNull Player player, @NotNull ItemStack itemStack, float brightness, float alpha, float partialTick) {
        GL11.glPushMatrix();
        GL11.glEnable((int)32826);
        float swingProgress = player.getSwingProgress(partialTick);
        float animationProgress2 = MathHelper.sin(swingProgress * (float)Math.PI);
        float animationProgress = MathHelper.sin(MathHelper.sqrt_float(swingProgress) * (float)Math.PI);
        if (player.isLeftHanded()) {
            float xOff = 0.5625f;
            float yOff = -0.515625f - (1.0f - itemRenderer.getEquippedProgress(partialTick)) * 0.6f;
            float zOff = -0.725f;
            GL11.glScalef((float)-1.0f, (float)1.0f, (float)1.0f);
            GL11.glTranslatef((float)(-animationProgress * 0.4f), (float)(MathHelper.sin(MathHelper.sqrt_float(swingProgress) * (float)Math.PI * 2.0f) * 0.2f), (float)(-animationProgress2 * 0.2f));
            GL11.glTranslatef((float)0.5625f, (float)yOff, (float)-0.725f);
            float animationProgress3 = MathHelper.sin(swingProgress * swingProgress * (float)Math.PI);
            GL11.glRotatef((float)45.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glRotatef((float)(-animationProgress3 * 20.0f), (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glRotatef((float)(-animationProgress * 20.0f), (float)0.0f, (float)0.0f, (float)1.0f);
            GL11.glRotatef((float)(-animationProgress * 80.0f), (float)1.0f, (float)0.0f, (float)0.0f);
            GL11.glRotatef((float)-45.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glFrontFace((int)2304);
            this.render(tessellator, player, itemStack, "firstperson_lefthand", true, 1, brightness, alpha, partialTick, true);
            GL11.glFrontFace((int)2305);
        } else {
            float xOff = 0.5625f;
            float yOff = -0.515625f - (1.0f - itemRenderer.getEquippedProgress(partialTick)) * 0.6f;
            float zOff = -0.725f;
            GL11.glTranslatef((float)(-animationProgress * 0.4f), (float)(MathHelper.sin(MathHelper.sqrt_float(swingProgress) * (float)Math.PI * 2.0f) * 0.2f), (float)(-animationProgress2 * 0.2f));
            GL11.glTranslatef((float)0.5625f, (float)yOff, (float)-0.725f);
            float animationProgress3 = MathHelper.sin(swingProgress * swingProgress * (float)Math.PI);
            GL11.glRotatef((float)45.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glRotatef((float)(-animationProgress3 * 20.0f), (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glRotatef((float)(-animationProgress * 20.0f), (float)0.0f, (float)0.0f, (float)1.0f);
            GL11.glRotatef((float)(-animationProgress * 80.0f), (float)1.0f, (float)0.0f, (float)0.0f);
            GL11.glRotatef((float)-45.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            this.render(tessellator, player, itemStack, "firstperson_righthand", true, 1, brightness, alpha, partialTick, false);
        }
        GL11.glPopMatrix();
        GL11.glDisable((int)32826);
    }

    public abstract IconCoordinate getIcon(@Nullable Entity var1, ItemStack var2);
}

