/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.terrain;

import com.mojang.logging.CategorizedLogger;
import com.mojang.logging.LogUtils;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.render.OpenGLHelper;
import net.minecraft.client.render.terrain.VertexData;
import org.lwjgl.opengl.GL15;
import org.lwjgl.opengl.GL31;

public class VertexBuffer {
    public static final CategorizedLogger LOGGER = LogUtils.getLogger();
    private int vbo;
    private long capacity;
    public List<Entry> entries = new ArrayList<Entry>();
    private int entryHashCounter;

    public VertexBuffer(long initialCapacity) {
        this.capacity = initialCapacity;
        this.vbo = GL15.glGenBuffers();
        GL15.glBindBuffer((int)34962, (int)this.vbo);
        GL15.glBufferData((int)34962, (long)this.capacity, (int)35044);
        GL15.glBindBuffer((int)34962, (int)0);
    }

    public Entry addVertexData(VertexData vertexData) {
        if (vertexData.vertexCount <= 0) {
            return null;
        }
        if (this.entries.size() == 0) {
            return this.insertAtIndex(vertexData, 0);
        }
        int bytes = vertexData.buffer.position();
        if (this.entries.size() == 1) {
            Entry entry = this.entries.get(0);
            if (entry.position > bytes) {
                return this.insertAtIndex(vertexData, 0);
            }
            return this.insertAtIndex(vertexData, 1);
        }
        for (int i = 0; i < this.entries.size() - 1; ++i) {
            Entry entry = this.entries.get(i);
            Entry nextEntry = this.entries.get(i + 1);
            int availableSpace = nextEntry.position - (entry.position + entry.size);
            if (availableSpace <= bytes) continue;
            return this.insertAtIndex(vertexData, i + 1);
        }
        return this.insertAtIndex(vertexData, this.entries.size());
    }

    private Entry insertAtIndex(VertexData vertexData, int listIndex) {
        int pos = 0;
        int bytes = vertexData.buffer.position();
        if (listIndex > 0) {
            Entry prev = this.entries.get(listIndex - 1);
            pos = prev.position + prev.size;
        }
        if ((long)(pos + bytes) >= this.capacity) {
            this.expandVBO();
        }
        Entry entry = new Entry(pos, bytes);
        if (listIndex > 0) {
            Entry previousEntry = this.entries.get(listIndex - 1);
            if (previousEntry.position + previousEntry.size > pos) {
                throw new RuntimeException("Entry collision: " + entry + " and " + previousEntry);
            }
        }
        if (listIndex < this.entries.size() - 1) {
            Entry nextEntry = this.entries.get(listIndex + 1);
            if (nextEntry.position <= pos + bytes) {
                throw new RuntimeException("Entry collision: " + entry + " and " + nextEntry);
            }
        }
        vertexData.buffer.flip();
        GL15.glBindBuffer((int)34962, (int)this.vbo);
        GL15.glBufferSubData((int)34962, (long)pos, (ByteBuffer)vertexData.buffer);
        GL15.glBindBuffer((int)34962, (int)0);
        this.entries.add(listIndex, entry);
        return entry;
    }

    private void expandVBO() {
        long prevCapacity = this.capacity;
        long newCapacity = this.capacity * 2L;
        if (newCapacity < this.capacity) {
            throw new RuntimeException();
        }
        LOGGER.warn("Expand VBO Buffer: " + newCapacity);
        OpenGLHelper.checkError("pre expand buffer");
        int newBuffer = GL15.glGenBuffers();
        GL15.glBindBuffer((int)34962, (int)newBuffer);
        GL15.glBufferData((int)34962, (long)newCapacity, (int)35044);
        OpenGLHelper.checkError("create expand buffer");
        if (OpenGLHelper.gl31) {
            GL15.glBindBuffer((int)36662, (int)this.vbo);
            GL15.glBindBuffer((int)36663, (int)newBuffer);
            GL31.glCopyBufferSubData((int)36662, (int)36663, (long)0L, (long)0L, (long)this.capacity);
            GL15.glBindBuffer((int)36662, (int)0);
            GL15.glBindBuffer((int)36663, (int)0);
        } else {
            int iPrevCapacity = (int)prevCapacity;
            int iNewCapacity = (int)newCapacity;
            if (iPrevCapacity < 0) {
                throw new RuntimeException("Previous capacity < 0");
            }
            if (iNewCapacity < 0) {
                throw new RuntimeException("New capacity < 0");
            }
            if (iNewCapacity < iPrevCapacity) {
                throw new RuntimeException("New capacity < previous capacity: " + iNewCapacity + " < " + iPrevCapacity);
            }
            ByteBuffer oldData = ByteBuffer.allocateDirect(iPrevCapacity).order(ByteOrder.nativeOrder());
            GL15.glBindBuffer((int)34962, (int)this.vbo);
            GL15.glGetBufferSubData((int)34962, (long)0L, (ByteBuffer)oldData);
            oldData.position(0);
            GL15.glBindBuffer((int)34962, (int)newBuffer);
            GL15.glBufferSubData((int)34962, (long)0L, (ByteBuffer)oldData);
        }
        OpenGLHelper.checkError("copy buffer");
        this.capacity = newCapacity;
        this.vbo = newBuffer;
    }

    public boolean removeEntry(Entry entry) {
        return this.entries.remove(entry);
    }

    public int getVbo() {
        return this.vbo;
    }

    public int entryCount() {
        return this.entries.size();
    }

    public class Entry {
        public final int position;
        public final int size;
        private final int hashCode;

        public Entry(int position, int size) {
            this.hashCode = VertexBuffer.this.entryHashCounter++;
            this.position = position;
            this.size = size;
        }

        public String toString() {
            return "VertexBufferEntry[position: " + this.position + ", size: " + this.size + "]";
        }

        public int hashCode() {
            return this.hashCode;
        }
    }
}

