/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.block.entity;

import com.mojang.nbt.tags.CompoundTag;
import com.mojang.nbt.tags.ListTag;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.block.entity.TileEntity;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.entity.EntityItem;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.item.Item;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.net.packet.Packet;
import net.minecraft.core.net.packet.PacketTileEntityData;
import net.minecraft.core.util.phys.AABB;
import net.minecraft.core.world.World;
import org.jetbrains.annotations.NotNull;

public class TileEntityBasket
extends TileEntity {
    private int numUnitsInside = 0;
    private final Map<BasketEntry, Integer> contents = new HashMap<BasketEntry, Integer>();

    private void updateNumUnits() {
        int prevNum = this.numUnitsInside;
        this.numUnitsInside = 0;
        for (Map.Entry<BasketEntry, Integer> entry : this.contents.entrySet()) {
            BasketEntry be = entry.getKey();
            int numItems = entry.getValue();
            int unitsPerItem = this.getItemSizeUnits(be.getItem());
            this.numUnitsInside += unitsPerItem * numItems;
        }
        if (prevNum != this.numUnitsInside && this.worldObj != null) {
            this.worldObj.notifyBlockChange(this.x, this.y, this.z, this.worldObj.getBlockId(this.x, this.y, this.z));
        }
    }

    private int getItemSizeUnits(Item item) {
        return 64 / item.getItemStackLimit(null);
    }

    private void dropItemStack(Random rand, ItemStack itemstack) {
        World workingWorld;
        float f = rand.nextFloat() * 0.8f + 0.1f;
        float f1 = rand.nextFloat() * 0.8f + 0.1f;
        float f2 = rand.nextFloat() * 0.8f + 0.1f;
        if (this.worldObj != null) {
            workingWorld = this.worldObj;
        } else if (this.carriedBlock != null) {
            workingWorld = this.carriedBlock.world;
        } else {
            return;
        }
        EntityItem item = new EntityItem(workingWorld, (float)this.x + f, (float)this.y + f1, (float)this.z + f2, itemstack);
        float f3 = 0.05f;
        item.xd = (float)rand.nextGaussian() * 0.05f;
        item.yd = (float)rand.nextGaussian() * 0.05f + 0.25f;
        item.zd = (float)rand.nextGaussian() * 0.05f;
        workingWorld.entityJoinedWorld(item);
    }

    public int getNumUnitsInside() {
        return this.numUnitsInside;
    }

    public int getMaxUnits() {
        return 1728;
    }

    public void givePlayerAllItems(World world, Player player) {
        ArrayList<BasketEntry> toRemove = new ArrayList<BasketEntry>();
        for (Map.Entry<BasketEntry, Integer> entry : this.contents.entrySet()) {
            BasketEntry basketEntry = entry.getKey();
            ItemStack basketEntryStack = new ItemStack(basketEntry.id, (int)entry.getValue(), basketEntry.metadata, basketEntry.tag);
            player.inventory.insertItem(basketEntryStack, true);
            this.contents.put(basketEntry, basketEntryStack.stackSize);
            if (basketEntryStack.stackSize > 0) continue;
            toRemove.add(basketEntry);
        }
        for (BasketEntry basketEntry : toRemove) {
            this.contents.remove(basketEntry);
        }
        this.updateNumUnits();
        world.notifyBlockChange(this.x, this.y, this.z, Blocks.BASKET.id());
    }

    @Override
    public void readAdditionalData(@NotNull CompoundTag compoundTag) {
        ListTag itemsTag = compoundTag.getList("Items");
        this.contents.clear();
        for (int i = 0; i < itemsTag.tagCount(); ++i) {
            CompoundTag itemTag = (CompoundTag)itemsTag.tagAt(i);
            BasketEntry entry = BasketEntry.read(itemTag);
            short count = itemTag.getShort("Count");
            this.contents.put(entry, Integer.valueOf(count));
        }
        this.updateNumUnits();
    }

    @Override
    public void tick() {
        double posZ;
        double posY;
        double posX;
        World workingWorld;
        if (this.worldObj != null && this.worldObj.isClientSide) {
            return;
        }
        if (this.carriedBlock != null && this.carriedBlock.world.isClientSide) {
            return;
        }
        if (this.worldObj != null) {
            workingWorld = this.worldObj;
            posX = this.x;
            posY = this.y;
            posZ = this.z;
        } else if (this.carriedBlock != null) {
            workingWorld = this.carriedBlock.world;
            posX = this.carriedBlock.holder.x - 0.5;
            posY = this.carriedBlock.holder.y - (double)this.carriedBlock.holder.heightOffset;
            posZ = this.carriedBlock.holder.z - 0.5;
        } else {
            return;
        }
        AABB aabb = AABB.getTemporaryBB(posX, posY, posZ, posX + 1.0, posY + 2.0, posZ + 1.0);
        List<EntityItem> entities = workingWorld.getEntitiesWithinAABB(EntityItem.class, aabb);
        boolean shouldUpdate = false;
        if (!entities.isEmpty()) {
            for (EntityItem e : entities) {
                if (e.item == null || e.item.stackSize <= 0 || e.basketPickupDelay != 0) continue;
                shouldUpdate = this.importItemStack(e.item);
                if (e.item.stackSize > 0) continue;
                e.item.stackSize = 0;
                e.outOfWorld();
            }
        }
        if (shouldUpdate) {
            if (this.worldObj != null) {
                this.worldObj.notifyBlockChange(this.x, this.y, this.z, Blocks.BASKET.id());
            }
            this.updateNumUnits();
        }
    }

    private boolean importItemStack(ItemStack stack) {
        BasketEntry entry = new BasketEntry(stack.itemID, stack.getMetadata(), stack.getData());
        int sizeUnits = this.getItemSizeUnits(stack.getItem());
        int freeUnits = this.getMaxUnits() - this.numUnitsInside;
        int itemsToTake = Math.min(freeUnits / sizeUnits, stack.stackSize);
        if (itemsToTake <= 0) {
            return false;
        }
        stack.stackSize -= itemsToTake;
        int currentItemsInBE = this.contents.getOrDefault(entry, 0);
        this.contents.put(entry, currentItemsInBE += itemsToTake);
        return true;
    }

    @Override
    public void writeAdditionalData(@NotNull CompoundTag compoundTag) {
        ListTag itemsTag = new ListTag();
        for (Map.Entry<BasketEntry, Integer> entry : this.contents.entrySet()) {
            CompoundTag itemTag = new CompoundTag();
            itemTag.putShort("Count", (short)entry.getValue().intValue());
            BasketEntry.write(itemTag, entry.getKey());
            itemsTag.addTag(itemTag);
        }
        compoundTag.put("Items", itemsTag);
    }

    @Override
    public Packet getDescriptionPacket() {
        return new PacketTileEntityData(this);
    }

    @Override
    public void dropContents(World world, int x, int y, int z) {
        super.dropContents(world, x, y, z);
        Random rand = new Random();
        for (Map.Entry<BasketEntry, Integer> entry : this.contents.entrySet()) {
            int stackSize;
            BasketEntry be = entry.getKey();
            for (int numItems = entry.getValue().intValue(); numItems > 0; numItems -= stackSize) {
                int maxStackSize;
                stackSize = maxStackSize = be.getItem().getItemStackLimit(null);
                int remainingItems = numItems - maxStackSize;
                if (remainingItems < 0) {
                    stackSize = numItems;
                }
                this.dropItemStack(rand, new ItemStack(be.id, stackSize, be.metadata, be.tag));
            }
        }
        this.contents.clear();
        world.notifyBlockChange(x, y, z, Blocks.BASKET.id());
        this.updateNumUnits();
    }

    @Override
    public void heldTick(World world, Entity holder) {
        this.tick();
    }

    @Override
    public boolean canBeCarried(World world, Entity potentialHolder) {
        return true;
    }

    private static final class BasketEntry {
        public final int id;
        public final int metadata;
        public final CompoundTag tag;

        public BasketEntry(int id, int metadata, CompoundTag tag) {
            this.id = id;
            this.metadata = metadata;
            this.tag = tag;
        }

        public static BasketEntry read(CompoundTag tag) {
            short id = tag.getShort("id");
            short damage = tag.getShort("Damage");
            CompoundTag data = tag.getCompound("Data");
            return new BasketEntry(id, damage, data);
        }

        public static void write(CompoundTag tag, BasketEntry entry) {
            tag.putShort("id", (short)entry.id);
            tag.putShort("Damage", (short)entry.metadata);
            tag.putCompound("Data", entry.tag);
        }

        public Item getItem() {
            return Item.itemsList[this.id];
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof BasketEntry)) {
                return false;
            }
            BasketEntry other = (BasketEntry)obj;
            if (this.id != other.id || this.metadata != other.metadata) {
                return false;
            }
            return this.tag.getValues().size() <= 2 && other.tag.getValues().size() <= 2;
        }

        public int hashCode() {
            if (this.tag.getValues().size() <= 2) {
                return Objects.hash(this.id, this.metadata);
            }
            return Objects.hash(this.id, this.metadata, this.tag);
        }
    }
}

