/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.net;

import com.mojang.logging.LogUtils;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.core.net.handler.PacketHandler;
import net.minecraft.core.net.packet.Packet;
import org.slf4j.Logger;

public class NetworkManager {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final boolean silent;
    public static int PACKET_DELAY = 100;
    public static int TIMEOUT_TIME_TICKS = 1800;
    public static final Object threadCounterLock = new Object();
    public static int readThreads;
    public static int writeThreads;
    private final Object writeLock;
    private Socket socket;
    private final SocketAddress address;
    private DataInputStream dis;
    private DataOutputStream dos;
    private boolean running;
    private final List<Packet> incoming;
    private final List<Packet> outgoing;
    private final List<Packet> outgoingSlow;
    private PacketHandler packetListener;
    private boolean quitting;
    private final Thread writeThread;
    private final Thread readThread;
    private boolean disconnected;
    private String disconnectReason;
    private Object[] disconnectReasonObjects;
    private int noInputTicks;
    private int estimatedRemaining;
    public int fakeLag;
    private int slowWriteDelay;

    public NetworkManager(Socket socket, String s, PacketHandler nethandler) throws IOException {
        this(socket, s, nethandler, false);
    }

    public NetworkManager(Socket socket, String s, PacketHandler nethandler, boolean silent) throws IOException {
        block2: {
            this.silent = silent;
            this.writeLock = new Object();
            this.running = true;
            this.incoming = Collections.synchronizedList(new ArrayList());
            this.outgoing = Collections.synchronizedList(new ArrayList());
            this.outgoingSlow = Collections.synchronizedList(new ArrayList());
            this.quitting = false;
            this.disconnected = false;
            this.disconnectReason = "";
            this.noInputTicks = 0;
            this.estimatedRemaining = 0;
            this.fakeLag = 0;
            this.slowWriteDelay = 0;
            this.socket = socket;
            this.address = socket.getRemoteSocketAddress();
            this.packetListener = nethandler;
            try {
                socket.setSoTimeout(TIMEOUT_TIME_TICKS * 1000 / 20);
                socket.setTrafficClass(24);
            }
            catch (SocketException socketexception) {
                if (silent) break block2;
                System.err.println(socketexception.getMessage());
            }
        }
        this.dis = new DataInputStream(socket.getInputStream());
        this.dos = new DataOutputStream(new BufferedOutputStream(socket.getOutputStream(), 65536));
        this.readThread = new Thread(s + " read thread"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Object object = threadCounterLock;
                synchronized (object) {
                    ++readThreads;
                }
                try {
                    while (NetworkManager.this.running && !NetworkManager.this.quitting) {
                        while (NetworkManager.this.readPacket()) {
                        }
                        try {
                            1.sleep(PACKET_DELAY);
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                }
                finally {
                    object = threadCounterLock;
                    synchronized (object) {
                        --readThreads;
                    }
                }
            }
        };
        this.writeThread = new Thread(s + " write thread"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void run() {
                Object object = threadCounterLock;
                synchronized (object) {
                    ++writeThreads;
                }
                try {
                    while (NetworkManager.this.running) {
                        while (NetworkManager.this.sendPacket()) {
                        }
                        try {
                            2.sleep(PACKET_DELAY);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        try {
                            if (NetworkManager.this.dos == null) continue;
                            NetworkManager.this.dos.flush();
                        }
                        catch (IOException e) {
                            if (!NetworkManager.this.disconnected) {
                                NetworkManager.this.onNetworkError(e);
                                continue;
                            }
                            LOGGER.error("IO Exception while flushing Data Output Stream!", e);
                        }
                    }
                    return;
                }
                finally {
                    object = threadCounterLock;
                    synchronized (object) {
                        --writeThreads;
                    }
                }
            }
        };
        this.readThread.start();
        this.writeThread.start();
    }

    public void setNetHandler(PacketHandler nethandler) {
        this.packetListener = nethandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addToSendQueue(Packet packet) {
        if (this.quitting) {
            return;
        }
        Object object = this.writeLock;
        synchronized (object) {
            this.estimatedRemaining += packet.getEstimatedSize() + 1;
            if (packet.isChunkDataPacket) {
                this.outgoingSlow.add(packet);
            } else {
                this.outgoing.add(packet);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean sendPacket() {
        boolean hasWrittenPacket;
        block10: {
            hasWrittenPacket = false;
            try {
                Packet packet;
                Object object;
                if (!(this.outgoing.isEmpty() || this.fakeLag != 0 && System.currentTimeMillis() - this.outgoing.get((int)0).creationTimeMillis < (long)this.fakeLag)) {
                    object = this.writeLock;
                    synchronized (object) {
                        packet = this.outgoing.remove(0);
                        this.estimatedRemaining -= packet.getEstimatedSize() + 1;
                    }
                    Packet.writePacket(packet, this.dos);
                    hasWrittenPacket = true;
                }
                if (this.slowWriteDelay-- > 0 || this.outgoingSlow.isEmpty() || this.fakeLag != 0 && System.currentTimeMillis() - this.outgoingSlow.get((int)0).creationTimeMillis < (long)this.fakeLag) break block10;
                object = this.writeLock;
                synchronized (object) {
                    packet = this.outgoingSlow.remove(0);
                    this.estimatedRemaining -= packet.getEstimatedSize() + 1;
                }
                Packet.writePacket(packet, this.dos);
                this.slowWriteDelay = 0;
                hasWrittenPacket = true;
            }
            catch (Exception exception) {
                if (!this.disconnected) {
                    this.onNetworkError(exception);
                }
                return false;
            }
        }
        return hasWrittenPacket;
    }

    public void wakeThreads() {
        this.readThread.interrupt();
        this.writeThread.interrupt();
    }

    private boolean readPacket() {
        boolean hasReadPacket = false;
        try {
            Packet packet = Packet.readPacket(this.dis, this.packetListener.isServerHandler());
            if (packet != null) {
                this.incoming.add(packet);
                hasReadPacket = true;
            } else {
                this.networkShutdown("disconnect.endOfStream", new Object[0]);
            }
        }
        catch (Exception exception) {
            if (!this.disconnected) {
                this.onNetworkError(exception);
            }
            return false;
        }
        return hasReadPacket;
    }

    private void onNetworkError(Exception exception) {
        if (!this.silent) {
            LOGGER.error("Unexpected network error!", exception);
        }
        this.networkShutdown("disconnect.genericReason", new Object[]{"Internal exception: " + exception.toString()});
    }

    public void networkShutdown(String reason, Object[] reasonObjects) {
        if (!this.running) {
            return;
        }
        this.disconnected = true;
        this.disconnectReason = reason;
        this.disconnectReasonObjects = reasonObjects;
        new Thread(() -> {
            try {
                Thread.sleep(5000L);
                if (this.readThread.isAlive()) {
                    try {
                        this.readThread.stop();
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
                if (this.writeThread.isAlive()) {
                    try {
                        this.writeThread.stop();
                    }
                    catch (Throwable throwable) {}
                }
            }
            catch (InterruptedException e) {
                LOGGER.error("Interrupted while stopping read/write threads!", e);
            }
        }).start();
        this.running = false;
        try {
            this.dis.close();
            this.dis = null;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            this.dos.close();
            this.dos = null;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            this.socket.close();
            this.socket = null;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void processReadPackets() {
        if (this.estimatedRemaining > 0x100000) {
            this.networkShutdown("disconnect.overflow", new Object[0]);
        }
        if (this.incoming.isEmpty()) {
            if (this.noInputTicks++ == TIMEOUT_TIME_TICKS) {
                this.networkShutdown("disconnect.timeout", new Object[0]);
            }
        } else {
            this.noInputTicks = 0;
        }
        for (int i = 100; !this.incoming.isEmpty() && i >= 0; --i) {
            Packet packet = this.incoming.remove(0);
            if (this.disconnected) continue;
            packet.handlePacket(this.packetListener);
        }
        this.wakeThreads();
        if (this.disconnected && this.incoming.isEmpty()) {
            this.packetListener.handleErrorMessage(this.disconnectReason, this.disconnectReasonObjects);
        }
    }

    public SocketAddress getRemoteAddress() {
        return this.address;
    }

    public void serverShutdown() {
        this.wakeThreads();
        this.quitting = true;
        this.readThread.interrupt();
        new Thread(() -> {
            try {
                Thread.sleep(2000L);
                if (this.running) {
                    this.writeThread.interrupt();
                    this.networkShutdown("disconnect.closed", new Object[0]);
                }
            }
            catch (Exception exception) {
                LOGGER.error("Exception on Server Shutdown!", exception);
            }
        }).start();
    }

    public int getNumChunkDataPackets() {
        return this.outgoingSlow.size();
    }
}

