/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.net.packet;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import net.minecraft.core.net.handler.PacketHandler;
import net.minecraft.core.net.packet.Packet;
import net.minecraft.core.util.HardIllegalArgumentException;
import net.minecraft.core.util.collection.NamespaceID;

public class PacketStatistic
extends Packet {
    public NamespaceID statID;
    public int valueChange;

    public PacketStatistic() {
    }

    public PacketStatistic(NamespaceID statID, int change) {
        this.statID = statID;
        this.valueChange = change;
    }

    @Override
    public void handlePacket(PacketHandler packetHandler) {
        packetHandler.handleStatistic(this);
    }

    @Override
    public void read(DataInputStream dis) throws IOException {
        try {
            this.statID = new NamespaceID(PacketStatistic.readStringUTF8(dis, Integer.MAX_VALUE));
        }
        catch (HardIllegalArgumentException e) {
            this.statID = null;
        }
        this.valueChange = dis.readByte();
    }

    @Override
    public void write(DataOutputStream dos) throws IOException {
        PacketStatistic.writeStringUTF8(this.statID.toString(), dos);
        dos.writeByte(this.valueChange);
    }

    @Override
    public int getEstimatedSize() {
        return 6;
    }
}

