/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.console.shell;

import bsh.EvalError;
import bsh.Interpreter;
import com.mojang.logging.LogUtils;
import net.minecraft.client.console.shell.RawOutputWrapper;
import net.minecraft.client.console.shell.commands.reloadScripts;
import net.minecraft.core.net.command.TextFormatting;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public final class RuntimeExecutor {
    private static final Logger LOGGER = LogUtils.getLogger();
    @NotNull
    private final Interpreter interpreter = new Interpreter();

    public RuntimeExecutor() {
        reloadScripts.invoke(this.interpreter, null);
    }

    @NotNull
    public String runCode(@NotNull String line) {
        StringBuilder sb = new StringBuilder();
        if (line.equalsIgnoreCase("help") || line.equals("?")) {
            sb.append(TextFormatting.WHITE).append("[ Better than Adventure! Developer Console ]\n").append(TextFormatting.LIGHT_GRAY).append("This is a BeanShell-powered developer shell for Better than Adventure!, ").append("which allows you to view and modify most of the game's objects through ").append("interpreted Java code.\n").append(TextFormatting.YELLOW).append("If you don't know what any of this means, it's probably best to close this ").append("window.\n").append("\n").append("Along with BeanShell's default command set, this shell provides some extra ").append("commands to make interfacing with BTA! easier.\n").append(" - ").append(TextFormatting.WHITE).append("Minecraft ").append(TextFormatting.LIGHT_BLUE).append("mc").append(TextFormatting.WHITE).append("();\n").append("       ").append("Fetches the current Minecraft object.\n").append(" - ").append(TextFormatting.ORANGE).append("void ").append(TextFormatting.LIGHT_BLUE).append("fields").append(TextFormatting.WHITE).append("(Object o);\n").append("   ").append(TextFormatting.ORANGE).append("void ").append(TextFormatting.LIGHT_BLUE).append("fields").append(TextFormatting.WHITE).append("(Class<?> clazz);\n").append("       ").append("Displays all the fields of a given object or class.\n").append(" - ").append(TextFormatting.ORANGE).append("void ").append(TextFormatting.LIGHT_BLUE).append("methods").append(TextFormatting.WHITE).append("(Object o);\n").append("   ").append(TextFormatting.ORANGE).append("void ").append(TextFormatting.LIGHT_BLUE).append("methods").append(TextFormatting.WHITE).append("(Class<?> clazz);\n").append("       ").append("Displays all the methods of a given object or class.\n").append(" - ").append(TextFormatting.ORANGE).append("void ").append(TextFormatting.LIGHT_BLUE).append("logEnable").append(TextFormatting.WHITE).append("(String category);\n").append("       ").append("Enables a given logging category.\n").append(" - ").append(TextFormatting.ORANGE).append("void ").append(TextFormatting.LIGHT_BLUE).append("logDisable").append(TextFormatting.WHITE).append("(String category);\n").append("       ").append("Disables a given logging category.\n").append(" - ").append(TextFormatting.ORANGE).append("void ").append(TextFormatting.LIGHT_BLUE).append("logList").append(TextFormatting.WHITE).append("();\n").append("       ").append("Displays all known logging categories.\n");
            return sb.toString();
        }
        try {
            @Nullable Object result = this.interpreter.eval(line);
            sb.append(TextFormatting.WHITE);
            if (result == null) {
                sb.append(TextFormatting.ORANGE).append("null");
            } else if (result instanceof RawOutputWrapper) {
                sb.append(((RawOutputWrapper)result).value);
            } else if (result.getClass().isPrimitive()) {
                sb.append(TextFormatting.LIGHT_BLUE).append(result);
            } else if (result instanceof String) {
                sb.append(TextFormatting.GREEN).append("\"").append(result).append("\"");
            } else {
                sb.append(result);
            }
        }
        catch (EvalError e) {
            sb.append(TextFormatting.RED).append(e);
        }
        catch (Throwable t) {
            sb.append(TextFormatting.RED).append("Caught exception: ").append(t);
        }
        return sb.toString();
    }
}

