/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui;

import java.util.Map;
import net.minecraft.client.gui.Screen;
import net.minecraft.client.render.font.Alignment;
import net.minecraft.client.render.font.Fonts;
import net.minecraft.client.render.tessellator.Tessellator;
import net.minecraft.core.net.ChatEmotes;
import net.minecraft.core.util.collection.NamespaceID;
import net.minecraft.core.util.helper.ChatAllowedCharacters;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.input.Mouse;

public class ScreenFontTest
extends Screen {
    private static final char[] chars = new char[]{'H', 'e', 'l', 'l', 'o', ' ', 'W', 'o', 'r', 'l', 'd', '!'};
    @NotNull
    private static final NamespaceID testId = NamespaceID.getPermanent("test", "value");
    @NotNull
    private static final StringBuilder builder = new StringBuilder();
    public double scroll = 0.0;

    public ScreenFontTest(@Nullable Screen parent) {
        super(parent);
    }

    @Override
    public void render(int mx, int my, float partialTick) {
        this.renderTexturedBackground();
        super.render(mx, my, partialTick);
        this.scroll += (double)(Mouse.getDWheel() * this.fontRenderer.getFont().fontHeight());
        int maxWidth = (int)((double)this.width / 1.2);
        this.drawRect((this.width - maxWidth) / 2, 0, (this.width + maxWidth) / 2, this.height, -14474461);
        long start = System.currentTimeMillis();
        builder.setLength(0);
        builder.append("\u00a70\u00a70\u00a70\u00a70\u00a7<AAAAFF>");
        for (int i = 0; i < 1000; ++i) {
            builder.append("a");
        }
        builder.append("\n").append(ChatAllowedCharacters.ALLOWED_CHARACTERS);
        builder.append("\n").append("\u00a7rItalic test: \u00a7oTEST STRING");
        builder.append("\n").append("\u00a7rBold test: \u00a7lTEST STRING");
        builder.append("\n").append("\u00a7rUnderline test: \u00a7nTEST STRING");
        builder.append("\n").append("\u00a7rStrikethrough test: \u00a7mTEST STRING");
        builder.append("\n").append("\u00a7rObfuscation test: \u00a7kTEST STRING Static \u00a7rText");
        builder.append("\n").append("\u00a7rAll No Obf test: \u00a7o\u00a7l\u00a7n\u00a7mTEST STRING");
        builder.append("\n").append("\u00a7rAll test: \u00a7k\u00a7o\u00a7l\u00a7n\u00a7mTEST STRING\u00a7r");
        builder.append("\n").append("\tTab");
        builder.append("\n").append("\t\tTabTab");
        builder.append("\n").append("   TripleSpace");
        for (Map.Entry<String, Character> entry : ChatEmotes.getEmotes().entrySet()) {
            builder.append("\n").append(entry.getKey().replace(":", "")).append(": ").append(entry.getValue());
        }
        builder.append("\n\u00a7bLorem ipsum dolor sit amet, \u00a7+\u00a73consectetur adipiscing elit, sed do eiusmod tempor incididunt \u00a7+\u00a71ut labore et \u00a7+\u00a7rdolore magna aliqua.\u00a7- Ut enim \u00a7-ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut \u00a7-aliquip ex ea commodo consequat. Duis aute irure dolor in \u00a7+\u00a7rreprehenderit in voluptate velit esse cillum dolore \u00a7-eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum. \nTest String1!");
        this.fontRenderer.renderWidthConstrained(Tessellator.instance, builder, (this.width - maxWidth) / 2, (int)(10.0 + this.scroll), maxWidth).setAlignment(Alignment.LEFT).setColor(0xFFAAFF).setShadow().call();
        long bigStringRenderTime = System.currentTimeMillis() - start;
        this.fontRenderer.render(Tessellator.instance, (float)bigStringRenderTime / 1000.0f + "s", (this.width - maxWidth) / 2, this.fontRenderer.getLastEndingY() + 20).call();
        long memTotal = Runtime.getRuntime().totalMemory();
        long memFree = Runtime.getRuntime().freeMemory();
        long memUsed = memTotal - memFree;
        this.fontRenderer.render(Tessellator.instance, memUsed / 0x100000L + "MB", (this.width - maxWidth) / 2, this.fontRenderer.getLastEndingY()).call();
        this.fontRenderer.render(Tessellator.instance, "Unicode: Better than Adventure", (this.width - maxWidth) / 2, this.fontRenderer.getLastEndingY()).setFont(Fonts.UNICODE).call();
        this.fontRenderer.render(Tessellator.instance, "Default: Better than Adventure", (this.width - maxWidth) / 2, this.fontRenderer.getLastEndingY()).setFont(Fonts.DEFAULT).call();
        this.fontRenderer.render(Tessellator.instance, "Monospace: Better than Adventure", (this.width - maxWidth) / 2, this.fontRenderer.getLastEndingY()).setFont(Fonts.MONOSPACE).call();
        int y = this.fontRenderer.getLastEndingY() + 10;
        this.fontRenderer.render(Tessellator.instance, "String: ", (this.width - maxWidth) / 2, y).setColor(0xFFAAFF).call();
        this.fontRenderer.render(Tessellator.instance, "Test String", this.fontRenderer.getLastEndingX(), y).call();
        y = this.fontRenderer.getLastEndingY();
        this.fontRenderer.render(Tessellator.instance, "null (Object): ", (this.width - maxWidth) / 2, y).setColor(0xFFAAFF).call();
        this.fontRenderer.render(Tessellator.instance, (Object)null, this.fontRenderer.getLastEndingX(), y).call();
        y = this.fontRenderer.getLastEndingY();
        this.fontRenderer.render(Tessellator.instance, "object: ", (this.width - maxWidth) / 2, y).setColor(0xFFAAFF).call();
        this.fontRenderer.render(Tessellator.instance, testId, this.fontRenderer.getLastEndingX(), y).call();
        y = this.fontRenderer.getLastEndingY();
        this.fontRenderer.render(Tessellator.instance, "boolean: ", (this.width - maxWidth) / 2, y).setColor(0xFFAAFF).call();
        this.fontRenderer.render(Tessellator.instance, true, this.fontRenderer.getLastEndingX(), y).call();
        y = this.fontRenderer.getLastEndingY();
        this.fontRenderer.render(Tessellator.instance, "int: ", (this.width - maxWidth) / 2, y).setColor(0xFFAAFF).call();
        this.fontRenderer.render(Tessellator.instance, 15, this.fontRenderer.getLastEndingX(), y).call();
        y = this.fontRenderer.getLastEndingY();
        this.fontRenderer.render(Tessellator.instance, "long: ", (this.width - maxWidth) / 2, y).setColor(0xFFAAFF).call();
        this.fontRenderer.render(Tessellator.instance, 1500L, this.fontRenderer.getLastEndingX(), y).call();
        y = this.fontRenderer.getLastEndingY();
        this.fontRenderer.render(Tessellator.instance, "char: ", (this.width - maxWidth) / 2, y).setColor(0xFFAAFF).call();
        this.fontRenderer.render(Tessellator.instance, 'a', this.fontRenderer.getLastEndingX(), y).call();
        y = this.fontRenderer.getLastEndingY();
        this.fontRenderer.render(Tessellator.instance, "float: ", (this.width - maxWidth) / 2, y).setColor(0xFFAAFF).call();
        this.fontRenderer.render(Tessellator.instance, 0.5f, this.fontRenderer.getLastEndingX(), y).call();
        y = this.fontRenderer.getLastEndingY();
        this.fontRenderer.render(Tessellator.instance, "double: ", (this.width - maxWidth) / 2, y).setColor(0xFFAAFF).call();
        this.fontRenderer.render(Tessellator.instance, 0.5, this.fontRenderer.getLastEndingX(), y).call();
        y = this.fontRenderer.getLastEndingY();
        this.fontRenderer.render(Tessellator.instance, "char array: ", (this.width - maxWidth) / 2, y).setColor(0xFFAAFF).call();
        this.fontRenderer.render(Tessellator.instance, chars, this.fontRenderer.getLastEndingX(), y).call();
        y = this.fontRenderer.getLastEndingY();
        double mouseX = (double)(Mouse.getX() * this.mc.resolution.getScaledWidthScreenCoords()) / (double)this.mc.resolution.getWidthScreenCoords();
        double mouseY = (double)this.mc.resolution.getScaledHeightScreenCoords() - (double)(Mouse.getY() * this.mc.resolution.getScaledHeightScreenCoords()) / (double)this.mc.resolution.getHeightScreenCoords();
        this.fontRenderer.renderDouble(Tessellator.instance, "Double Precision", mouseX - this.fontRenderer.stringWidthDouble("Double Precision") - 3.0, mouseY - 6.0).setShadow().call();
        this.fontRenderer.render(Tessellator.instance, "Int Precision", (int)(mouseX + 3.0), (int)(mouseY - 5.0)).setShadow().call();
    }
}

