/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.hud;

import com.mojang.logging.LogUtils;
import java.awt.Color;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.PlayerLocalMultiplayer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.HeldItemTooltipElement;
import net.minecraft.client.gui.ScreenPhotoMode;
import net.minecraft.client.gui.chat.ScreenChat;
import net.minecraft.client.gui.hud.component.HudComponent;
import net.minecraft.client.gui.hud.component.HudComponents;
import net.minecraft.client.render.Lighting;
import net.minecraft.client.render.block.model.BlockModel;
import net.minecraft.client.render.block.model.BlockModelDispatcher;
import net.minecraft.client.render.dynamictexture.DynamicTexture;
import net.minecraft.client.render.font.FontRenderer;
import net.minecraft.client.render.item.model.ItemModelDispatcher;
import net.minecraft.client.render.terrain.RenderList;
import net.minecraft.client.render.terrain.RenderRegion;
import net.minecraft.client.render.terrain.TerrainRendererMultiDraw;
import net.minecraft.client.render.tessellator.Tessellator;
import net.minecraft.client.render.texture.stitcher.IconCoordinate;
import net.minecraft.client.render.texture.stitcher.TextureRegistry;
import net.minecraft.core.Global;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.block.tag.BlockTags;
import net.minecraft.core.data.registry.Registries;
import net.minecraft.core.data.tag.Tag;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.enums.ChatVisibility;
import net.minecraft.core.enums.HumanArmorShape;
import net.minecraft.core.enums.LightLayer;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.item.Items;
import net.minecraft.core.lang.I18n;
import net.minecraft.core.net.ChatLine;
import net.minecraft.core.net.command.TextFormatting;
import net.minecraft.core.player.gamemode.Gamemode;
import net.minecraft.core.util.helper.Direction;
import net.minecraft.core.util.helper.MathHelper;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.util.helper.Utils;
import net.minecraft.core.world.season.Season;
import net.minecraft.core.world.weather.Weather;
import net.minecraft.core.world.wind.WindProvider;
import org.jetbrains.annotations.NotNull;
import org.lwjgl.Version;
import org.lwjgl.opengl.GL11;
import org.slf4j.Logger;

public class HudIngame
extends Gui {
    public static final float DEBUG_SCALE = 1.0f;
    public static final int MAX_CHAT_WIDTH = 320;
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final Direction[] directions = new Direction[]{Direction.NORTH, Direction.EAST, Direction.SOUTH, Direction.WEST};
    @NotNull
    private final @NotNull List<@NotNull ChatLine> chatMessageList = new ArrayList<ChatLine>();
    protected Minecraft mc;
    public int updateCounter = 0;
    private String recordPlaying = "";
    private int recordPlayingUpFor = 0;
    private boolean colorString = false;
    public float damageGuiPartialTime;
    float prevVignetteBrightness = 1.0f;
    protected FontRenderer fontRenderer;
    public int chatScroll = 0;
    public final HeldItemTooltipElement heldItemTooltipElement;
    private int debugLine = 0;
    private int debugLineRight = 0;
    private int debugOffset = 0;
    private int debugOffsetRight = 0;
    private final int debugLineHeight = 10;
    private final List<String> playerListScoreStrings = new ArrayList<String>();

    public HudIngame(Minecraft minecraft) {
        this.mc = minecraft;
        this.fontRenderer = this.mc.font;
        this.heldItemTooltipElement = new HeldItemTooltipElement(this.mc);
    }

    public void renderGameOverlay(float partialTicks, boolean flag, int mouseX, int mouseY) {
        ItemStack heldItemStack;
        float portalIntensity;
        if (this.mc.currentScreen instanceof ScreenPhotoMode) {
            return;
        }
        I18n stringtranslate = I18n.getInstance();
        int width = this.mc.resolution.getScaledWidthScreenCoords();
        int height = this.mc.resolution.getScaledHeightScreenCoords();
        int sp = (int)(((Float)this.mc.gameSettings.screenPadding.value).floatValue() * (float)height / 8.0f);
        this.mc.worldRenderer.setupScaledResolution();
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        if (this.mc.gameSettings.immersiveMode.drawVignette() && ((Boolean)this.mc.gameSettings.vignette.value).booleanValue()) {
            this.renderVignette(this.mc.thePlayer.getBrightness(partialTicks), width, height);
        }
        ItemStack headSlotItem = this.mc.thePlayer.inventory.armorItemInSlot(HumanArmorShape.HEAD);
        if ((Integer)this.mc.gameSettings.thirdPersonView.value == 0 && headSlotItem != null && (headSlotItem.itemID == Blocks.PUMPKIN_CARVED_IDLE.id() || headSlotItem.itemID == Blocks.PUMPKIN_REDSTONE.id())) {
            this.renderPumpkinBlur(width, height);
        }
        if ((portalIntensity = MathHelper.lerp(this.mc.thePlayer.prevTimeInPortal, this.mc.thePlayer.timeInPortal, partialTicks)) > 0.0f) {
            this.renderPortalOverlay(portalIntensity, width, height);
        }
        for (HudComponent component : HudComponents.INSTANCE.getComponents()) {
            if (!component.isVisible(this.mc)) continue;
            component.render(this.mc, this, width - sp * 2, height - sp * 2, partialTicks);
        }
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Lighting.disable();
        GL11.glDisable((int)32826);
        if (this.mc.thePlayer.getSleepTimer() > 0) {
            GL11.glDisable((int)2929);
            GL11.glDisable((int)3008);
            int i2 = this.mc.thePlayer.getSleepTimer();
            float f3 = (float)i2 / 100.0f;
            if (f3 > 1.0f) {
                f3 = 1.0f - (float)(i2 - 100) / 10.0f;
            }
            int j4 = (int)(220.0f * f3) << 24 | 0x101020;
            this.drawRect(0, 0, width, height, j4);
            GL11.glEnable((int)3008);
            GL11.glEnable((int)2929);
        }
        if (this.mc.gameSettings.immersiveMode.drawOverlays()) {
            this.drawRecordPlayingOverlay(width, height - sp, partialTicks);
            int tsp = 2 + sp;
            int line = 0;
            int lineHeight = 10;
            boolean clock = false;
            boolean compass = false;
            boolean rotaryCalendar = false;
            if (this.mc.thePlayer.getGamemode() == Gamemode.creative) {
                clock = true;
                compass = true;
                rotaryCalendar = true;
            } else {
                for (int iinv = 0; iinv < this.mc.thePlayer.inventory.getContainerSize(); ++iinv) {
                    ItemStack item = this.mc.thePlayer.inventory.getItem(iinv);
                    if (item == null) continue;
                    if (item.itemID == Items.TOOL_CLOCK.id) {
                        clock = true;
                    }
                    if (item.itemID == Items.TOOL_COMPASS.id) {
                        compass = true;
                    }
                    if (item.itemID != Items.TOOL_CALENDAR.id) continue;
                    rotaryCalendar = true;
                }
            }
            if (!((Boolean)this.mc.gameSettings.showDebugScreen.value).booleanValue()) {
                this.drawPlayerList(width, height, sp);
            }
            if (((Boolean)this.mc.gameSettings.showDebugScreen.value).booleanValue()) {
                GL11.glPushMatrix();
                GL11.glEnable((int)3042);
                GL11.glBlendFunc((int)770, (int)771);
                GL11.glScalef((float)1.0f, (float)1.0f, (float)1.0f);
                this.debugLine = 0;
                this.debugLineRight = 0;
                this.debugOffset = 0;
                this.debugOffsetRight = 0;
                long memMax = Runtime.getRuntime().maxMemory();
                long memTotal = Runtime.getRuntime().totalMemory();
                long memFree = Runtime.getRuntime().freeMemory();
                long memUsed = memTotal - memFree;
                int space = 6;
                this.drawDebugScreenLineRight("Used memory: " + memUsed * 100L / memMax + "% (" + memUsed / 1024L / 1024L + "MB) of " + memMax / 1024L / 1024L + "MB");
                this.drawDebugScreenLineRight("Allocated memory: " + memTotal * 100L / memMax + "% (" + memTotal / 1024L / 1024L + "MB)");
                this.drawDebugScreenLineRight("JRE: " + System.getProperty("java.version") + " (" + System.getProperty("java.vendor") + ")");
                this.drawDebugScreenLineRight("LWJGL version: " + Version.getVersion());
                this.debugOffsetRight += space;
                this.drawDebugScreenLineRight(GL11.glGetString((int)7936));
                this.drawDebugScreenLineRight(GL11.glGetString((int)7937));
                this.drawDebugScreenLineRight(GL11.glGetString((int)7938));
                this.drawDebugScreenLineRight("Resolution: " + this.mc.gameWindow.getWidthPixels() + "x" + this.mc.gameWindow.getHeightPixels());
                this.drawDebugScreenLineRight("Render Resolution: " + this.mc.renderer.getRenderWidth() + "x" + this.mc.renderer.getRenderHeight());
                this.drawDebugScreenLine("Better than Adventure! " + Minecraft.VERSION);
                this.drawDebugScreenLine(this.mc.debug);
                if (this.mc.terrainRenderer instanceof TerrainRendererMultiDraw) {
                    TerrainRendererMultiDraw terrainRenderer = (TerrainRendererMultiDraw)this.mc.terrainRenderer;
                    int regionCount = terrainRenderer.regionBuffer.size();
                    int playerX = MathHelper.floor(this.mc.thePlayer.x);
                    int playerZ = MathHelper.floor(this.mc.thePlayer.z);
                    List<RenderRegion> allRegions = terrainRenderer.regionBuffer.getAllRegions();
                    int totalEntries = 0;
                    int visibleEntries = 0;
                    for (int i = 0; i < allRegions.size(); ++i) {
                        RenderRegion region = allRegions.get(i);
                        for (int j = 0; j < region.renderLists.length; ++j) {
                            RenderList renderList = region.renderLists[j];
                            if (renderList == null) continue;
                            totalEntries += renderList.size();
                            visibleEntries += renderList.visibleEntryCount();
                        }
                    }
                    this.drawDebugScreenLine("R: " + regionCount + " D: " + terrainRenderer.getTotalDrawCalls() + " T: " + visibleEntries + "/" + totalEntries + " VBO: " + terrainRenderer.vertexBuffer.entryCount());
                    RenderRegion currentRegion = terrainRenderer.getRenderRegionAtBlockPos(playerX, playerZ);
                    totalEntries = 0;
                    visibleEntries = 0;
                    for (int j = 0; j < currentRegion.renderLists.length; ++j) {
                        RenderList renderList = currentRegion.renderLists[j];
                        if (renderList == null) continue;
                        totalEntries += renderList.size();
                        visibleEntries += renderList.visibleEntryCount();
                    }
                    this.drawDebugScreenLine("CR: " + currentRegion + " E: " + visibleEntries + "/" + totalEntries);
                } else {
                    this.drawDebugScreenLine(this.mc.getRendererDebugInfo());
                }
                this.drawDebugScreenLine(this.mc.getEntityDebugInfoString());
                this.drawDebugScreenLine(this.mc.getEntityCountsInfoString());
                this.drawDebugScreenLine(this.mc.getChunkProviderInfoString());
                this.debugOffset += space;
                this.debugOffsetRight += space;
                if (compass) {
                    this.drawDebugScreenLine("X: " + this.mc.thePlayer.x);
                    this.drawDebugScreenLine("Y: " + this.mc.thePlayer.y);
                    this.drawDebugScreenLine("Z: " + this.mc.thePlayer.z);
                    int chunkX = MathHelper.floor(this.mc.thePlayer.x) >> 4;
                    int chunkZ = MathHelper.floor(this.mc.thePlayer.z) >> 4;
                    this.drawDebugScreenLine("Chunk: " + chunkX + ", " + chunkZ);
                    int yaw = DynamicTexture.pmod(Math.round(this.mc.thePlayer.yRot), 360);
                    int pitch = Math.round(this.mc.thePlayer.xRot);
                    this.drawDebugScreenLine("Facing: " + yaw + "\u00b0, " + pitch + "\u00b0 (" + I18n.getInstance().translateKey(HudIngame.getFacingDirection(this.mc.thePlayer).getTranslationKey()) + ")");
                } else {
                    this.drawDebugScreenLine("Hold a compass for more information");
                }
                if (clock) {
                    if (!compass) {
                        this.debugOffset += space;
                    }
                    int playerX = MathHelper.floor(this.mc.thePlayer.x);
                    int playerY = MathHelper.floor(this.mc.thePlayer.y);
                    int playerZ = MathHelper.floor(this.mc.thePlayer.z);
                    this.drawDebugScreenLine("Light: Sky: " + this.mc.currentWorld.getSavedLightValue(LightLayer.Sky, playerX, playerY, playerZ) + " Block: " + this.mc.currentWorld.getSavedLightValue(LightLayer.Block, playerX, playerY, playerZ));
                }
                this.debugOffset += space;
                this.drawDebugScreenLine("Entities: " + this.mc.currentWorld.getLoadedEntityList().size());
                this.drawDebugScreenLine("Tile Entities: " + this.mc.currentWorld.getLoadedTileEntityList().size());
                this.debugOffset += space;
                if (clock) {
                    this.drawDebugScreenLine("Time: " + this.getTimeString() + " (Day " + this.mc.currentWorld.getWorldTime() / 24000L + ")");
                } else {
                    this.drawDebugScreenLine("Hold a clock for more information");
                }
                this.debugOffset += space;
                if (rotaryCalendar) {
                    Season season = this.mc.currentWorld.getSeasonManager().getCurrentSeason();
                    String seasonString = season != null ? season.getTranslatedName() : "None";
                    Weather weather = this.mc.currentWorld.getCurrentWeather();
                    String weatherString = weather != null ? stringtranslate.translateKey(weather.getNameLanguageKey()) : "None";
                    int blockX = MathHelper.floor(this.mc.thePlayer.x);
                    int blockY = MathHelper.floor(this.mc.thePlayer.y);
                    int blockZ = MathHelper.floor(this.mc.thePlayer.z);
                    this.drawDebugScreenLine("Season: " + seasonString);
                    this.drawDebugScreenLine("Weather: " + weatherString + " (" + this.mc.currentWorld.weatherManager.getWeatherDuration() / 20L + "s I: " + Utils.percentRound(this.mc.currentWorld.weatherManager.getWeatherIntensity()) + "% P: " + Utils.percentRound(this.mc.currentWorld.weatherManager.getWeatherPower()) + "%)");
                    this.drawDebugScreenLine("Biome: " + Registries.BIOMES.getKey(this.mc.currentWorld.getBlockBiome(blockX, blockY, blockZ)));
                    float temperature = (float)Utils.floor100(this.mc.currentWorld.getBlockTemperature(blockX, blockZ));
                    float humidity = (float)Utils.floor100(this.mc.currentWorld.getBlockHumidity(blockX, blockZ));
                    this.drawDebugScreenLine("Temperature: " + temperature + " Humidity: " + humidity);
                    WindProvider windProvider = this.mc.currentWorld.worldType.getWindManager();
                    if (windProvider != null) {
                        float direction = (float)Utils.floor100(windProvider.getWindDirection(this.mc.currentWorld, 0.0f, 500.0f, 0.0f));
                        float intensity = (float)Utils.floor100(windProvider.getWindIntensity(this.mc.currentWorld, 0.0f, 500.0f, 0.0f));
                        int yaw = DynamicTexture.pmod(Math.round(direction * 360.0f + 270.0f), 360);
                        this.drawDebugScreenLine("Wind: " + yaw + "\u00b0, " + Math.round(intensity * 100.0f) + "%");
                    }
                } else {
                    this.drawDebugScreenLine("Hold a rotary calendar for more information");
                }
                this.debugOffset += space;
                this.drawDebugScreenLine("Seed: " + this.mc.currentWorld.getRandomSeed());
                this.debugOffset += space;
                this.drawDebugScreenLine("CTRL + F3: Show Frametimes");
                this.drawDebugScreenLine("F3 + Q: Show Keyboard Shortcuts");
                if (this.mc.objectMouseOver != null && this.mc.objectMouseOver.entity == null) {
                    this.debugOffset += space;
                    Block<?> block = Blocks.blocksList[this.mc.currentWorld.getBlockId(this.mc.objectMouseOver.x, this.mc.objectMouseOver.y, this.mc.objectMouseOver.z)];
                    if (block.id() > 0 && block.id() < Blocks.blocksList.length) {
                        String name;
                        this.drawDebugScreenLineRight("Looking at:");
                        int meta = this.mc.currentWorld.getBlockMetadata(this.mc.objectMouseOver.x, this.mc.objectMouseOver.y, this.mc.objectMouseOver.z);
                        try {
                            name = block.asItem().getTranslatedName(new ItemStack(block, 1, meta));
                        }
                        catch (Exception e) {
                            name = "<ERROR>";
                        }
                        String id = block.namespaceId() + " [" + block.id() + ":" + meta + "]";
                        this.drawDebugScreenLineRight(name);
                        this.drawDebugScreenLineRight(block.getLanguageKey(meta));
                        this.drawDebugScreenLineRight(id);
                        if (compass) {
                            this.drawDebugScreenLineRight("[" + this.mc.objectMouseOver.x + ", " + this.mc.objectMouseOver.y + ", " + this.mc.objectMouseOver.z + "]");
                        }
                        this.drawDebugScreenLineRight("Harvest: " + this.mc.thePlayer.canHarvestBlock(block));
                        if (clock) {
                            int lightX = this.mc.objectMouseOver.x;
                            int lightY = this.mc.objectMouseOver.y;
                            int lightZ = this.mc.objectMouseOver.z;
                            Side side = this.mc.objectMouseOver.side;
                            this.drawDebugScreenLineRight("Light: Sky: " + this.mc.currentWorld.getSavedLightValue(LightLayer.Sky, lightX += side.getOffsetX(), lightY += side.getOffsetY(), lightZ += side.getOffsetZ()) + " Block: " + this.mc.currentWorld.getSavedLightValue(LightLayer.Block, lightX, lightY, lightZ));
                        }
                        this.drawDebugScreenLineRight("Signal: " + this.mc.currentWorld.getSignal(this.mc.objectMouseOver.x, this.mc.objectMouseOver.y, this.mc.objectMouseOver.z, this.mc.objectMouseOver.side));
                        this.drawDebugScreenLineRight("Direct signal: " + this.mc.currentWorld.getDirectSignal(this.mc.objectMouseOver.x, this.mc.objectMouseOver.y, this.mc.objectMouseOver.z, this.mc.objectMouseOver.side));
                        for (Tag<Block<?>> tag : BlockTags.TAG_LIST) {
                            if (!tag.appliesTo(block)) continue;
                            this.drawDebugScreenLineRight(tag.getName());
                        }
                    }
                }
                GL11.glPopMatrix();
            }
            if (!((Boolean)this.mc.gameSettings.showDebugScreen.value).booleanValue()) {
                if (((Boolean)this.mc.gameSettings.versionInOverlay.value).booleanValue()) {
                    int color = (Integer)this.mc.gameSettings.overlayMode.value == 2 ? 0xFFFF60 : 0xFFFFFF;
                    this.drawStringShadow(this.fontRenderer, "Better than Adventure! ", tsp, tsp + lineHeight * line, color);
                    this.drawStringShadow(this.fontRenderer, Global.VERSION, this.fontRenderer.getLastEndingX(), tsp + lineHeight * line++, 0xFFFFFF);
                }
                if (((Boolean)this.mc.gameSettings.fpsInOverlay.value).booleanValue()) {
                    this.drawStringShadow(this.fontRenderer, this.mc.debugFPS, tsp, tsp + lineHeight * line++, 0xFFFFFF);
                }
                if (compass) {
                    if (((Boolean)this.mc.gameSettings.overlayShowCoords.value).booleanValue()) {
                        if ((Integer)this.mc.gameSettings.overlayMode.value == 0) {
                            this.drawStringShadow(this.fontRenderer, "x: " + Utils.floor10(this.mc.thePlayer.x) + " y: " + Utils.floor10(this.mc.thePlayer.y) + " z: " + Utils.floor10(this.mc.thePlayer.z), tsp, tsp + lineHeight * line++, 0xFFFFFF);
                        }
                        if ((Integer)this.mc.gameSettings.overlayMode.value == 1) {
                            this.drawStringShadow(this.fontRenderer, "x: " + Utils.floor10(this.mc.thePlayer.x), tsp, tsp + lineHeight * line++, 0xFFFFFF);
                            this.drawStringShadow(this.fontRenderer, "y: " + Utils.floor10(this.mc.thePlayer.y), tsp, tsp + lineHeight * line++, 0xFFFFFF);
                            this.drawStringShadow(this.fontRenderer, "z: " + Utils.floor10(this.mc.thePlayer.z), tsp, tsp + lineHeight * line++, 0xFFFFFF);
                        }
                        if ((Integer)this.mc.gameSettings.overlayMode.value == 2) {
                            this.drawStringShadow(this.fontRenderer, "x: " + Utils.floor10(this.mc.thePlayer.x), tsp, tsp + lineHeight * line++, 0xFF8080);
                            this.drawStringShadow(this.fontRenderer, "y: " + Utils.floor10(this.mc.thePlayer.y), tsp, tsp + lineHeight * line++, 0x80FF80);
                            this.drawStringShadow(this.fontRenderer, "z: " + Utils.floor10(this.mc.thePlayer.z), tsp, tsp + lineHeight * line++, 0x8080FF);
                        }
                    }
                    if (((Boolean)this.mc.gameSettings.overlayShowDirection.value).booleanValue()) {
                        this.drawStringShadow(this.fontRenderer, I18n.getInstance().translateKey(HudIngame.getFacingDirection(this.mc.thePlayer).getTranslationKey()), tsp, tsp + lineHeight * line++, 0xFFFFFF);
                    }
                }
                if (clock && ((Boolean)this.mc.gameSettings.overlayShowTime.value).booleanValue()) {
                    if ((Integer)this.mc.gameSettings.overlayMode.value == 0) {
                        this.drawStringShadow(this.fontRenderer, String.format("%s %s %d", this.getTimeString(), I18n.getInstance().translateKey("unit.day"), this.mc.currentWorld.getWorldTime() / 24000L), tsp, tsp + lineHeight * line++, (Integer)this.mc.gameSettings.overlayMode.value == 2 ? 0xFFFF80 : 0xFFFFFF);
                    }
                    if ((Integer)this.mc.gameSettings.overlayMode.value > 0) {
                        this.drawStringShadow(this.fontRenderer, this.getTimeString(), tsp, tsp + lineHeight * line++, (Integer)this.mc.gameSettings.overlayMode.value == 2 ? 0xFFFF80 : 0xFFFFFF);
                        this.drawStringShadow(this.fontRenderer, String.format("%s %d", I18n.getInstance().translateKey("unit.day"), this.mc.currentWorld.getWorldTime() / 24000L), tsp, tsp + lineHeight * line++, (Integer)this.mc.gameSettings.overlayMode.value == 2 ? 0xFFFF80 : 0xFFFFFF);
                    }
                }
                if (rotaryCalendar) {
                    Weather weather;
                    Season season;
                    if (((Boolean)this.mc.gameSettings.overlayShowSeason.value).booleanValue() && (season = this.mc.currentWorld.getSeasonManager().getCurrentSeason()) != null) {
                        this.drawStringShadow(this.fontRenderer, season.getTranslatedName(), tsp, tsp + lineHeight * line++, (Integer)this.mc.gameSettings.overlayMode.value == 2 ? 0x80FFFF : 0xFFFFFF);
                    }
                    if (((Boolean)this.mc.gameSettings.overlayShowWeather.value).booleanValue() && (weather = this.mc.currentWorld.getCurrentWeather()) != null && weather != this.mc.currentWorld.worldType.getDefaultWeather()) {
                        this.drawStringShadow(this.fontRenderer, stringtranslate.translateKey(weather.getNameLanguageKey()), tsp, tsp + lineHeight * line++, (Integer)this.mc.gameSettings.overlayMode.value == 2 ? 0xFF80FF : 0xFFFFFF);
                    }
                    if (((Boolean)this.mc.gameSettings.overlayShowBiome.value).booleanValue()) {
                        int blockX = MathHelper.floor(this.mc.thePlayer.x);
                        int blockY = MathHelper.floor(this.mc.thePlayer.y);
                        int blockZ = MathHelper.floor(this.mc.thePlayer.z);
                        String key = this.mc.currentWorld.getBlockBiome((int)blockX, (int)blockY, (int)blockZ).translationKey;
                        this.drawStringShadow(this.fontRenderer, stringtranslate.translateKey(key), tsp, tsp + lineHeight * line++, 0xFFFFFF);
                    }
                }
            }
        }
        if (this.mc.gameSettings.immersiveMode.drawOverlays() && ((Boolean)this.mc.gameSettings.armorDurabilityOverlay.value).booleanValue()) {
            for (int i = this.mc.thePlayer.getNumArmorSlots() - 1; i >= 0; --i) {
                ItemStack stack = this.mc.thePlayer.getItemInArmorSlot(HumanArmorShape.values()[i]);
                if (stack == null) continue;
                int x = 2 + sp;
                int y = height - sp - 64 + i * 16;
                ItemModelDispatcher.getInstance().getDispatch(stack).renderGui(Tessellator.instance, null, stack, x, y, 1.0f, 1.0f, partialTicks);
                if (!stack.isItemStackDamageable()) continue;
                float durability = (float)(stack.getMaxDamage() - stack.getMetadata()) / (float)stack.getMaxDamage();
                int l = (int)(durability * 255.0f);
                int i1 = 255 - l << 16 | l << 8;
                GL11.glDisable((int)3042);
                GL11.glDisable((int)2896);
                this.drawStringShadow(this.fontRenderer, String.valueOf(stack.getMaxDamage() - stack.getMetadata() + 1), x + 20, y + 4, i1);
            }
            GL11.glDisable((int)3042);
            GL11.glDisable((int)2896);
        }
        if (this.mc.gameSettings.immersiveMode.drawOverlays() && ((Boolean)this.mc.gameSettings.heldItemCountOverlay.value).booleanValue() && (heldItemStack = this.mc.thePlayer.inventory.getCurrentItem()) != null) {
            boolean renderItem;
            int x = width / 2 + 96;
            int y = height - sp - 19;
            if (heldItemStack.isItemStackDamageable()) {
                renderItem = true;
                float durability = (float)(heldItemStack.getMaxDamage() - heldItemStack.getMetadata()) / (float)heldItemStack.getMaxDamage();
                int color = Color.HSBtoRGB(durability / 3.0f, 1.0f, 1.0f);
                int remainingDurability = heldItemStack.getMaxDamage() - heldItemStack.getMetadata() + 1;
                this.drawStringShadow(this.fontRenderer, "" + remainingDurability, x + 18, y + 4, color);
            } else {
                int itemCount = 0;
                int stackCount = 0;
                for (int i = 0; i < this.mc.thePlayer.inventory.getContainerSize(); ++i) {
                    ItemStack itemStack = this.mc.thePlayer.inventory.getItem(i);
                    if (itemStack == null || itemStack.itemID != heldItemStack.itemID || itemStack.getMetadata() != heldItemStack.getMetadata()) continue;
                    itemCount += itemStack.stackSize;
                    ++stackCount;
                }
                boolean bl = renderItem = stackCount >= 1;
                if (renderItem) {
                    this.drawStringShadow(this.fontRenderer, "" + itemCount, x + 18, y + 4, 0xFFFFFF);
                }
            }
            if (renderItem) {
                GL11.glEnable((int)2929);
                GL11.glDisable((int)3042);
                GL11.glEnable((int)32826);
                Lighting.enableInventoryLight();
                ItemModelDispatcher.getInstance().getDispatch(heldItemStack).renderGui(Tessellator.instance, null, heldItemStack, x, y, 1.0f, 1.0f, partialTicks);
                Lighting.disable();
            }
        }
        if (this.mc.gameSettings.immersiveMode.drawChat()) {
            this.drawChat(width, height, sp);
        }
        if (this.mc.gameSettings.keyToggleTextureAtlas.isPressed()) {
            Tessellator tessellator = Tessellator.instance;
            TextureRegistry.blockAtlas.bind();
            int blockW = TextureRegistry.blockAtlas.getAtlasWidth();
            int blockH = TextureRegistry.blockAtlas.getAtlasHeight();
            float scaleBlock = (float)(width / 4) / (float)blockW;
            tessellator.startDrawingQuads();
            tessellator.addVertexWithUV(20.0, 20.0f + (float)blockH * scaleBlock, 0.0, 0.0, 1.0);
            tessellator.addVertexWithUV(20.0f + (float)blockW * scaleBlock, 20.0f + (float)blockH * scaleBlock, 0.0, 1.0, 1.0);
            tessellator.addVertexWithUV(20.0f + (float)blockW * scaleBlock, 20.0, 0.0, 1.0, 0.0);
            tessellator.addVertexWithUV(20.0, 20.0, 0.0, 0.0, 0.0);
            tessellator.draw();
            int blockEndX = (int)(20.0f + (float)blockW * scaleBlock + 10.0f);
            TextureRegistry.itemAtlas.bind();
            int itemW = TextureRegistry.itemAtlas.getAtlasWidth();
            int itemH = TextureRegistry.itemAtlas.getAtlasHeight();
            float scaleItem = (float)(width / 4) / (float)itemW;
            tessellator.startDrawingQuads();
            tessellator.addVertexWithUV(blockEndX, 20.0f + (float)itemH * scaleItem, 0.0, 0.0, 1.0);
            tessellator.addVertexWithUV((float)blockEndX + (float)itemW * scaleItem, 20.0f + (float)itemH * scaleItem, 0.0, 1.0, 1.0);
            tessellator.addVertexWithUV((float)blockEndX + (float)itemW * scaleItem, 20.0, 0.0, 1.0, 0.0);
            tessellator.addVertexWithUV(blockEndX, 20.0, 0.0, 0.0, 0.0);
            tessellator.draw();
            int itemEndX = (int)((float)blockEndX + (float)itemW * scaleItem + 10.0f);
            TextureRegistry.particleAtlas.bind();
            int particleW = TextureRegistry.particleAtlas.getAtlasWidth();
            int particleH = TextureRegistry.particleAtlas.getAtlasHeight();
            float scaleParticle = (float)(width / 4) / (float)particleW;
            tessellator.startDrawingQuads();
            tessellator.addVertexWithUV(itemEndX, 20.0f + (float)particleH * scaleParticle, 0.0, 0.0, 1.0);
            tessellator.addVertexWithUV((float)itemEndX + (float)particleW * scaleParticle, 20.0f + (float)particleH * scaleParticle, 0.0, 1.0, 1.0);
            tessellator.addVertexWithUV((float)itemEndX + (float)particleW * scaleParticle, 20.0, 0.0, 1.0, 0.0);
            tessellator.addVertexWithUV(itemEndX, 20.0, 0.0, 0.0, 0.0);
            tessellator.draw();
        }
        if (this.mc.gameSettings.immersiveMode.drawOverlays() && this.mc.downloadResourcesThread.downloading) {
            double b = Math.sin((double)System.currentTimeMillis() / 1000.0 * 4.0);
            b = b * 0.2 + 0.8;
            int ib = (int)Math.round(b * 255.0);
            int color = -16777216 + (ib << 16) + (ib << 8) + ib;
            this.drawStringCenteredShadow(this.mc.font, stringtranslate.translateKeyAndFormat("gui.main_menu.label.downloading_resources.1", this.mc.downloadResourcesThread.downloadProgress.get(), this.mc.downloadResourcesThread.toDownload), width / 2, 16 + sp, color);
            this.drawStringCenteredShadow(this.mc.font, stringtranslate.translateKey("gui.main_menu.label.downloading_resources.2"), width / 2, 25 + sp, color);
        }
    }

    private void drawDebugScreenLine(CharSequence string, boolean right, int line, int offset) {
        int width = MathHelper.ceil(this.fontRenderer.stringWidthDouble(string));
        int height = 10;
        int x = right ? (int)((float)this.mc.resolution.getScaledWidthScreenCoords() / 1.0f - (float)width - 2.0f) : 2;
        int y = 3 + line * 10 + offset;
        GL11.glDisable((int)3553);
        GL11.glColor4d((double)0.2, (double)0.2, (double)0.2, (double)0.6);
        Tessellator t = Tessellator.instance;
        t.startDrawingQuads();
        t.drawRectangle(x - 1, y - 1, width + 2, height);
        t.draw();
        GL11.glEnable((int)3553);
        this.drawStringNoShadow(this.fontRenderer, string, x, y, 0xFFFFFF);
    }

    private void drawDebugScreenLine(CharSequence string) {
        this.drawDebugScreenLine(string, false, this.debugLine++, this.debugOffset);
    }

    private void drawDebugScreenLineRight(CharSequence string) {
        this.drawDebugScreenLine(string, true, this.debugLineRight++, this.debugOffsetRight);
    }

    public void drawPlayerList(int screenWidth, int screenHeight, int screenPadding) {
        if (!this.mc.isMultiplayerWorld()) {
            return;
        }
        if ((Integer)this.mc.gameSettings.playerListPosition.value == 1) {
            this.mc.gameSettings.showPlayerList.value = this.mc.gameSettings.keyPlayerList.isPressed() && this.mc.currentScreen == null;
        }
        if (!((Boolean)this.mc.gameSettings.showPlayerList.value).booleanValue()) {
            return;
        }
        if (!(this.mc.thePlayer instanceof PlayerLocalMultiplayer)) {
            return;
        }
        PlayerLocalMultiplayer player = (PlayerLocalMultiplayer)this.mc.thePlayer;
        HashMap<String, String> players = player.sendQueue.playerList;
        int longestNameWidth = 0;
        int longestScoreWidth = 0;
        this.playerListScoreStrings.clear();
        for (Map.Entry<String, String> a1 : players.entrySet()) {
            longestNameWidth = Math.max(MathHelper.ceil(this.fontRenderer.stringWidthDouble(a1.getKey())), longestNameWidth);
            longestScoreWidth = Math.max(MathHelper.ceil(this.fontRenderer.stringWidthDouble(a1.getValue())), longestScoreWidth);
            this.playerListScoreStrings.add(a1.getValue());
        }
        int nameScoreSpace = 4;
        int lineHeight = 8;
        int outerPadding = 12;
        int innerPadding = 8;
        int columnWidth = longestNameWidth + longestScoreWidth + 4;
        int columns = (int)Math.ceil((float)players.size() / 8.0f);
        int rows = (int)Math.ceil((float)players.size() / (float)columns) + 1;
        int width = columns * columnWidth + 8 * (columns - 1) + 24;
        int height = rows * 8 + 8 * (rows - 1) + 2 + 12 - 8 + 2;
        int listX = 0;
        int listY = screenPadding;
        if ((Integer)this.mc.gameSettings.playerListPosition.value == 0) {
            listX = (screenWidth - width) / 2;
        }
        if ((Integer)this.mc.gameSettings.playerListPosition.value == 1) {
            listX = (screenWidth - width) / 2;
            listY = screenHeight / 6 + screenPadding;
        }
        if ((Integer)this.mc.gameSettings.playerListPosition.value == 2) {
            listX = screenWidth - width - screenPadding;
        }
        this.drawRect(listX, listY, listX + width, listY + height, -1475868664);
        int i = 0;
        for (Map.Entry<String, String> a2 : players.entrySet()) {
            int x = i % columns;
            int y = i / columns;
            int posX = listX + x * columnWidth + x * 8 + 12;
            int posY = listY + y * 8 + y * 8 + 12;
            int scoreStringWidth = MathHelper.ceil(this.fontRenderer.stringWidthDouble(a2.getValue()));
            this.drawRect(posX - 2, posY - 2, posX + columnWidth + 2, posY + 10, -5921371);
            this.drawRect(posX - 1, posY - 1, posX + columnWidth + 1, posY + 9, -1475868664);
            this.drawStringShadow(this.fontRenderer, a2.getKey(), posX, posY, 0xFFFFFF);
            this.drawStringShadow(this.fontRenderer, TextFormatting.YELLOW + a2.getValue(), posX + columnWidth - scoreStringWidth, posY, 0xFFFFFF);
            ++i;
        }
    }

    public void drawRecordPlayingOverlay(int width, int height, float partialTicks) {
        if (this.recordPlayingUpFor > 0) {
            float f2 = (float)this.recordPlayingUpFor - partialTicks;
            int j3 = (int)(f2 * 256.0f / 20.0f);
            if (j3 > 255) {
                j3 = 255;
            }
            if (j3 > 0) {
                GL11.glPushMatrix();
                GL11.glTranslatef((float)((float)width / 2.0f), (float)(height - 48), (float)0.0f);
                GL11.glEnable((int)3042);
                GL11.glBlendFunc((int)770, (int)771);
                int k4 = 0xFFFFFF;
                if (this.colorString) {
                    k4 = Color.HSBtoRGB(f2 / 50.0f, 0.7f, 0.6f) & 0xFFFFFF;
                }
                this.drawStringNoShadow(this.fontRenderer, this.recordPlaying, MathHelper.ceil(-this.fontRenderer.stringWidthDouble(this.recordPlaying) / 2.0), -4, k4 + (j3 << 24));
                GL11.glDisable((int)3042);
                GL11.glPopMatrix();
            }
        }
    }

    public void drawChat(int width, int height, int sp) {
        if (this.mc.gameSettings.chatVisibility.value == ChatVisibility.NEVER_SHOW) {
            return;
        }
        if (this.mc.currentScreen instanceof ScreenChat && ((ScreenChat)this.mc.currentScreen).message.startsWith("/")) {
            return;
        }
        int linesToShow = 10;
        boolean ignoreFadeout = false;
        if (this.mc.currentScreen instanceof ScreenChat) {
            int acceptableSize = height - 48 - 48;
            linesToShow = acceptableSize / 9;
            ignoreFadeout = true;
        } else if (this.mc.gameSettings.chatVisibility.value == ChatVisibility.SHOW_WHEN_CHATTING) {
            return;
        }
        if (this.chatScroll > this.chatMessageList.size() - linesToShow) {
            this.chatScroll = this.chatMessageList.size() - linesToShow;
        }
        if (this.chatScroll < 0) {
            this.chatScroll = 0;
        }
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glDisable((int)3008);
        GL11.glPushMatrix();
        GL11.glTranslatef((float)0.0f, (float)(height - 48), (float)0.0f);
        int y = -12;
        for (int i = 0; i < linesToShow; ++i) {
            if (this.chatScroll + i >= this.chatMessageList.size()) continue;
            ChatLine line = this.chatMessageList.get(this.chatScroll + i);
            if (line.updateCounter >= 190 && !ignoreFadeout) continue;
            double fadeAmount = (double)line.updateCounter / 200.0;
            fadeAmount = 1.0 - fadeAmount;
            if ((fadeAmount *= 10.0) < 0.0) {
                fadeAmount = 0.0;
            }
            if (fadeAmount > 1.0) {
                fadeAmount = 1.0;
            }
            fadeAmount *= fadeAmount;
            int alpha = (int)(255.0 * fadeAmount);
            if (ignoreFadeout) {
                alpha = 255;
            }
            if (alpha <= 0) continue;
            CharSequence message = line.message;
            int xPad = 2;
            int h = MathHelper.ceil(this.fontRenderer.heightOfConstrainedChars(message, 320.0));
            this.drawRect(2, (y -= h + 2) - sp - 1, 322, y + h - sp + 1, alpha / 2 << 24);
            GL11.glEnable((int)3042);
            this.fontRenderer.renderWidthConstrained(Tessellator.instance, message, 2, y, 320).setShadow().setColor(0xFFFFFF + (alpha << 24)).call();
        }
        GL11.glPopMatrix();
        GL11.glEnable((int)3008);
        GL11.glDisable((int)3042);
    }

    public String getTimeString() {
        long worldTime = this.mc.currentWorld.getWorldTime();
        int dayLength = 24000;
        int dayTime = (int)(worldTime % (long)dayLength);
        int hourLength = dayLength / 24;
        int hour = dayTime / hourLength;
        hour = (hour + 6) % 24;
        double hp = (double)(dayTime % hourLength) / (double)hourLength;
        int minute = (int)(hp * 60.0);
        return hour + ":" + HudIngame.addZero(minute);
    }

    public static String addZero(int i) {
        if (i < 10) {
            return "0" + i;
        }
        return String.valueOf(i);
    }

    protected void renderPumpkinBlur(int xSize, int ySize) {
        GL11.glDisable((int)2929);
        GL11.glDepthMask((boolean)false);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glDisable((int)3008);
        this.mc.textureManager.loadTexture("/assets/minecraft/textures/misc/pumpkinblur.png").bind();
        Tessellator tessellator = Tessellator.instance;
        tessellator.startDrawingQuads();
        tessellator.addVertexWithUV(0.0, ySize, -90.0, 0.0, 1.0);
        tessellator.addVertexWithUV(xSize, ySize, -90.0, 1.0, 1.0);
        tessellator.addVertexWithUV(xSize, 0.0, -90.0, 1.0, 0.0);
        tessellator.addVertexWithUV(0.0, 0.0, -90.0, 0.0, 0.0);
        tessellator.draw();
        GL11.glDepthMask((boolean)true);
        GL11.glEnable((int)2929);
        GL11.glEnable((int)3008);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    protected void renderVignette(float intensity, int xSize, int ySize) {
        intensity = MathHelper.clamp(1.0f - intensity, 0.0f, 1.0f);
        this.prevVignetteBrightness = (float)((double)this.prevVignetteBrightness + (double)(intensity - this.prevVignetteBrightness) * 0.01);
        GL11.glDisable((int)2929);
        GL11.glDepthMask((boolean)false);
        GL11.glBlendFunc((int)0, (int)769);
        GL11.glColor4f((float)this.prevVignetteBrightness, (float)this.prevVignetteBrightness, (float)this.prevVignetteBrightness, (float)1.0f);
        this.mc.textureManager.loadTexture("/assets/minecraft/textures/misc/vignette.png").bind();
        Tessellator tessellator = Tessellator.instance;
        tessellator.startDrawingQuads();
        tessellator.addVertexWithUV(0.0, ySize, -90.0, 0.0, 1.0);
        tessellator.addVertexWithUV(xSize, ySize, -90.0, 1.0, 1.0);
        tessellator.addVertexWithUV(xSize, 0.0, -90.0, 1.0, 0.0);
        tessellator.addVertexWithUV(0.0, 0.0, -90.0, 0.0, 0.0);
        tessellator.draw();
        GL11.glDepthMask((boolean)true);
        GL11.glEnable((int)2929);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glBlendFunc((int)770, (int)771);
    }

    protected void renderPortalOverlay(float intensity, int xSize, int ySize) {
        if (intensity < 1.0f) {
            intensity *= intensity;
            intensity *= intensity;
            intensity = intensity * 0.8f + 0.2f;
        }
        GL11.glDisable((int)3008);
        GL11.glDisable((int)2929);
        GL11.glDepthMask((boolean)false);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)intensity);
        IconCoordinate portal = ((BlockModel)BlockModelDispatcher.getInstance().getDispatch(Blocks.getBlock(this.mc.thePlayer.portalID))).getOverlayTexture(this.mc.thePlayer.portalColor.blockMeta << 4 | 8);
        portal.parentAtlas.bind();
        float f1 = (float)portal.getIconUMin();
        float f2 = (float)portal.getIconVMin();
        float f3 = (float)portal.getIconUMax();
        float f4 = (float)portal.getIconVMax();
        Tessellator tessellator = Tessellator.instance;
        tessellator.startDrawingQuads();
        tessellator.addVertexWithUV(0.0, ySize, -90.0, f1, f4);
        tessellator.addVertexWithUV(xSize, ySize, -90.0, f3, f4);
        tessellator.addVertexWithUV(xSize, 0.0, -90.0, f3, f2);
        tessellator.addVertexWithUV(0.0, 0.0, -90.0, f1, f2);
        tessellator.draw();
        GL11.glDepthMask((boolean)true);
        GL11.glEnable((int)2929);
        GL11.glEnable((int)3008);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public void updateTick() {
        if (this.recordPlayingUpFor > 0) {
            --this.recordPlayingUpFor;
        }
        ++this.updateCounter;
        for (ChatLine chatLine : this.chatMessageList) {
            ++chatLine.updateCounter;
        }
    }

    public void clearChatMessages() {
        this.chatMessageList.clear();
    }

    public void addChatMessage(CharSequence s) {
        LOGGER.info("[CHAT] {}", (Object)s);
        this.chatMessageList.add(0, new ChatLine(s));
        while (this.chatMessageList.size() > 100) {
            this.chatMessageList.remove(this.chatMessageList.size() - 1);
        }
    }

    public void setRecordPlayingMessage(String s) {
        this.recordPlaying = I18n.getInstance().translateKeyAndFormat("gui.ingame.label.now_playing", s);
        this.recordPlayingUpFor = 60;
        this.colorString = true;
    }

    public void addChatMessageTranslate(String s) {
        I18n i18n = I18n.getInstance();
        String result = i18n.translateKey(s);
        this.addChatMessage(result);
    }

    public static Direction getFacingDirection(Player player) {
        return directions[MathHelper.floor((double)(player.yRot * 4.0f / 360.0f) + 0.5) + 2 & 3];
    }
}

