/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.keyboard.keys;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.util.Locale;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.keyboard.ScreenKeyboard;
import net.minecraft.client.gui.keyboard.keys.Key;

public class GroupKey
extends Key {
    protected final Mode mode;
    protected final int amount;
    protected final int amount2;

    public GroupKey(int x, int y, int width, int height, Mode mode, int amount, int amount2) {
        super(x, y, width, height);
        this.mode = mode;
        this.amount = amount;
        this.amount2 = amount2;
    }

    @Override
    public void pressAction(Minecraft mc, ScreenKeyboard keyboard, int originX, int originY, int mouseX, int mouseY) {
        super.pressAction(mc, keyboard, originX, originY, mouseX, mouseY);
        switch (this.mode) {
            case OFFSET: {
                keyboard.shiftGroup(this.amount);
                break;
            }
            case SET: {
                keyboard.setGroup(this.amount);
                break;
            }
            case TOGGLE: {
                if (keyboard.getGroup() == this.amount) {
                    keyboard.setGroup(this.amount2);
                    break;
                }
                keyboard.setGroup(this.amount);
            }
        }
    }

    public static enum Mode {
        SET,
        OFFSET,
        TOGGLE;

    }

    public static class Serializer
    implements JsonSerializer<GroupKey>,
    JsonDeserializer<GroupKey> {
        public static final int DEFAULT_WIDTH = 18;
        public static final int DEFAULT_HEIGHT = 18;
        public static final String DEFAULT_TEXTURE_NEXT_UP = "minecraft:gui/widgets/keyboard/key_page_next/up";
        public static final String DEFAULT_TEXTURE_NEXT_DOWN = "minecraft:gui/widgets/keyboard/key_page_next/down";
        public static final String DEFAULT_TEXTURE_NEXT_UP_HOVERED = "minecraft:gui/widgets/keyboard/key_page_next/up_hovered";
        public static final String DEFAULT_TEXTURE_NEXT_DOWN_HOVERED = "minecraft:gui/widgets/keyboard/key_page_next/down_hovered";
        public static final String DEFAULT_TEXTURE_LAST_UP = "minecraft:gui/widgets/keyboard/key_page_last/up";
        public static final String DEFAULT_TEXTURE_LAST_DOWN = "minecraft:gui/widgets/keyboard/key_page_last/down";
        public static final String DEFAULT_TEXTURE_LAST_UP_HOVERED = "minecraft:gui/widgets/keyboard/key_page_last/up_hovered";
        public static final String DEFAULT_TEXTURE_LAST_DOWN_HOVERED = "minecraft:gui/widgets/keyboard/key_page_last/down_hovered";
        public static final Mode DEFAULT_MODE = Mode.OFFSET;

        @Override
        public GroupKey deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            String texDownHovered;
            int highest;
            int lowest;
            JsonObject obj = json.getAsJsonObject();
            int x = obj.get("x").getAsInt();
            int y = obj.get("y").getAsInt();
            int width = obj.has("width") ? obj.get("width").getAsInt() : 18;
            int height = obj.has("height") ? obj.get("height").getAsInt() : 18;
            Key.ButtonEnum button = obj.has("button") ? Key.ButtonEnum.valueOf(obj.get("button").getAsString().toUpperCase(Locale.ROOT)) : null;
            Mode mode = obj.has("mode") ? Mode.valueOf(obj.get("mode").getAsString().toUpperCase(Locale.ROOT)) : DEFAULT_MODE;
            switch (mode) {
                case TOGGLE: {
                    lowest = obj.get("page1").getAsInt();
                    highest = obj.get("page2").getAsInt();
                    break;
                }
                default: {
                    highest = lowest = obj.get("amount").getAsInt();
                }
            }
            String texUp = lowest >= 0 ? DEFAULT_TEXTURE_NEXT_UP : DEFAULT_TEXTURE_LAST_UP;
            String texDown = lowest >= 0 ? DEFAULT_TEXTURE_NEXT_DOWN : DEFAULT_TEXTURE_LAST_DOWN;
            String texUpHovered = lowest >= 0 ? DEFAULT_TEXTURE_NEXT_UP_HOVERED : DEFAULT_TEXTURE_LAST_UP_HOVERED;
            String string = texDownHovered = lowest >= 0 ? DEFAULT_TEXTURE_NEXT_DOWN_HOVERED : DEFAULT_TEXTURE_LAST_DOWN_HOVERED;
            if (obj.has("textures")) {
                JsonObject textures = obj.getAsJsonObject("textures");
                if (textures.has("up")) {
                    texUp = textures.get("up").getAsString();
                }
                if (textures.has("down")) {
                    texDown = textures.get("down").getAsString();
                }
                if (textures.has("up_hovered")) {
                    texUpHovered = textures.get("up_hovered").getAsString();
                }
                if (textures.has("down_hovered")) {
                    texDownHovered = textures.get("down_hovered").getAsString();
                }
            }
            GroupKey key = new GroupKey(x, y, width, height, mode, lowest, highest);
            key.setTextures(texUp, texDown, texUpHovered, texDownHovered);
            key.setControllerButton(button);
            return key;
        }

        @Override
        public JsonElement serialize(GroupKey src, Type typeOfSrc, JsonSerializationContext context) {
            JsonObject object = new JsonObject();
            object.addProperty("type", Key.Serializer.KEY_CLASS_TO_ID.get(src.getClass()));
            object.addProperty("x", src.x);
            object.addProperty("y", src.y);
            if (src.width != 18) {
                object.addProperty("width", src.width);
            }
            if (src.height != 18) {
                object.addProperty("height", src.height);
            }
            if (src.controllerButton != null) {
                object.addProperty("button", src.controllerButton.name().toLowerCase(Locale.ROOT));
            }
            boolean ku = true;
            boolean kd = true;
            boolean kuh = true;
            boolean kdh = true;
            if (ku || kd || kuh || kdh) {
                JsonObject textureObject = new JsonObject();
                if (ku) {
                    textureObject.addProperty("up", src.keyUp.sourceNamespaceId.toString());
                }
                if (kd) {
                    textureObject.addProperty("down", src.keyDown.sourceNamespaceId.toString());
                }
                if (kuh) {
                    textureObject.addProperty("up_hovered", src.keyUpHovered.sourceNamespaceId.toString());
                }
                if (kdh) {
                    textureObject.addProperty("down_hovered", src.keyDownHovered.sourceNamespaceId.toString());
                }
                object.add("textures", textureObject);
            }
            object.addProperty("mode", src.mode.name().toLowerCase(Locale.ROOT));
            switch (src.mode) {
                case TOGGLE: {
                    object.addProperty("page1", src.amount);
                    object.addProperty("page2", src.amount2);
                    break;
                }
                default: {
                    object.addProperty("amount", src.amount);
                }
            }
            return object;
        }
    }
}

