/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.modelviewer.categories;

import java.io.File;
import java.util.HashMap;
import java.util.List;
import net.minecraft.client.gui.ButtonElement;
import net.minecraft.client.gui.Screen;
import net.minecraft.client.gui.modelviewer.ScreenModelViewer;
import net.minecraft.client.gui.modelviewer.categories.ModelViewerCategory;
import net.minecraft.client.gui.modelviewer.categories.entries.block.BlockEntry;
import net.minecraft.client.gui.modelviewer.categories.entries.block.BlockEntryBasic;
import net.minecraft.client.gui.modelviewer.categories.entries.block.BlockEntryJar;
import net.minecraft.client.gui.modelviewer.categories.entries.block.BlockEntryMobSpawner;
import net.minecraft.client.gui.modelviewer.categories.entries.block.BlockEntrySign;
import net.minecraft.client.gui.modelviewer.elements.TextCycleElement;
import net.minecraft.client.render.block.model.BlockModel;
import net.minecraft.client.render.block.model.BlockModelCrossedSquares;
import net.minecraft.client.render.block.model.BlockModelDispatcher;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockLogicButton;
import net.minecraft.core.block.BlockLogicChest;
import net.minecraft.core.block.BlockLogicCropsPumpkin;
import net.minecraft.core.block.BlockLogicCropsWheat;
import net.minecraft.core.block.BlockLogicFlowerStackable;
import net.minecraft.core.block.BlockLogicFullyRotatable;
import net.minecraft.core.block.BlockLogicLadder;
import net.minecraft.core.block.BlockLogicLever;
import net.minecraft.core.block.BlockLogicPortal;
import net.minecraft.core.block.BlockLogicRotatable;
import net.minecraft.core.block.BlockLogicVeryRotatable;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.block.IPainted;
import net.minecraft.core.block.piston.BlockLogicPistonBase;
import net.minecraft.core.block.piston.BlockLogicPistonHead;
import net.minecraft.core.entity.EntityItem;
import net.minecraft.core.enums.EnumDropCause;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.lang.I18n;
import net.minecraft.core.util.helper.Direction;
import net.minecraft.core.util.helper.DyeColor;
import net.minecraft.core.util.helper.MathHelper;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.world.chunk.DisplayChunk;
import org.jetbrains.annotations.NotNull;

public class ViewerCategoryBlock
extends ModelViewerCategory<BlockRenderInfo> {
    public HashMap<Block<?>, BlockEntry> entryHashMap = new HashMap();
    public TextCycleElement<Integer> blockIdTextField;
    public TextCycleElement<Integer> blockMetaTextField;

    public ViewerCategoryBlock(ScreenModelViewer modelViewer) {
        super(modelViewer);
        this.createEntries();
    }

    public void createEntries() {
        for (Block<?> block : Blocks.blocksList) {
            if (block == null) continue;
            this.entryHashMap.put(block, new BlockEntryBasic(block));
        }
        this.entryHashMap.put(Blocks.SIGN_WALL_PLANKS_OAK, new BlockEntrySign(Blocks.SIGN_WALL_PLANKS_OAK));
        this.entryHashMap.put(Blocks.SIGN_POST_PLANKS_OAK, new BlockEntrySign(Blocks.SIGN_POST_PLANKS_OAK));
        this.entryHashMap.put(Blocks.MOBSPAWNER, new BlockEntryMobSpawner());
        this.entryHashMap.put(Blocks.JAR_GLASS, new BlockEntryJar());
    }

    @Override
    public String getCategoryNameKey() {
        return "model.category.block.name";
    }

    @Override
    public String getCurrentDisplayInfo(I18n translator) {
        Block<?> displayBlock = Blocks.getBlock(DisplayChunk.displayBlockId);
        String name = "None";
        if (displayBlock != null) {
            name = I18n.getInstance().translateKey(displayBlock.getKey() + ".name");
            ItemStack[] nameStack = displayBlock.getBreakResult(this.mc.currentWorld, EnumDropCause.PICK_BLOCK, DisplayChunk.displayBlockPosX, DisplayChunk.displayBlockPosY, DisplayChunk.displayBlockPosZ, DisplayChunk.displayBlockMeta, DisplayChunk.displayTileEntity);
            if (nameStack != null && nameStack.length > 0) {
                name = nameStack[0].getDisplayName();
            }
        }
        return translator.translateKeyAndFormat("model.category.block.info", name);
    }

    @Override
    public void addContextButtons(List<ButtonElement> buttonList) {
        List<ButtonElement> list;
        ButtonElement lastButton = buttonList.get(buttonList.size() - 1);
        this.modelViewer.buttonNextEntry.enabled = false;
        this.modelViewer.buttonPrevEntry.enabled = false;
        boolean wasFocused = false;
        if (this.blockIdTextField != null) {
            wasFocused = this.blockIdTextField.textField.isFocused;
        }
        this.blockIdTextField = new TextCycleElement<Integer>((Screen)this.modelViewer, this.mc.font, this.modelViewer.width - 120, lastButton.yPosition + 21, 120, 20, Integer.valueOf(DisplayChunk.displayBlockId)){

            @Override
            public Integer cycleElement(Integer current, int offset) {
                return ScreenModelViewer.cycleBlockId(current, offset);
            }

            @Override
            public Integer getElementFromString(String s) {
                try {
                    int id = MathHelper.clamp(Integer.parseInt(s), 0, Blocks.blocksList.length);
                    if (Blocks.getBlock(id) != null) {
                        return id;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return DisplayChunk.displayBlockId;
            }

            @Override
            public String getNameFromElement(Integer element) {
                return String.valueOf(element);
            }
        };
        this.blockIdTextField.textField.setFocused(wasFocused);
        this.blockIdTextField.textField.setPrefaceText("ID: ");
        this.blockIdTextField.textField.setPlaceholder("Block ID");
        this.blockIdTextField.setOnValueChanged(() -> this.setDisplayBlock(this.blockIdTextField.getCurrentElement(), 0));
        buttonList.add(this.blockIdTextField);
        wasFocused = false;
        if (this.blockMetaTextField != null) {
            wasFocused = this.blockMetaTextField.textField.isFocused;
        }
        this.blockMetaTextField = new TextCycleElement<Integer>((Screen)this.modelViewer, this.mc.font, this.modelViewer.width - 120, this.blockIdTextField.yPosition + 21, 120, 20, Integer.valueOf(0)){

            @Override
            public Integer cycleElement(Integer current, int offset) {
                return current + offset & 0xFF;
            }

            @Override
            public Integer getElementFromString(String s) {
                try {
                    int meta = Integer.parseInt(s);
                    return MathHelper.clamp(meta, 0, 255);
                }
                catch (Exception exception) {
                    return DisplayChunk.displayBlockMeta;
                }
            }

            @Override
            public String getNameFromElement(Integer element) {
                return String.valueOf(element);
            }
        };
        this.blockMetaTextField.textField.setFocused(wasFocused);
        this.blockMetaTextField.textField.setPlaceholder("Meta");
        this.blockMetaTextField.textField.setPrefaceText("Meta: ");
        this.blockMetaTextField.setOnValueChanged(() -> this.setDisplayBlock(DisplayChunk.displayBlockId, this.blockMetaTextField.getCurrentElement()));
        buttonList.add(this.blockMetaTextField);
        int yPos = this.blockMetaTextField.yPosition + 21;
        int xPos = this.modelViewer.width;
        BlockEntry entry = this.entryHashMap.get(Blocks.getBlock(DisplayChunk.displayBlockId));
        if (entry != null && (list = entry.getEntryButtons(this.mc, this.modelViewer, this.mc.currentWorld, DisplayChunk.displayBlockMeta)) != null) {
            for (ButtonElement button : list) {
                button.setX(button.getX() + xPos);
                button.setY(button.getY() + yPos);
            }
            buttonList.addAll(list);
        }
    }

    @Override
    public void cycleCategoryEntry(int offset) {
    }

    @Override
    public void onOpen() {
        this.setDisplayBlock(1, 0);
    }

    @Override
    public void onClose() {
        this.setDisplayBlock(0, 0);
    }

    @Override
    public void onTick() {
        BlockEntry entry = this.entryHashMap.get(Blocks.getBlock(DisplayChunk.displayBlockId));
        if (entry != null) {
            entry.onTick(this.mc.currentWorld, DisplayChunk.displayBlockMeta);
        }
        this.mc.currentWorld.loadedEntityList.removeIf(entity -> entity instanceof EntityItem);
    }

    @Override
    public void queueBulkRender(@NotNull File outputDir, List<BlockRenderInfo> renderInfos) {
        int startId;
        int id = startId = 1;
        do {
            Block<?> block;
            if ((block = Blocks.getBlock(id)) == null) continue;
            BlockModel bModel = (BlockModel)BlockModelDispatcher.getInstance().getDispatch(block);
            int meta = 0;
            if (Block.hasLogicClass(block, BlockLogicPortal.class)) {
                meta |= 8;
            }
            if (Block.hasLogicClass(block, BlockLogicChest.class)) {
                meta = BlockLogicChest.getMetaWithDirection(meta, Direction.SOUTH);
            }
            if (Block.hasLogicClass(block, BlockLogicRotatable.class)) {
                meta = BlockLogicRotatable.setDirection(meta, Direction.SOUTH);
            }
            if (Block.hasLogicClass(block, BlockLogicVeryRotatable.class)) {
                meta = BlockLogicVeryRotatable.setDirection(meta, Direction.SOUTH);
            }
            if (Block.hasLogicClass(block, BlockLogicFullyRotatable.class)) {
                meta |= BlockLogicFullyRotatable.directionToMeta(Direction.SOUTH);
            }
            if (Block.hasLogicClass(block, BlockLogicPistonBase.class)) {
                meta |= Direction.SOUTH.getId();
            }
            if (Block.hasLogicClass(block, BlockLogicPistonHead.class)) {
                meta |= Direction.SOUTH.getId();
                if (block == Blocks.PISTON_HEAD_STEEL) {
                    meta = BlockLogicPistonHead.setPistonType(2, meta);
                }
            }
            if (Block.hasLogicClass(block, BlockLogicLadder.class)) {
                meta |= ((BlockLogicLadder)block.getLogic()).getMetaForSide(Side.SOUTH);
            }
            if (Block.hasLogicClass(block, BlockLogicButton.class)) {
                meta |= 3;
            }
            if (Block.hasLogicClass(block, BlockLogicLever.class)) {
                meta |= 3;
            }
            float rot = 0.0f;
            if (bModel instanceof BlockModelCrossedSquares) {
                rot = -45.0f;
            }
            float zoom = 9.0f;
            if (Block.hasLogicClass(block, IPainted.class)) {
                for (DyeColor color : DyeColor.blockOrderedColors()) {
                    int newMeta = meta | ((IPainted)block.getLogic()).toMetadata(color);
                    renderInfos.add(new BlockRenderInfo(new File(outputDir, block.namespaceId().value() + "_" + color.colorID + ".png"), id, newMeta, rot, zoom));
                }
            } else if (Block.hasLogicClass(block, BlockLogicFlowerStackable.class)) {
                for (int i = 0; i <= 3; ++i) {
                    renderInfos.add(new BlockRenderInfo(new File(outputDir, block.namespaceId().value() + "_" + i + ".png"), id, BlockLogicFlowerStackable.setStackCount(meta, i), rot, zoom));
                }
            } else if (Block.hasLogicClass(block, BlockLogicCropsWheat.class)) {
                for (int i = 0; i <= 7; ++i) {
                    renderInfos.add(new BlockRenderInfo(new File(outputDir, block.namespaceId().value() + "_" + i + ".png"), id, meta | i, rot, zoom));
                }
            } else if (Block.hasLogicClass(block, BlockLogicCropsPumpkin.class)) {
                for (int i = 0; i < 5; ++i) {
                    renderInfos.add(new BlockRenderInfo(new File(outputDir, block.namespaceId().value() + "_" + i + ".png"), id, meta | i, rot, zoom));
                }
            } else {
                renderInfos.add(new BlockRenderInfo(new File(outputDir, block.namespaceId().value() + ".png"), id, meta, rot, zoom));
            }
        } while ((id = ScreenModelViewer.cycleBlockId(id, 1)) != startId);
    }

    @Override
    public void setupRender(BlockRenderInfo info) {
        this.setDisplayBlock(info.blockId, info.blockMeta);
    }

    public void setDisplayBlock(int id, int meta) {
        Block<?> displayBlock = Blocks.blocksList[DisplayChunk.displayBlockId];
        BlockEntry entry = this.entryHashMap.get(Blocks.getBlock(DisplayChunk.displayBlockId));
        int _id = DisplayChunk.displayBlockId;
        int _meta = DisplayChunk.displayBlockMeta;
        if (displayBlock != null && _id != id) {
            displayBlock.onBlockRemoved(this.mc.currentWorld, (int)this.mc.thePlayer.x, (int)this.mc.thePlayer.y + 1, (int)this.mc.thePlayer.z, _meta);
        }
        if (entry != null) {
            entry.onClose(this.mc.currentWorld, DisplayChunk.displayBlockMeta);
        }
        DisplayChunk.displayBlockPosX = (int)this.mc.thePlayer.x;
        DisplayChunk.displayBlockPosY = (int)this.mc.thePlayer.y + 1;
        DisplayChunk.displayBlockPosZ = (int)this.mc.thePlayer.z;
        DisplayChunk.displayBlockId = id;
        DisplayChunk.displayBlockMeta = meta;
        displayBlock = Blocks.blocksList[id];
        if (displayBlock != null && _id != id) {
            entry = this.entryHashMap.get(Blocks.getBlock(DisplayChunk.displayBlockId));
            displayBlock.onBlockPlacedByWorld(this.mc.currentWorld, (int)this.mc.thePlayer.x, (int)this.mc.thePlayer.y + 1, (int)this.mc.thePlayer.z);
            if (entry != null) {
                entry.onOpen(this.mc.currentWorld, DisplayChunk.displayBlockMeta);
            }
        }
        if (_id != id) {
            this.modelViewer.init();
        }
        this.mc.particleEngine.setWorld(this.mc.currentWorld);
        this.mc.currentWorld.markBlockDirty(DisplayChunk.displayBlockPosX, DisplayChunk.displayBlockPosY, DisplayChunk.displayBlockPosZ);
    }

    public static class BlockRenderInfo
    extends ModelViewerCategory.Info {
        @NotNull
        final File outputDir;
        final int blockId;
        final int blockMeta;
        final float rot;
        final float zoom;

        public BlockRenderInfo(@NotNull File outputDir, int blockId, int blockMeta, float rot, float zoom) {
            this.outputDir = outputDir;
            this.blockId = blockId;
            this.blockMeta = blockMeta;
            this.rot = rot;
            this.zoom = zoom;
        }

        @Override
        @NotNull
        public File outputFile() {
            return this.outputDir;
        }

        @Override
        public float renderRotation() {
            return this.rot;
        }

        @Override
        public float renderZoom() {
            return this.zoom;
        }
    }
}

