/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.modelviewer.elements;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Screen;
import net.minecraft.client.gui.modelviewer.elements.ListenerButtonElement;
import net.minecraft.client.gui.text.ITextField;
import net.minecraft.client.gui.text.TextFieldEditor;
import net.minecraft.client.render.font.FontRenderer;
import net.minecraft.core.util.helper.MathHelper;
import org.lwjgl.input.Keyboard;

public class ListenerTextFieldElement
extends ListenerButtonElement
implements ITextField {
    private final FontRenderer fontRenderer;
    private String text = "";
    private String prefaceText = "";
    private int maxStringLength;
    private int cursorCounter;
    public boolean isFocused;
    public boolean isEnabled;
    public boolean removeTextOnClick = false;
    public Screen parent;
    private ITextChangeListener textChangeListener;
    private String placeholder;
    public boolean drawBackground = true;
    public final TextFieldEditor editor;

    public ListenerTextFieldElement(Screen parent, FontRenderer fontRenderer, int xPosition, int yPosition, int width, int height, String defaultText, String placeholder) {
        super(-1, xPosition, yPosition, width, height, "");
        this.playSound = false;
        this.isFocused = false;
        this.isEnabled = true;
        this.parent = parent;
        this.fontRenderer = fontRenderer;
        this.editor = new TextFieldEditor(this);
        this.placeholder = placeholder;
        this.setText(defaultText);
        this.editor.setCursor(10000);
    }

    public ListenerTextFieldElement setPrefaceText(String prefaceText) {
        this.prefaceText = prefaceText;
        return this;
    }

    @Override
    public void setText(String text) {
        if (text == null) {
            this.editor.setCursor(0);
        } else if (text.length() < this.editor.getCursor()) {
            this.editor.setCursor(text.length());
        }
        this.text = text;
        if (this.textChangeListener != null) {
            this.textChangeListener.textChanged(this);
        }
    }

    @Override
    public String getText() {
        return this.text;
    }

    public void setPlaceholder(String placeholder) {
        this.placeholder = placeholder;
    }

    @Override
    public void tick() {
        ++this.cursorCounter;
    }

    @Override
    public void onKeyTyped(char c, int key) {
        if (!this.isEnabled || !this.isFocused) {
            return;
        }
        if (key == Keyboard.KEY_TAB && this.parent != null) {
            this.parent.selectNextField();
        }
        if (this.editor.handleInput(key, c)) {
            if (this.textChangeListener != null) {
                this.textChangeListener.textChanged(this);
            }
            if (this.keyListener != null) {
                this.keyListener.onKeyPressed(key);
            }
            this.onValueChanged();
        }
    }

    @Override
    public boolean mouseClicked(Minecraft mc, int mouseX, int mouseY) {
        boolean flag = super.mouseClicked(mc, mouseX, mouseY);
        this.setFocused(flag);
        return flag;
    }

    @Override
    protected void onClick(Minecraft mc, int mouseX, int mouseY) {
        if (this.removeTextOnClick) {
            this.setText("");
        }
        super.onClick(mc, mouseX, mouseY);
    }

    public void setFocused(boolean flag) {
        if (flag && !this.isFocused) {
            this.cursorCounter = 0;
            this.editor.setCursor(10000);
        }
        this.isFocused = flag;
    }

    @Override
    public void drawButton(Minecraft mc, int mouseX, int mouseY) {
        if (!this.visible) {
            return;
        }
        if (this.drawBackground) {
            this.drawRect(this.xPosition - 1, this.yPosition - 1, this.xPosition + this.width + 1, this.yPosition + this.height + 1, -6250336);
            this.drawRect(this.xPosition, this.yPosition, this.xPosition + this.width, this.yPosition + this.height, -16777216);
        }
        if (this.text.isEmpty() && !this.isFocused) {
            this.drawStringShadow(this.fontRenderer, this.placeholder, this.xPosition + 4, this.yPosition + (this.height - 8) / 2, 0x5F5F5F);
        }
        if (this.isEnabled) {
            boolean drawCursor = this.isFocused && this.cursorCounter / 6 % 2 == 0;
            int cursor = this.editor.getCursor();
            int maxDisplayableChars = this.width / this.fontRenderer.getFont().charWidth('_');
            if (!this.text.isEmpty() || this.isFocused) {
                if (this.prefaceText.length() + this.text.length() <= maxDisplayableChars - 1) {
                    this.drawStringShadow(this.fontRenderer, this.prefaceText + this.text, this.xPosition + 4, this.yPosition + (this.height - 8) / 2, 0xE0E0E0);
                } else {
                    String newString = this.prefaceText + this.text;
                    int begin = Math.max(0, cursor - maxDisplayableChars);
                    int end = Math.max(maxDisplayableChars, Math.min(newString.length(), cursor));
                    this.drawStringShadow(this.fontRenderer, newString.substring(begin, end), this.xPosition + 4, this.yPosition + (this.height - 8) / 2, 0xE0E0E0);
                }
            }
            if (drawCursor) {
                String currentText = "";
                if (!this.text.isEmpty() || this.isFocused) {
                    currentText = this.prefaceText + this.text;
                }
                int width = MathHelper.ceil(this.fontRenderer.stringWidthDouble(currentText));
                if (cursor < this.text.length()) {
                    width = MathHelper.ceil(this.fontRenderer.stringWidthDouble(this.text.substring(0, cursor)) + this.fontRenderer.stringWidthDouble(this.prefaceText));
                }
                if (width >= this.width - 4) {
                    width = this.width - 4 - MathHelper.ceil(this.fontRenderer.stringWidthDouble(currentText.substring(currentText.length() - 2, currentText.length() - 1)));
                }
                this.drawStringShadow(this.fontRenderer, "_", this.xPosition + 4 + width, this.yPosition + (this.height - 8) / 2, 0xE0E0E0);
            }
        } else {
            this.drawStringShadow(this.fontRenderer, this.text, this.xPosition + 4, this.yPosition + (this.height - 8) / 2, 0x707070);
        }
    }

    public void setMaxStringLength(int i) {
        this.maxStringLength = i;
    }

    @Override
    public int maxLength() {
        return this.maxStringLength == 0 ? 1000 : this.maxStringLength;
    }

    @Override
    public boolean isHovered(int mouseX, int mouseY) {
        return this.isFocused || super.isHovered(mouseX, mouseY);
    }

    public ListenerTextFieldElement setTextChangeListener(ITextChangeListener textChangeListener) {
        this.textChangeListener = textChangeListener;
        return this;
    }

    public static interface ITextChangeListener {
        public void textChanged(ListenerTextFieldElement var1);
    }
}

