/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.window;

import com.github.zarzelcow.legacylwjgl3.implementation.glfw.GLFWKeyboardImplementation;
import com.github.zarzelcow.legacylwjgl3.implementation.glfw.GLFWMouseImplementation;
import com.github.zarzelcow.legacylwjgl3.implementation.input.CombinedInputImplementation;
import com.github.zarzelcow.legacylwjgl3.implementation.input.InputImplementation;
import com.mojang.logging.CategorizedLogger;
import com.mojang.logging.LogUtils;
import java.awt.Dimension;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.swing.JFrame;
import net.minecraft.client.Minecraft;
import net.minecraft.client.render.PanelCrashReport;
import net.minecraft.client.render.window.CursorShape;
import net.minecraft.client.render.window.GameWindow;
import net.minecraft.core.Global;
import net.minecraft.core.UnexpectedThrowable;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.PointerBuffer;
import org.lwjgl.glfw.GLFW;
import org.lwjgl.glfw.GLFWImage;
import org.lwjgl.glfw.GLFWVidMode;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.Display;
import org.lwjgl.opengl.GL;
import org.lwjgl.stb.STBImage;
import org.lwjgl.system.Struct;

public class GameWindowGLFW
implements GameWindow {
    public static final CategorizedLogger LOGGER = LogUtils.getLogger();
    public Minecraft mc;
    public long window;
    private boolean wasResized = false;
    private boolean isFullscreen = false;
    private boolean hasFocus = true;
    private int windowPosX;
    private int windowPosY;
    private int windowWidth;
    private int windowHeight;
    private int widthScreenCoords;
    private int heightScreenCoords;
    private int widthPixels;
    private int heightPixels;
    private final Map<CursorShape, Long> cursors = new HashMap<CursorShape, Long>();
    private CursorShape currentCursor = CursorShape.ARROW;
    private static ByteBuffer buffer = BufferUtils.createByteBuffer((int)0x100000);

    @Override
    public void init(Minecraft minecraft, int width, int height) {
        block5: {
            this.mc = minecraft;
            LOGGER.info("Initializing GLFW...");
            if (!GLFW.glfwInit()) {
                throw new RuntimeException("GLFW initialization failed!");
            }
            GLFW.glfwWindowHint((int)131075, (int)1);
            GLFW.glfwWindowHint((int)131076, (int)0);
            GLFW.glfwWindowHint((int)131078, (int)1);
            GLFW.glfwWindowHint((int)131077, (int)1);
            this.window = GLFW.glfwCreateWindow((int)width, (int)height, (CharSequence)("Better than Adventure! " + Global.VERSION), (long)0L, (long)0L);
            int[] w = new int[1];
            int[] h = new int[1];
            GLFW.glfwGetWindowSize((long)this.window, (int[])w, (int[])h);
            this.widthScreenCoords = w[0];
            this.heightScreenCoords = h[0];
            GLFW.glfwGetFramebufferSize((long)this.window, (int[])w, (int[])h);
            this.widthPixels = w[0];
            this.heightPixels = h[0];
            MonitorInfo monitor = new MonitorInfo(GLFW.glfwGetPrimaryMonitor());
            GLFW.glfwSetWindowPos((long)this.window, (int)((monitor.widthScreenCoords - this.widthScreenCoords) / 2), (int)((monitor.heightScreenCoords - this.heightScreenCoords) / 2));
            GLFW.glfwSetWindowSizeCallback((long)this.window, (window, ww, hh) -> {
                this.widthScreenCoords = Math.max(1, ww);
                this.heightScreenCoords = Math.max(1, hh);
                this.wasResized = true;
            });
            GLFW.glfwSetFramebufferSizeCallback((long)this.window, (window, ww, hh) -> {
                this.widthPixels = Math.max(1, ww);
                this.heightPixels = Math.max(1, hh);
                this.wasResized = true;
            });
            GLFW.glfwSetWindowFocusCallback((long)this.window, (window, focused) -> {
                this.hasFocus = focused;
                if (Mouse.isGrabbed() && !focused) {
                    Mouse.setGrabbed(false);
                }
            });
            int[] resolutions = new int[]{16, 32, 64, 128, 256};
            GLFWImage.Buffer gb = GLFWImage.create((int)resolutions.length);
            for (int i = 0; i < resolutions.length; ++i) {
                int res = resolutions[i];
                ByteBuffer icon = GameWindowGLFW.getImageBuffer("/icon/" + res + ".png");
                if (icon == null) {
                    LOGGER.error("Icon at resolution '{}' is null! Skipping icons!", (Object)res);
                    gb.close();
                    break block5;
                }
                GLFWImage iconGI = GLFWImage.create().set(res, res, icon);
                gb.put(i, (Struct)iconGI);
            }
            GLFW.glfwSetWindowIcon((long)this.window, (GLFWImage.Buffer)gb);
        }
        GLFW.glfwShowWindow((long)this.window);
        GLFW.glfwMakeContextCurrent((long)this.window);
        GL.createCapabilities();
        Display.setWindow(this);
        try {
            Method createKeyboard = Keyboard.class.getDeclaredMethod("create", InputImplementation.class);
            createKeyboard.setAccessible(true);
            Method createMouse = Mouse.class.getDeclaredMethod("create", InputImplementation.class);
            createMouse.setAccessible(true);
            GLFWKeyboardImplementation keyboardImplementation = new GLFWKeyboardImplementation();
            GLFWMouseImplementation mouseImplementation = new GLFWMouseImplementation();
            CombinedInputImplementation inputImplementation = new CombinedInputImplementation(keyboardImplementation, mouseImplementation);
            createKeyboard.invoke(null, inputImplementation);
            createMouse.invoke(null, inputImplementation);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
        this.setVsync((Boolean)this.mc.gameSettings.enableVsync.value);
    }

    @Override
    public void setCursorShape(CursorShape shape) {
        int shapeVal;
        switch (shape) {
            case ARROW: {
                shapeVal = 221185;
                break;
            }
            case I_BEAM: {
                shapeVal = 221186;
                break;
            }
            case CROSSHAIR: {
                shapeVal = 221187;
                break;
            }
            case HAND: {
                shapeVal = 221188;
                break;
            }
            case HORIZONTAL_RESIZE: {
                shapeVal = 221189;
                break;
            }
            case VERTICAL_RESIZE: {
                shapeVal = 221190;
                break;
            }
            default: {
                return;
            }
        }
        if (this.cursors.containsKey((Object)shape)) {
            GLFW.glfwSetCursor((long)this.window, (long)this.cursors.get((Object)shape));
        } else {
            long cursor = GLFW.glfwCreateStandardCursor((int)shapeVal);
            this.cursors.put(shape, cursor);
            GLFW.glfwSetCursor((long)this.window, (long)cursor);
        }
        this.currentCursor = shape;
    }

    @Override
    public void setWindowSize(int width, int height) {
        GLFW.glfwSetWindowSize((long)this.window, (int)width, (int)height);
    }

    @Override
    public CursorShape getCursorShape() {
        return this.currentCursor;
    }

    @Override
    public void toggleFullscreen() {
        this.mc.gameSettings.fullscreen.value = (Boolean)this.mc.gameSettings.fullscreen.value == false;
        this.updateWindowState();
    }

    @Override
    public void updateWindowState() {
        if (!this.isFullscreen) {
            int[] x = new int[1];
            int[] y = new int[1];
            GLFW.glfwGetWindowPos((long)this.window, (int[])x, (int[])y);
            int[] w = new int[1];
            int[] h = new int[1];
            GLFW.glfwGetWindowSize((long)this.window, (int[])w, (int[])h);
            this.windowPosX = x[0];
            this.windowPosY = y[0];
            this.windowWidth = w[0];
            this.windowHeight = h[0];
        }
        boolean fullscreen = (Boolean)this.mc.gameSettings.fullscreen.value;
        boolean borderless = (Boolean)this.mc.gameSettings.borderlessFullscreen.value;
        GLFW.glfwHideWindow((long)this.window);
        if (fullscreen && !borderless) {
            LOGGER.info("Setting window to FULLSCREEN...");
            int x = this.windowPosX + this.windowWidth / 2;
            int y = this.windowPosY + this.windowHeight / 2;
            MonitorInfo monitor = this.getMonitorAt(x, y);
            GLFW.glfwSetWindowMonitor((long)this.window, (long)monitor.handle, (int)monitor.posX, (int)monitor.posY, (int)monitor.widthScreenCoords, (int)monitor.heightScreenCoords, (int)monitor.refreshRate);
            this.isFullscreen = true;
        } else {
            GLFW.glfwSetWindowMonitor((long)this.window, (long)0L, (int)this.windowPosX, (int)this.windowPosY, (int)this.windowWidth, (int)this.windowHeight, (int)0);
            if (fullscreen && borderless) {
                LOGGER.info("Setting window to BORDERLESS FULLSCREEN...");
                int x = this.windowPosX + this.windowWidth / 2;
                int y = this.windowPosY + this.windowHeight / 2;
                MonitorInfo monitor = this.getMonitorAt(x, y);
                GLFW.glfwSetWindowAttrib((long)this.window, (int)131077, (int)0);
                GLFW.glfwSetWindowPos((long)this.window, (int)monitor.posX, (int)monitor.posY);
                GLFW.glfwSetWindowSize((long)this.window, (int)monitor.widthScreenCoords, (int)monitor.heightScreenCoords);
                this.isFullscreen = true;
            } else {
                LOGGER.info("Setting window to WINDOWED...");
                GLFW.glfwSetWindowAttrib((long)this.window, (int)131077, (int)1);
                this.isFullscreen = false;
            }
        }
        GLFW.glfwShowWindow((long)this.window);
    }

    public MonitorInfo getMonitorAt(int x, int y) {
        PointerBuffer monitorPointers = GLFW.glfwGetMonitors();
        for (int i = monitorPointers.position(); i < monitorPointers.limit(); ++i) {
            long monitor = monitorPointers.get(i);
            MonitorInfo info = new MonitorInfo(monitor);
            if (x < info.posX || y < info.posY || x >= info.posX + info.widthScreenCoords || y >= info.posY + info.heightScreenCoords) continue;
            return info;
        }
        return new MonitorInfo(GLFW.glfwGetPrimaryMonitor());
    }

    @Override
    public void displayCrashReport(UnexpectedThrowable unexpectedThrowable, int cause) {
        JFrame frame = new JFrame();
        PanelCrashReport panel = new PanelCrashReport(this.mc, unexpectedThrowable, cause);
        panel.setPreferredSize(new Dimension(1280, 720));
        frame.add(panel);
        frame.pack();
        frame.setLocationRelativeTo(null);
        frame.setDefaultCloseOperation(2);
        frame.setVisible(true);
    }

    @Override
    public int getFrequency() {
        GLFWVidMode vidMode = GLFW.glfwGetVideoMode((long)this.window);
        if (vidMode != null) {
            return vidMode.refreshRate();
        }
        int x = this.windowPosX + this.windowWidth / 2;
        int y = this.windowPosY + this.windowHeight / 2;
        MonitorInfo monitor = this.getMonitorAt(x, y);
        return monitor.refreshRate;
    }

    @Override
    public void update() {
        GLFW.glfwPollEvents();
        if (this.isFocused()) {
            Keyboard.poll();
        }
        Mouse.poll();
        GLFW.glfwSwapBuffers((long)this.window);
    }

    @Override
    public boolean shouldClose() {
        return GLFW.glfwWindowShouldClose((long)this.window);
    }

    @Override
    public int getWidthScreenCoords() {
        return this.widthScreenCoords;
    }

    @Override
    public int getHeightScreenCoords() {
        return this.heightScreenCoords;
    }

    @Override
    public int getWidthPixels() {
        return this.widthPixels;
    }

    @Override
    public int getHeightPixels() {
        return this.heightPixels;
    }

    @Override
    public boolean isFocused() {
        return this.hasFocus;
    }

    @Override
    public boolean wasResized() {
        if (this.wasResized) {
            this.wasResized = false;
            return true;
        }
        return false;
    }

    @Override
    public void setVsync(boolean vsync) {
        if (vsync) {
            GLFW.glfwSwapInterval((int)1);
        } else {
            GLFW.glfwSwapInterval((int)0);
        }
    }

    @Override
    public long getHandle() {
        return this.window;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public static ByteBuffer getImageBuffer(String resource) {
        try (InputStream stream = GameWindowGLFW.class.getResourceAsStream(resource);){
            int value;
            if (stream == null) {
                LOGGER.error("No icon could be found at '{}'!", resource);
                ByteBuffer byteBuffer2 = null;
                return byteBuffer2;
            }
            buffer.clear();
            while ((value = stream.read()) != -1) {
                if (buffer.remaining() < 1) {
                    ByteBuffer newBuf = BufferUtils.createByteBuffer((int)(buffer.capacity() * 2));
                    newBuf.put(buffer);
                    buffer = newBuf;
                }
                buffer.put((byte)value);
            }
            IntBuffer x = BufferUtils.createIntBuffer((int)1);
            IntBuffer y = BufferUtils.createIntBuffer((int)1);
            IntBuffer comp = BufferUtils.createIntBuffer((int)1);
            ByteBuffer byteBuffer = Objects.requireNonNull(STBImage.stbi_load_from_memory((ByteBuffer)((ByteBuffer)buffer.flip()), (IntBuffer)x, (IntBuffer)y, (IntBuffer)comp, (int)4), STBImage::stbi_failure_reason);
            return byteBuffer;
        }
        catch (Exception e) {
            LOGGER.error("Couldn't open icon image...", e);
            return null;
        }
    }

    public static class MonitorInfo {
        public final long handle;
        public final int posX;
        public final int posY;
        public final int widthScreenCoords;
        public final int heightScreenCoords;
        public final int refreshRate;

        public MonitorInfo(long monitor) {
            this.handle = monitor;
            GLFWVidMode vidmode = GLFW.glfwGetVideoMode((long)monitor);
            int[] x = new int[1];
            int[] y = new int[1];
            GLFW.glfwGetMonitorPos((long)monitor, (int[])x, (int[])y);
            this.posX = x[0];
            this.posY = y[0];
            this.widthScreenCoords = vidmode.width();
            this.heightScreenCoords = vidmode.height();
            this.refreshRate = vidmode.refreshRate();
        }
    }
}

