/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.io.PrintStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Objects;
import net.minecraft.client.render.window.GameWindowGLFW;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.LWJGLException;
import org.lwjgl.glfw.GLFW;
import org.lwjgl.glfw.GLFWErrorCallback;
import org.lwjgl.glfw.GLFWImage;
import org.lwjgl.glfw.GLFWVidMode;
import org.lwjgl.glfw.GLFWWindowSizeCallback;
import org.lwjgl.glfw.GLFWWindowSizeCallbackI;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.DisplayMode;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.PixelFormat;
import org.lwjgl.opengl.Sync;
import org.lwjgl.system.Struct;

public final class Display {
    @NotNull
    public static final Display INSTANCE = new Display();
    @NotNull
    private static String title = "";
    @NotNull
    private static DisplayMode displayMode = new DisplayMode(640, 480, 24, 60);
    private static long handleKt = -1L;
    private static boolean resizable;
    private static int widthKt;
    private static int heightKt;
    private static int xPos;
    private static int yPos;
    @Nullable
    private static GameWindowGLFW window;
    private static boolean window_resized;
    @Nullable
    private static GLFWWindowSizeCallback sizeCallback;
    private static ByteBuffer @Nullable [] cached_icons;

    private Display() {
    }

    @NotNull
    public static String getTitle() {
        return title;
    }

    public static void setTitle(@NotNull String value) {
        Objects.requireNonNull(value);
        title = value;
        if (Display.isCreatedKt()) {
            GLFW.glfwSetWindowTitle((long)handleKt, (CharSequence)value);
        }
    }

    @NotNull
    public static DisplayMode getDisplayMode() {
        return displayMode;
    }

    public static void setDisplayMode(@NotNull DisplayMode displayMode) {
        Objects.requireNonNull(displayMode);
        Display.displayMode = displayMode;
    }

    public static long getHandleKt() {
        return handleKt;
    }

    public static void setHandleKt(long handle) {
        handleKt = handle;
    }

    public static int getWidthKt() {
        return widthKt;
    }

    public static void setWidthKt(int width) {
        widthKt = width;
    }

    public static int getHeightKt() {
        return heightKt;
    }

    public static void setHeightKt(int height) {
        heightKt = height;
    }

    public static int getXPos() {
        return xPos;
    }

    public static void setXPos(int xPos) {
        Display.xPos = xPos;
    }

    public static int getYPos() {
        return yPos;
    }

    public static void setYPos(int yPos) {
        Display.yPos = yPos;
    }

    @Nullable
    public static GameWindowGLFW getWindow() {
        return window;
    }

    public static void setWindow(@Nullable GameWindowGLFW value) {
        window = value;
    }

    @Nullable
    public static DisplayMode getDesktopDisplayMode() {
        DisplayMode var12;
        DisplayMode[] $this$maxByOrNull$iv = Display.getAvailableDisplayModes();
        if ($this$maxByOrNull$iv.length == 0) {
            var12 = null;
        } else {
            DisplayMode maxElem$iv = $this$maxByOrNull$iv[0];
            int lastIndex$iv = $this$maxByOrNull$iv.length - 1;
            if (lastIndex$iv != 0) {
                DisplayMode it = maxElem$iv;
                int maxValue$iv = it.getWidth() * it.getHeight();
                int i$iv = 1;
                if (i$iv <= lastIndex$iv) {
                    while (true) {
                        DisplayMode e$iv = $this$maxByOrNull$iv[i$iv];
                        int v$iv = it.getWidth() * it.getHeight();
                        if (maxValue$iv < v$iv) {
                            maxElem$iv = e$iv;
                            maxValue$iv = v$iv;
                        }
                        if (i$iv == lastIndex$iv) break;
                        ++i$iv;
                    }
                }
            }
            var12 = maxElem$iv;
        }
        return var12;
    }

    public static int setIcon(@NotNull ByteBuffer[] icons) {
        Objects.requireNonNull(icons);
        if (!Arrays.equals(cached_icons, icons)) {
            ArrayList<ByteBuffer> destination$iv$iv = new ArrayList<ByteBuffer>(icons.length);
            for (ByteBuffer it : icons) {
                ByteBuffer var12 = INSTANCE.cloneByteBuffer(it);
                destination$iv$iv.add(var12);
            }
            cached_icons = destination$iv$iv.toArray(new ByteBuffer[0]);
        }
        if (Display.isCreatedKt()) {
            GLFW.glfwSetWindowIcon((long)handleKt, (GLFWImage.Buffer)INSTANCE.iconsToGLFWBuffer(Objects.requireNonNull(cached_icons)));
            return 1;
        }
        return 0;
    }

    private ByteBuffer cloneByteBuffer(ByteBuffer original) {
        ByteBuffer clone = BufferUtils.createByteBuffer((int)original.capacity());
        int old_position = original.position();
        clone.put(original);
        original.position(old_position);
        clone.flip();
        return clone;
    }

    private GLFWImage.Buffer iconsToGLFWBuffer(ByteBuffer[] icons) {
        GLFWImage.Buffer buffer = GLFWImage.create((int)icons.length);
        for (ByteBuffer icon : icons) {
            int size = icon.limit() / 4;
            int dimension = (int)Math.sqrt(size);
            try (GLFWImage image = GLFWImage.malloc();){
                buffer.put((Struct)image.set(dimension, dimension, icon));
            }
        }
        buffer.flip();
        return buffer;
    }

    public static void update() {
        window_resized = false;
        GLFW.glfwPollEvents();
        if (Mouse.isCreated()) {
            Mouse.poll();
        }
        if (Keyboard.isCreated()) {
            Keyboard.poll();
        }
        GLFW.glfwSwapBuffers((long)handleKt);
    }

    public static void create(@Nullable PixelFormat pixelFormat) throws LWJGLException {
        GLFWErrorCallback.createPrint((PrintStream)System.err).set();
        boolean var1 = GLFW.glfwInit();
        if (!var1) {
            String var3 = "Unable to initialize GLFW";
            throw new IllegalStateException(var3);
        }
        GLFW.glfwDefaultWindowHints();
        GLFW.glfwWindowHint((int)131076, (int)0);
        GLFW.glfwWindowHint((int)131075, (int)(resizable ? 1 : 0));
        handleKt = GLFW.glfwCreateWindow((int)displayMode.getWidth(), (int)displayMode.getHeight(), (CharSequence)title, (long)0L, (long)0L);
        widthKt = displayMode.getWidth();
        heightKt = displayMode.getHeight();
        GLFW.glfwMakeContextCurrent((long)handleKt);
        GL.createCapabilities();
        sizeCallback = GLFWWindowSizeCallback.create(INSTANCE::resizeCallback);
        GLFW.glfwSetWindowSizeCallback((long)handleKt, (GLFWWindowSizeCallbackI)sizeCallback);
        Mouse.create();
        Keyboard.create();
        GLFW.glfwShowWindow((long)handleKt);
        if (cached_icons != null) {
            Display.setIcon(cached_icons);
        }
    }

    public static void setFullscreen(boolean fullscreen) {
        System.out.println("setFullscreen: " + fullscreen);
        try {
            INSTANCE.resizeCallback(handleKt, displayMode.getWidth(), displayMode.getHeight());
            if (fullscreen) {
                long monitor = GLFW.glfwGetPrimaryMonitor();
                GLFW.glfwSetWindowMonitor((long)handleKt, (long)monitor, (int)0, (int)0, (int)widthKt, (int)heightKt, (int)displayMode.getFrequency());
                xPos = displayMode.getWidth() / 2;
                yPos = displayMode.getHeight() / 2;
            } else {
                GLFW.glfwSetWindowMonitor((long)handleKt, (long)0L, (int)(xPos -= widthKt / 2), (int)(yPos -= heightKt / 2), (int)widthKt, (int)heightKt, (int)-1);
            }
            GLFW.glfwSetWindowSize((long)handleKt, (int)widthKt, (int)heightKt);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    @NotNull
    public static DisplayMode[] getAvailableDisplayModes() {
        long primaryMonitor = GLFW.glfwGetPrimaryMonitor();
        if (primaryMonitor == 0L) {
            return new DisplayMode[0];
        }
        GLFWVidMode.Buffer modes = GLFW.glfwGetVideoModes((long)primaryMonitor);
        if (modes == null) {
            throw new IllegalStateException("No video modes found");
        }
        ArrayList<DisplayMode> displayModes = new ArrayList<DisplayMode>();
        for (GLFWVidMode mode : modes) {
            displayModes.add(new DisplayMode(mode.width(), mode.height(), mode.redBits() + mode.blueBits() + mode.greenBits(), mode.refreshRate()));
        }
        return new HashSet(displayModes).toArray(new DisplayMode[0]);
    }

    private void resizeCallback(long window, int width, int height) {
        if (window == handleKt) {
            window_resized = true;
            widthKt = width;
            heightKt = height;
        }
    }

    public void destroyWindow() {
        Objects.requireNonNull(sizeCallback).free();
        Mouse.destroy();
        Keyboard.destroy();
        GLFW.glfwDestroyWindow((long)handleKt);
    }

    public static long getHandle() {
        return Objects.requireNonNull(Display.getWindow()).window;
    }

    public static int getWidth() {
        return Objects.requireNonNull(Display.getWindow()).getWidthScreenCoords();
    }

    public static int getHeight() {
        return Objects.requireNonNull(Display.getWindow()).getHeightScreenCoords();
    }

    public static boolean isCreated() {
        return Objects.requireNonNull(Display.getWindow()).window != -1L;
    }

    public static void destroy() {
        INSTANCE.destroyWindow();
        GLFW.glfwTerminate();
        GLFWErrorCallback callback = GLFW.glfwSetErrorCallback(null);
        if (callback != null) {
            callback.close();
        }
    }

    public static boolean isCreatedKt() {
        return handleKt != -1L;
    }

    public static boolean isCloseRequested() {
        return GLFW.glfwWindowShouldClose((long)handleKt);
    }

    public static boolean isActive() {
        return true;
    }

    public static void setResizable(boolean isResizable) {
        resizable = isResizable;
        if (Display.isCreatedKt()) {
            GLFW.glfwWindowHint((int)131075, (int)(resizable ? 1 : 0));
        }
    }

    public static void sync(int fps) {
        Sync.sync(fps);
    }

    public static void setVSyncEnabled(boolean enabled) {
        GLFW.glfwSwapInterval((int)(enabled ? 1 : 0));
    }

    public static boolean wasResized() {
        return window_resized;
    }

    static {
        cached_icons = null;
    }
}

