/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.block.model;

import net.minecraft.client.Minecraft;
import net.minecraft.client.render.tessellator.Tessellator;
import net.minecraft.client.render.texture.stitcher.IconCoordinate;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockLogic;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.world.WorldSource;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.useless.dragonfly.DisplayPos;

public abstract class BlockModel<T extends BlockLogic> {
    public static boolean ENABLE_DIRECTIONAL_LIGHTING = true;
    public static final float[] SIDE_LIGHT_MULTIPLIER = new float[]{0.5f, 1.0f, 0.8f, 0.8f, 0.6f, 0.6f};
    public static final float FULL_CUBE_THRESHOLD = 0.0625f;
    public final Block<T> block;

    public BlockModel(Block<T> block) {
        this.block = block;
    }

    public abstract boolean render(@NotNull Tessellator var1, @NotNull WorldSource var2, int var3, int var4, int var5);

    public abstract boolean renderOverbright(@NotNull Tessellator var1, @NotNull WorldSource var2, int var3, int var4, int var5);

    public abstract boolean renderNoCulling(@NotNull Tessellator var1, @NotNull WorldSource var2, int var3, int var4, int var5);

    public abstract boolean renderWithOverrideTexture(@NotNull Tessellator var1, @NotNull WorldSource var2, int var3, int var4, int var5, IconCoordinate var6);

    public abstract void renderStandalone(@NotNull Tessellator var1, int var2, float var3, float var4, @Nullable Integer var5);

    public abstract boolean shouldItemRender3d();

    @NotNull
    public abstract DisplayPos getItemDisplayPos(@NotNull String var1);

    public int renderLayer() {
        return 0;
    }

    @Nullable
    public abstract IconCoordinate getParticleTexture(@NotNull Side var1, int var2);

    @Nullable
    public abstract IconCoordinate getOverlayTexture(int var1);

    public abstract int particleColorIndex(@NotNull WorldSource var1, int var2, int var3, int var4, @NotNull Side var5, int var6);

    public boolean hasOverbright() {
        return false;
    }

    public boolean isRetro() {
        return Minecraft.getMinecraft().currentWorld != null && Minecraft.getMinecraft().currentWorld.isRetro();
    }
}

