/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.block.model;

import net.minecraft.client.render.LightmapHelper;
import net.minecraft.client.render.block.model.BlockModelStandard;
import net.minecraft.client.render.tessellator.Tessellator;
import net.minecraft.client.render.texture.stitcher.IconCoordinate;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockLogic;
import net.minecraft.core.block.BlockLogicSpikes;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.util.phys.AABB;
import net.minecraft.core.world.WorldSource;
import org.jetbrains.annotations.NotNull;

public class BlockModelSpikes<T extends BlockLogic>
extends BlockModelStandard<T> {
    public BlockModelSpikes(Block<T> block) {
        super(block);
    }

    @Override
    public boolean render(@NotNull Tessellator tessellator, @NotNull WorldSource worldSource, int x, int y, int z) {
        int metaData = worldSource.getBlockMetadata(x, y, z);
        IconCoordinate texture = this.getBlockTextureFromSideAndMetadata(Side.EAST, metaData);
        if (BlockModelSpikes.renderBlocks.overrideBlockTexture != null) {
            texture = BlockModelSpikes.renderBlocks.overrideBlockTexture;
        }
        renderBlocks.renderStandardBlock(tessellator, worldSource, this, AABB.getTemporaryBB(0.0, 0.0, 0.0, 1.0, 0.1875, 1.0), x, y, z);
        if (BlockLogicSpikes.isSpikesUp(metaData)) {
            float brightness = 1.0f;
            if (LightmapHelper.isLightmapEnabled()) {
                tessellator.setLightmapCoord(this.block.getLightmapCoord(worldSource, x, y, z));
            } else {
                brightness = renderBlocks.getBlockBrightness(worldSource, x, y, z);
            }
            tessellator.setColorOpaque_F(brightness, brightness, brightness);
            double uMin = texture.getIconUMin();
            double uMax = texture.getIconUMax();
            double vMin = texture.getIconVMin();
            double vMax = texture.getIconVMax();
            double d7 = (double)x + 0.5 - 0.25;
            double d8 = (double)x + 0.5 + 0.25;
            double d9 = (double)z + 0.5 - 0.5;
            double d10 = (double)z + 0.5 + 0.5;
            double mid = 0.25;
            tessellator.addVertexWithUV(d7 - 0.0625, (double)y + 1.0, d9, uMin, vMin);
            tessellator.addVertexWithUV(d7 - 0.0625, (double)y + 0.0, d9, uMin, vMax);
            tessellator.addVertexWithUV(d7 - 0.0625, (double)y + 0.0, d10, uMax, vMax);
            tessellator.addVertexWithUV(d7 - 0.0625, (double)y + 1.0, d10, uMax, vMin);
            tessellator.addVertexWithUV(d7 - 0.0625, (double)y + 1.0, d10, uMin, vMin);
            tessellator.addVertexWithUV(d7 - 0.0625, (double)y + 0.0, d10, uMin, vMax);
            tessellator.addVertexWithUV(d7 - 0.0625, (double)y + 0.0, d9, uMax, vMax);
            tessellator.addVertexWithUV(d7 - 0.0625, (double)y + 1.0, d9, uMax, vMin);
            tessellator.addVertexWithUV(d7 + mid, (double)y + 1.0, d9, uMin, vMin);
            tessellator.addVertexWithUV(d7 + mid, (double)y + 0.0, d9, uMin, vMax);
            tessellator.addVertexWithUV(d7 + mid, (double)y + 0.0, d10, uMax, vMax);
            tessellator.addVertexWithUV(d7 + mid, (double)y + 1.0, d10, uMax, vMin);
            tessellator.addVertexWithUV(d7 + mid, (double)y + 1.0, d10, uMin, vMin);
            tessellator.addVertexWithUV(d7 + mid, (double)y + 0.0, d10, uMin, vMax);
            tessellator.addVertexWithUV(d7 + mid, (double)y + 0.0, d9, uMax, vMax);
            tessellator.addVertexWithUV(d7 + mid, (double)y + 1.0, d9, uMax, vMin);
            tessellator.addVertexWithUV(d8 + 0.0625, (double)y + 1.0, d10, uMin, vMin);
            tessellator.addVertexWithUV(d8 + 0.0625, (double)y + 0.0, d10, uMin, vMax);
            tessellator.addVertexWithUV(d8 + 0.0625, (double)y + 0.0, d9, uMax, vMax);
            tessellator.addVertexWithUV(d8 + 0.0625, (double)y + 1.0, d9, uMax, vMin);
            tessellator.addVertexWithUV(d8 + 0.0625, (double)y + 1.0, d9, uMin, vMin);
            tessellator.addVertexWithUV(d8 + 0.0625, (double)y + 0.0, d9, uMin, vMax);
            tessellator.addVertexWithUV(d8 + 0.0625, (double)y + 0.0, d10, uMax, vMax);
            tessellator.addVertexWithUV(d8 + 0.0625, (double)y + 1.0, d10, uMax, vMin);
            d7 = (double)x + 0.5 - 0.5;
            d8 = (double)x + 0.5 + 0.5;
            d9 = (double)z + 0.5 - 0.25;
            d10 = (double)z + 0.5 + 0.25;
            tessellator.addVertexWithUV(d7, (double)y + 1.0, d9 - 0.0625, uMin, vMin);
            tessellator.addVertexWithUV(d7, (double)y + 0.0, d9 - 0.0625, uMin, vMax);
            tessellator.addVertexWithUV(d8, (double)y + 0.0, d9 - 0.0625, uMax, vMax);
            tessellator.addVertexWithUV(d8, (double)y + 1.0, d9 - 0.0625, uMax, vMin);
            tessellator.addVertexWithUV(d8, (double)y + 1.0, d9 - 0.0625, uMin, vMin);
            tessellator.addVertexWithUV(d8, (double)y + 0.0, d9 - 0.0625, uMin, vMax);
            tessellator.addVertexWithUV(d7, (double)y + 0.0, d9 - 0.0625, uMax, vMax);
            tessellator.addVertexWithUV(d7, (double)y + 1.0, d9 - 0.0625, uMax, vMin);
            tessellator.addVertexWithUV(d7, (double)y + 1.0, d9 + mid, uMin, vMin);
            tessellator.addVertexWithUV(d7, (double)y + 0.0, d9 + mid, uMin, vMax);
            tessellator.addVertexWithUV(d8, (double)y + 0.0, d9 + mid, uMax, vMax);
            tessellator.addVertexWithUV(d8, (double)y + 1.0, d9 + mid, uMax, vMin);
            tessellator.addVertexWithUV(d8, (double)y + 1.0, d9 + mid, uMin, vMin);
            tessellator.addVertexWithUV(d8, (double)y + 0.0, d9 + mid, uMin, vMax);
            tessellator.addVertexWithUV(d7, (double)y + 0.0, d9 + mid, uMax, vMax);
            tessellator.addVertexWithUV(d7, (double)y + 1.0, d9 + mid, uMax, vMin);
            tessellator.addVertexWithUV(d8, (double)y + 1.0, d10 + 0.0625, uMin, vMin);
            tessellator.addVertexWithUV(d8, (double)y + 0.0, d10 + 0.0625, uMin, vMax);
            tessellator.addVertexWithUV(d7, (double)y + 0.0, d10 + 0.0625, uMax, vMax);
            tessellator.addVertexWithUV(d7, (double)y + 1.0, d10 + 0.0625, uMax, vMin);
            tessellator.addVertexWithUV(d7, (double)y + 1.0, d10 + 0.0625, uMin, vMin);
            tessellator.addVertexWithUV(d7, (double)y + 0.0, d10 + 0.0625, uMin, vMax);
            tessellator.addVertexWithUV(d8, (double)y + 0.0, d10 + 0.0625, uMax, vMax);
            tessellator.addVertexWithUV(d8, (double)y + 1.0, d10 + 0.0625, uMax, vMin);
        }
        return true;
    }

    @Override
    public boolean shouldItemRender3d() {
        return false;
    }
}

