/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.entity;

import net.minecraft.client.Minecraft;
import net.minecraft.client.render.entity.MobRenderer;
import net.minecraft.client.render.item.model.ItemModelDispatcher;
import net.minecraft.client.render.tessellator.Tessellator;
import net.minecraft.core.entity.animal.MobWolf;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.item.material.ArmorMaterial;
import net.minecraft.core.util.helper.MathHelper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.opengl.GL11;
import org.useless.dragonfly.models.entity.BoneTransform;
import org.useless.dragonfly.models.entity.StaticEntityModel;

public class MobRendererWolf
extends MobRenderer<MobWolf> {
    public MobRendererWolf(float shadowSize) {
        super(shadowSize);
    }

    @Override
    @Nullable
    protected StaticEntityModel getAndSetupModelForLayer(@NotNull MobWolf entity, float brightness, float partialTick, int layer) {
        StaticEntityModel model;
        if (layer == 1) {
            ArmorMaterial material = entity.getArmorMaterial();
            if (material == null) {
                return null;
            }
            this.bindTexture(String.format("/assets/%s/textures/armor/wolf/%s.png", material.identifier.namespace(), material.identifier.value()));
            model = this.getModel("armor");
        } else {
            model = this.getModel("main");
        }
        model.resetBones();
        BoneTransform tail = model.getTransform("tail");
        BoneTransform bodyUpper = model.getTransform("upperBody");
        BoneTransform body = model.getTransform("body");
        BoneTransform head = model.getTransform("head");
        BoneTransform leg0 = model.getTransform("leg0");
        BoneTransform leg1 = model.getTransform("leg1");
        BoneTransform leg2 = model.getTransform("leg2");
        BoneTransform leg3 = model.getTransform("leg3");
        float bodyYaw = this.getBodyYaw(entity, partialTick);
        float headYaw = this.getHeadYaw(entity, partialTick) - bodyYaw;
        float headPitch = this.getHeadPitch(entity, partialTick);
        float limbSwing = this.getLimbSwing(entity, partialTick);
        float limbYaw = this.getLimbYaw(entity, partialTick);
        float limbPitch = this.getLimbPitch(entity, partialTick);
        tail.rotY = entity.isWolfAngry() ? 0.0 : (double)(MathHelper.cos(limbSwing * 0.6662f) * 1.4f * limbYaw);
        if (entity.isWolfSitting()) {
            body.rotX = -33.5 * (double)MathHelper.DEG_TO_RAD;
            body.posY = -4.5;
            body.posZ = -2.0;
            bodyUpper.rotX = -18.0f * MathHelper.DEG_TO_RAD;
            bodyUpper.posY = -3.0;
            leg0.rotX = -90.0f * MathHelper.DEG_TO_RAD;
            leg0.posY = -7.0;
            leg0.posZ = -3.0;
            leg1.rotX = -90.0f * MathHelper.DEG_TO_RAD;
            leg1.posY = -7.0;
            leg1.posZ = -3.0;
            leg2.rotX = -22.5 * (double)MathHelper.DEG_TO_RAD;
            leg2.posY = -1.0;
            leg3.rotX = -22.5 * (double)MathHelper.DEG_TO_RAD;
            leg3.posY = -1.0;
            tail.posY = -9.0;
            tail.posZ = -3.0;
        } else {
            leg0.rotX = MathHelper.cos(limbSwing * 0.6662f) * 1.4f * limbYaw;
            leg1.rotX = MathHelper.cos(limbSwing * 0.6662f + (float)Math.PI) * 1.4f * limbYaw;
            leg2.rotX = MathHelper.cos(limbSwing * 0.6662f + (float)Math.PI) * 1.4f * limbYaw;
            leg3.rotX = MathHelper.cos(limbSwing * 0.6662f) * 1.4f * limbYaw;
        }
        head.rotZ = entity.getInterestedAngle(partialTick) + entity.getShakeAngle(partialTick, 0.0f);
        bodyUpper.rotZ = entity.getShakeAngle(partialTick, -0.08f);
        body.rotZ = entity.getShakeAngle(partialTick, -0.16f);
        tail.rotZ = entity.getShakeAngle(partialTick, -0.2f);
        if (entity.getWolfShaking()) {
            float shading = brightness * entity.getShadingWhileShaking(partialTick);
            GL11.glColor3f((float)shading, (float)shading, (float)shading);
        }
        head.rotX = headPitch;
        head.rotY = headYaw;
        tail.rotX = limbPitch;
        return model;
    }

    @Override
    protected int maxRenderLayer(@NotNull MobWolf entity) {
        return entity.getArmorMaterial() != null ? 1 : 0;
    }

    @Override
    protected float getLimbPitch(@NotNull MobWolf wolf, float partialTick) {
        if (wolf.isWolfAngry()) {
            return 88.0f * MathHelper.DEG_TO_RAD;
        }
        if (wolf.isWolfTamed()) {
            return (0.55f - (float)(wolf.getMaxHealth() - wolf.getHealth()) * 0.02f) * (float)Math.PI;
        }
        return 36.0f * MathHelper.DEG_TO_RAD;
    }

    @Override
    protected void renderAdditional(@NotNull Tessellator tessellator, @NotNull MobWolf entity, float partialTick) {
        ItemStack itemstack = entity.getHeldItem();
        if (itemstack != null) {
            GL11.glPushMatrix();
            this.getModel("main").translateToBone("mouthItem");
            GL11.glScalef((float)16.0f, (float)-16.0f, (float)16.0f);
            GL11.glEnable((int)32826);
            GL11.glEnable((int)3042);
            ItemModelDispatcher.getInstance().getDispatch(itemstack).render(Tessellator.instance, entity, itemstack, "ground", (Boolean)Minecraft.getMinecraft().gameSettings.items3D.value, 1, entity.getBrightness(partialTick), 1.0f, partialTick, true);
            GL11.glDisable((int)3042);
            GL11.glDisable((int)32826);
            GL11.glPopMatrix();
        }
    }
}

