/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.sound;

import com.b100.utils.StreamUtils;
import com.b100.utils.StringUtils;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import java.io.File;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.minecraft.client.render.texturepack.TexturePack;
import net.minecraft.client.sound.SoundEntry;
import net.minecraft.client.sound.SoundEvent;
import net.minecraft.client.sound.SoundRepository;
import net.minecraft.core.data.registry.Registry;
import net.minecraft.core.lang.I18n;

public class NamedSoundRepository
extends Registry<SoundEvent> {
    public static final String JAR_SOUNDS_LOCATION_FORMAT = "/assets/%s/sounds/";
    public static final String FOLDER_SOUNDS_LOCATION_FORMAT = "/resources/%s/sounds/";
    public static final String ASSET_PACK_FOLDER_SOUNDS_LOCATION_FORMAT = "/packResources/%s/sounds/";
    public final String namespace;
    public final File rootFile;

    public NamedSoundRepository(String namespace) {
        this.namespace = namespace;
        this.rootFile = new File(SoundRepository.mc.getMinecraftDir(), String.format(FOLDER_SOUNDS_LOCATION_FORMAT, namespace));
        this.loadFromPath(String.format(JAR_SOUNDS_LOCATION_FORMAT, namespace) + "sounds.json");
    }

    public void loadFromPath(String path) {
        ArrayList<Throwable> thrown = new ArrayList<Throwable>();
        HashMap<String, SoundEvent> eventMap = new HashMap<String, SoundEvent>();
        TexturePack defaultPack = SoundRepository.mc.texturePackList.getDefaultTexturePack();
        this.loadFromPack(path, defaultPack, eventMap, thrown);
        List<TexturePack> selectedPacks = SoundRepository.mc.texturePackList.selectedTexturePacks();
        for (TexturePack p : selectedPacks) {
            this.loadFromPack(path, p, eventMap, thrown);
        }
        File outRoot = new File(SoundRepository.mc.getMinecraftDir(), String.format(ASSET_PACK_FOLDER_SOUNDS_LOCATION_FORMAT, this.namespace));
        outRoot.mkdirs();
        for (Map.Entry e : eventMap.entrySet()) {
            if (this.namespace.equals("minecraft")) {
                SoundRepository.allKeys.add((String)e.getKey());
            } else {
                SoundRepository.allKeys.add(this.namespace + ":" + (String)e.getKey());
            }
            this.register((String)e.getKey(), (SoundEvent)e.getValue());
            for (SoundEntry entry : ((SoundEvent)e.getValue()).getEntryBag().getEntries()) {
                if (entry.type != SoundEntry.Type.FILE || entry.file == null || entry.file.exists()) continue;
                entry.file = new File(outRoot, entry.name);
                try {
                    entry.file.getParentFile().mkdirs();
                    entry.file.createNewFile();
                    InputStream in = entry.pack.getResourceAsStream(String.format(JAR_SOUNDS_LOCATION_FORMAT, this.namespace) + entry.name);
                    if (in == null) {
                        thrown.add(new RuntimeException("Could not find data for entry '" + String.format(JAR_SOUNDS_LOCATION_FORMAT, this.namespace) + entry.name + "'! Unable to copy data!"));
                        continue;
                    }
                    StreamUtils.transferDataAndClose(in, Files.newOutputStream(entry.file.toPath(), new OpenOption[0]));
                }
                catch (Exception ex) {
                    thrown.add(new RuntimeException("Failed to relocate entry '" + entry.name + "' to '" + entry.file + "'!", ex));
                }
            }
            if (((SoundEvent)e.getValue()).subtitleKey == null) continue;
            I18n.getInstance().translateKey(((SoundEvent)e.getValue()).subtitleKey);
        }
        thrown.forEach(Throwable::printStackTrace);
    }

    private void loadFromPack(String path, TexturePack pack, Map<String, SoundEvent> eventMap, List<Throwable> throwableList) {
        JsonObject json;
        if (!pack.hasFile(path)) {
            return;
        }
        try {
            json = this.loadStreamAsElement(pack.getResourceAsStream(path)).getAsJsonObject();
        }
        catch (JsonParseException e) {
            throwableList.add(e);
            return;
        }
        for (Map.Entry<String, JsonElement> e : json.entrySet()) {
            SoundEvent soundEvent;
            String fieldName;
            block21: {
                fieldName = e.getKey();
                JsonObject entryObj = e.getValue().getAsJsonObject();
                boolean replaceEvent = false;
                if (entryObj.has("replace")) {
                    try {
                        replaceEvent = entryObj.get("replace").getAsBoolean();
                    }
                    catch (RuntimeException ex) {
                        throwableList.add(ex);
                    }
                }
                String subtitle = null;
                if (entryObj.has("subtitle")) {
                    try {
                        subtitle = entryObj.get("subtitle").getAsString();
                    }
                    catch (RuntimeException ex) {
                        throwableList.add(ex);
                    }
                }
                if ((soundEvent = eventMap.get(fieldName)) == null || replaceEvent) {
                    soundEvent = new SoundEvent(this, fieldName, subtitle);
                }
                if (subtitle != null) {
                    soundEvent.subtitleKey = subtitle;
                }
                if (entryObj.has("sounds")) {
                    JsonArray sounds;
                    try {
                        sounds = entryObj.getAsJsonArray("sounds");
                    }
                    catch (RuntimeException ex) {
                        throwableList.add(ex);
                        break block21;
                    }
                    for (JsonElement element : sounds) {
                        if (element.isJsonPrimitive()) {
                            try {
                                soundEvent.addSoundEntry(this.getSoundEntry(soundEvent, pack, element.getAsString()));
                            }
                            catch (RuntimeException ex) {
                                throwableList.add(ex);
                            }
                            continue;
                        }
                        if (!element.isJsonObject()) continue;
                        try {
                            soundEvent.addSoundEntry(this.getSoundEntry(soundEvent, pack, element.getAsJsonObject()));
                        }
                        catch (RuntimeException ex) {
                            throwableList.add(ex);
                        }
                    }
                }
            }
            eventMap.put(fieldName, soundEvent);
        }
    }

    public SoundEntry getSoundEntry(SoundEvent event, TexturePack pack, String path) {
        return new SoundEntry(event, pack, path, 1.0f, 1.0f, 1, 16, false, SoundEntry.Type.FILE);
    }

    public SoundEntry getSoundEntry(SoundEvent event, TexturePack pack, JsonObject jObj) throws JsonParseException {
        String name = jObj.get("name").getAsString();
        float volume = 1.0f;
        if (jObj.has("volume")) {
            volume = jObj.get("volume").getAsFloat();
        }
        float pitch = 1.0f;
        if (jObj.has("pitch")) {
            pitch = jObj.get("pitch").getAsFloat();
        }
        int weight = 1;
        if (jObj.has("weight")) {
            weight = jObj.get("weight").getAsInt();
        }
        boolean stream = false;
        if (jObj.has("stream")) {
            stream = jObj.get("stream").getAsBoolean();
        }
        int attenuation_distance = 16;
        if (jObj.has("attenuation_distance")) {
            attenuation_distance = jObj.get("attenuation_distance").getAsInt();
        }
        String type = "file";
        if (jObj.has("type")) {
            type = jObj.get("type").getAsString();
        }
        return new SoundEntry(event, pack, name, volume, pitch, weight, attenuation_distance, stream, SoundEntry.Type.valueOf(type.toUpperCase(Locale.ROOT)));
    }

    private JsonElement loadStreamAsElement(InputStream stream) throws JsonParseException {
        return JsonParser.parseString(StringUtils.readInputString(stream));
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("Sound Repo ").append(this.namespace).append("\n");
        for (SoundEvent e : this) {
            builder.append(e.toString()).append("\n");
        }
        return builder.toString();
    }
}

