/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.data.legacy;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.world.type.WorldType;
import net.minecraft.core.world.type.WorldTypes;

public abstract class LegacyWorldTypes {
    private static final Map<Integer, WorldType> idToWorldTypeMap = new HashMap<Integer, WorldType>();
    private static final Map<WorldType, Integer> worldTypeToIdMap = new HashMap<WorldType, Integer>();
    private static final Map<String, WorldType> keyToWorldTypeMap = new HashMap<String, WorldType>();
    private static final Map<WorldType, String> worldTypeToKeyMap = new HashMap<WorldType, String>();

    private static void register(WorldType worldType, int id, String key) {
        idToWorldTypeMap.put(id, worldType);
        worldTypeToIdMap.put(worldType, id);
        keyToWorldTypeMap.put(key, worldType);
        worldTypeToKeyMap.put(worldType, key);
    }

    public static WorldType getWorldTypeByKey(String key) {
        return keyToWorldTypeMap.get(key);
    }

    public static WorldType getWorldTypeById(int id) {
        return idToWorldTypeMap.get(id);
    }

    public static int getWorldTypeId(WorldType worldType) {
        return worldTypeToIdMap.get(worldType);
    }

    public static String getWorldTypeKey(WorldType worldType) {
        return worldTypeToKeyMap.get(worldType);
    }

    static {
        LegacyWorldTypes.register(WorldTypes.OVERWORLD_DEFAULT, 0, "default");
        LegacyWorldTypes.register(WorldTypes.OVERWORLD_ISLANDS, 1, "islands");
        LegacyWorldTypes.register(WorldTypes.OVERWORLD_WINTER, 2, "winter");
        LegacyWorldTypes.register(WorldTypes.FLAT, 3, "flat");
        LegacyWorldTypes.register(WorldTypes.OVERWORLD_HELL, 4, "hell");
        LegacyWorldTypes.register(WorldTypes.OVERWORLD_WOODS, 5, "woods");
        LegacyWorldTypes.register(WorldTypes.OVERWORLD_PARADISE, 6, "paradise");
        LegacyWorldTypes.register(WorldTypes.OVERWORLD_RETRO, 7, "retro");
        LegacyWorldTypes.register(WorldTypes.OVERWORLD_EXTENDED, 10, "extended");
        LegacyWorldTypes.register(WorldTypes.NETHER_DEFAULT, 11, "nether");
        LegacyWorldTypes.register(WorldTypes.DRIFT_DEFAULT, 12, "drift");
        LegacyWorldTypes.register(WorldTypes.EMPTY, 13, "empty");
        LegacyWorldTypes.register(WorldTypes.DEBUG, 14, "debug");
        LegacyWorldTypes.register(WorldTypes.OVERWORLD_FLOATING, 15, "floating");
        LegacyWorldTypes.register(WorldTypes.OVERWORLD_AMPLIFIED, 16, "amplified");
    }
}

