/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.hud.component;

import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.PlayerLocal;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.hud.HudIngame;
import net.minecraft.client.gui.hud.component.HudComponentMovable;
import net.minecraft.client.gui.hud.component.layout.Layout;
import net.minecraft.client.render.texture.stitcher.TextureRegistry;
import net.minecraft.core.util.helper.Direction;
import org.lwjgl.opengl.GL11;

public class HudComponentRotationLock
extends HudComponentMovable {
    public HudComponentRotationLock(String key, Layout layout) {
        super(key, 24, 16, layout);
    }

    @Override
    public boolean isVisible(Minecraft mc) {
        return mc.thePlayer.rotationLock != null && mc.thePlayer.rotationLock != Direction.NONE && mc.gameSettings.immersiveMode.drawOverlays();
    }

    @Override
    public void render(Minecraft mc, HudIngame hud, int xSizeScreen, int ySizeScreen, float partialTick) {
        GL11.glColor4f(1.0f, 1.0f, 1.0f, 1.0f);
        GL11.glDisable(3042);
        int x = this.getLayout().getComponentX(mc, this, xSizeScreen);
        int y = this.getLayout().getComponentY(mc, this, ySizeScreen);
        String prefix = (Integer)mc.gameSettings.rotationOverlayMode.value % 2 == 1 ? "arrow" : "cube";
        PlayerLocal player = mc.thePlayer;
        boolean facingUp = player.xRot < -45.0f;
        boolean facingDown = player.xRot > 45.0f;
        Direction dir2 = Direction.getDirection(player);
        if (dir2.isHorizontal()) {
            dir2 = dir2.rotate(-Direction.getHorizontalDirection((double)((double)player.yRot)).rotate((int)2).index);
            if (facingUp) {
                if (dir2 == Direction.SOUTH) {
                    dir2 = Direction.UP;
                }
                if (dir2 == Direction.NORTH) {
                    dir2 = Direction.DOWN;
                }
            }
            if (facingDown) {
                if (dir2 == Direction.SOUTH) {
                    dir2 = Direction.DOWN;
                }
                if (dir2 == Direction.NORTH) {
                    dir2 = Direction.UP;
                }
            }
        } else if (dir2 == Direction.UP) {
            dir2 = Direction.DOWN;
            if (facingUp) {
                dir2 = Direction.SOUTH;
            } else if (facingDown) {
                dir2 = Direction.NORTH;
            }
        } else if (dir2 == Direction.DOWN) {
            dir2 = Direction.UP;
            if (facingDown) {
                dir2 = Direction.SOUTH;
            } else if (facingUp) {
                dir2 = Direction.NORTH;
            }
        }
        String[] dirTextures = new String[]{"down", "up", "back", "front", "left", "right"};
        hud.drawGuiIcon(x, y, 16, 16, TextureRegistry.getTexture("minecraft:gui/hud/rotation/" + prefix + "_" + dirTextures[dir2.getId()]));
        dir2 = Direction.getVerticalDirection(player);
        dirTextures = new String[]{"downer", "upper", "back", "front", "left", "right"};
        hud.drawGuiIcon(x + 16, y + 4, 8, 8, TextureRegistry.getTexture("minecraft:gui/hud/rotation/" + prefix + "_" + dirTextures[dir2.getId()]));
    }

    @Override
    public void renderPreview(Minecraft mc, Gui gui, Layout layout, int xSizeScreen, int ySizeScreen) {
        int x = layout.getComponentX(mc, this, xSizeScreen);
        int y = layout.getComponentY(mc, this, ySizeScreen);
        GL11.glColor4f(1.0f, 1.0f, 1.0f, 1.0f);
        GL11.glDisable(3042);
        String prefix = (Integer)mc.gameSettings.rotationOverlayMode.value % 2 == 1 ? "arrow" : "cube";
        gui.drawGuiIcon(x, y, 16, 16, TextureRegistry.getTexture("minecraft:gui/hud/rotation/" + prefix + "_front"));
        gui.drawGuiIcon(x + 16, y + 4, 8, 8, TextureRegistry.getTexture("minecraft:gui/hud/rotation/" + prefix + "_downer"));
    }
}

