/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.keyboard;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.stream.JsonReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Type;
import java.util.ArrayList;
import net.minecraft.client.gui.keyboard.keys.BackspaceKey;
import net.minecraft.client.gui.keyboard.keys.CharKey;
import net.minecraft.client.gui.keyboard.keys.CursorKey;
import net.minecraft.client.gui.keyboard.keys.EnterKey;
import net.minecraft.client.gui.keyboard.keys.GroupKey;
import net.minecraft.client.gui.keyboard.keys.Key;
import net.minecraft.client.gui.keyboard.keys.ModifierKey;
import net.minecraft.core.lang.I18n;

public class KeyboardLayout {
    private static final boolean GENERATE_NEW = false;
    private static final Gson gson = KeyboardLayout.getGson().create();
    public static KeyboardLayout defaultLayout = new KeyboardLayout();
    private Key[] keys;
    private int minX;
    private int maxX;
    private int minY;
    private int maxY;
    private int highestGroup = 0;
    private int width;
    private int height;

    private static GsonBuilder getGson() {
        GsonBuilder builder = new GsonBuilder();
        builder.setPrettyPrinting();
        builder.registerTypeAdapter((Type)((Object)Key.class), new Key.Serializer());
        builder.registerTypeAdapter((Type)((Object)CharKey.class), new CharKey.Serializer());
        builder.registerTypeAdapter((Type)((Object)GroupKey.class), new GroupKey.Serializer());
        builder.registerTypeAdapter((Type)((Object)CursorKey.class), new CursorKey.Serializer());
        builder.registerTypeAdapter((Type)((Object)EnterKey.class), new EnterKey.Serializer());
        builder.registerTypeAdapter((Type)((Object)BackspaceKey.class), new BackspaceKey.Serializer());
        builder.registerTypeAdapter((Type)((Object)ModifierKey.class), new ModifierKey.Serializer());
        return builder;
    }

    public KeyboardLayout() {
        this.loadFromStream(I18n.getResourceAsStream("/lang/en_US/keyboard.json"));
    }

    private void loadFromStream(InputStream stream) {
        this.minX = Integer.MAX_VALUE;
        this.maxX = Integer.MIN_VALUE;
        this.minY = Integer.MAX_VALUE;
        this.maxY = Integer.MIN_VALUE;
        ArrayList<Key> keyList = new ArrayList<Key>();
        JsonObject layoutObject = JsonParser.parseReader(new JsonReader(new InputStreamReader(stream))).getAsJsonObject();
        JsonArray keys = layoutObject.getAsJsonArray("keys");
        for (JsonElement e : keys) {
            keyList.add(gson.fromJson(e, Key.class));
        }
        this.keys = keyList.toArray(new Key[0]);
        for (int i = 0; i < this.keys.length; ++i) {
            Key key = this.keys[i];
            this.minX = Math.min(this.minX, key.getX());
            this.minY = Math.min(this.minY, key.getY());
            this.maxX = Math.max(this.maxX, key.getX() + key.getWidth());
            this.maxY = Math.max(this.maxY, key.getY() + key.getHeight());
            this.highestGroup = Math.max(this.highestGroup, key.highestGroup());
        }
        this.width = this.maxX - this.minX;
        this.height = this.maxY - this.minY;
    }

    public Key[] getKeys() {
        return this.keys;
    }

    public int getMinX() {
        return this.minX;
    }

    public int getMaxX() {
        return this.maxX;
    }

    public int getMinY() {
        return this.minY;
    }

    public int getMaxY() {
        return this.maxY;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public int getHighestGroup() {
        return this.highestGroup;
    }
}

