/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.keyboard;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.gui.ControllerGlyphElement;
import net.minecraft.client.gui.Screen;
import net.minecraft.client.gui.keyboard.KeyboardLayout;
import net.minecraft.client.gui.keyboard.keys.Key;
import net.minecraft.client.gui.text.ITextField;
import net.minecraft.client.gui.text.TextFieldEditor;
import net.minecraft.client.input.controller.ControllerInput;
import net.minecraft.client.render.texture.stitcher.TextureRegistry;
import net.minecraft.core.sound.SoundCategory;
import net.minecraft.core.util.helper.ChatAllowedCharacters;
import net.minecraft.core.util.helper.MathHelper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.input.Keyboard;
import org.lwjgl.opengl.GL11;

public class ScreenKeyboard
extends Screen
implements ITextField {
    private static final int HORIZONTAL_BUFFER = 5;
    @Nullable
    public final Screen parent;
    @Nullable
    public final StringConsumer resultStringAction;
    @Nullable
    public final StringConsumer backspaceAction;
    @Nullable
    public final KeyAction keyAction;
    private final KeyboardLayout keyboardLayout;
    @NotNull
    private String workingString = "";
    @NotNull
    public final TextFieldEditor editor;
    private int cursorCounter = 0;
    private final boolean wasRepeating;
    public final Map<String, Boolean> activeModifiers = new HashMap<String, Boolean>();
    public final Map<String, Boolean> activeLocks = new HashMap<String, Boolean>();
    public ControllerGlyphElement glyphRenderer;
    private int group = 0;

    public ScreenKeyboard(@Nullable Screen parent, @Nullable TextFieldEditor editor, @Nullable StringConsumer enterAction, @Nullable KeyAction keyAction, @Nullable StringConsumer backspaceAction) {
        this.parent = parent;
        this.resultStringAction = enterAction;
        this.backspaceAction = backspaceAction;
        this.keyAction = keyAction;
        this.editor = editor == null ? new TextFieldEditor(this) : editor;
        this.wasRepeating = Keyboard.areRepeatEventsEnabled();
        this.keyboardLayout = KeyboardLayout.defaultLayout;
        Arrays.stream(this.keyboardLayout.getKeys()).forEach(key -> key.onOpen(this.mc, this));
    }

    @Override
    public void opened(int width, int height) {
        Keyboard.enableRepeatEvents(true);
        if (this.parent != null) {
            this.parent.fontRenderer = this.mc.font;
            this.parent.width = width;
            this.parent.height = height;
        }
        this.glyphRenderer = new ControllerGlyphElement(this.mc);
        super.opened(width, height);
    }

    @Override
    public boolean isPauseScreen() {
        if (this.parent != null) {
            return this.parent.isPauseScreen();
        }
        return super.isPauseScreen();
    }

    @Override
    public void tick() {
        ++this.cursorCounter;
        if (this.parent != null) {
            this.parent.tick();
        }
    }

    @Override
    public void keyPressed(char eventCharacter, int eventKey, int mx, int my) {
        if (eventKey == Keyboard.KEY_ESCAPE || eventKey == Keyboard.KEY_RETURN) {
            this.close();
            return;
        }
        this.typeChar(eventKey, eventCharacter);
    }

    public void typeChar(int key, char chr) {
        if (this.editor.handleInput(key, chr)) {
            if (this.keyAction != null) {
                this.keyAction.apply(chr, key, this.editor.getText());
            }
            for (String id : this.activeModifiers.keySet()) {
                if (this.isModifierLocked(id)) continue;
                this.setModifierState(id, false);
            }
        }
    }

    public void backspace() {
        this.editor.deleteCharsBeforeCursor(1);
        if (this.backspaceAction != null) {
            this.backspaceAction.apply(this.editor.getText());
        }
    }

    public void setModifierState(String id, boolean flag) {
        this.activeModifiers.put(id, flag);
        this.activeLocks.putIfAbsent(id, false);
    }

    public void setModifierLock(String id, boolean flag) {
        this.activeModifiers.putIfAbsent(id, false);
        this.activeLocks.put(id, flag);
    }

    public boolean isModifierActive(String id) {
        return this.activeModifiers.getOrDefault(id, false) != false || this.isModifierLocked(id);
    }

    public boolean isModifierLocked(String id) {
        return this.activeLocks.getOrDefault(id, false);
    }

    @Override
    public void removed() {
        if (this.mc.controllerInput != null) {
            this.mc.controllerInput.lockCursor = false;
            this.mc.controllerInput.hideCursor = false;
        }
        if (this.resultStringAction != null) {
            this.resultStringAction.apply(this.editor.getText());
        }
        Keyboard.enableRepeatEvents(this.wasRepeating);
    }

    public void close() {
        this.removed();
        this.mc.currentScreen = this.parent;
    }

    public void setGroup(int group) {
        this.group = group = MathHelper.clamp(group, 0, this.keyboardLayout.getHighestGroup());
    }

    public void shiftGroup(int amount) {
        this.setGroup(this.getShiftedGroup(amount));
    }

    public int getShiftedGroup(int amount) {
        int group = this.group + amount;
        return (group + this.keyboardLayout.getHighestGroup() + 1) % (this.keyboardLayout.getHighestGroup() + 1);
    }

    public int getGroup() {
        return this.group;
    }

    @Override
    public void mouseClicked(int mx, int my, int buttonNum) {
        if (!this.mouseOnKeyboard(mx, my)) {
            this.close();
            return;
        }
        int _x = (this.width - this.keyboardLayout.getWidth()) / 2;
        int _y = this.height - this.keyboardLayout.getHeight() - 5;
        Arrays.stream(this.keyboardLayout.getKeys()).forEach(key -> key.onClick(this.mc, this, _x, _y, mx, my, buttonNum));
    }

    @Override
    public void mouseReleased(int mx, int my, int buttonNum) {
        int _x = (this.width - this.keyboardLayout.getWidth()) / 2;
        int _y = this.height - this.keyboardLayout.getHeight() - 5;
        Arrays.stream(this.keyboardLayout.getKeys()).forEach(key -> key.onRelease(this.mc, this, _x, _y, mx, my, buttonNum));
    }

    public boolean mouseOnKeyboard(int mx, int my) {
        int keyboardWidth = this.keyboardLayout.getWidth();
        int keyboardHeight = this.keyboardLayout.getHeight();
        int _x = (this.width - keyboardWidth) / 2 - 5;
        int _y = this.height - keyboardHeight - 5 - 34;
        return _x <= mx && mx < _x + (keyboardWidth + 10) && _y <= my && my < _y + (keyboardHeight + 34 + 5);
    }

    @Override
    public void render(int mx, int my, float partialTick) {
        boolean drawCursor;
        if (this.parent != null) {
            GL11.glPushMatrix();
            GL11.glTranslatef(0.0f, 0.0f, -100.0f);
            this.parent.render(mx, my, partialTick);
            GL11.glPopMatrix();
        }
        this.drawRect(0, 0, this.width, this.height, -1879048192);
        GL11.glColor4f(1.0f, 1.0f, 1.0f, 1.0f);
        int keyboardWidth = this.keyboardLayout.getWidth();
        int keyboardHeight = this.keyboardLayout.getHeight();
        int _x = (this.width - keyboardWidth) / 2;
        int _y = this.height - keyboardHeight - 5;
        this.drawGuiIcon(_x - 5 - 5, _y - 4 - 30, keyboardWidth + 10 + 10, 36, TextureRegistry.getTexture("minecraft:gui/screen/keyboard/keyboard_background_embedded"));
        this.drawGuiIcon(_x - 5 - 5, _y - 4, keyboardWidth + 10 + 10, keyboardHeight + 8, TextureRegistry.getTexture("minecraft:gui/screen/keyboard/keyboard_background"));
        Arrays.stream(this.keyboardLayout.getKeys()).forEach(key -> key.render(this.mc, this, _x, _y, mx, my));
        this.drawStringCenteredShadow(this.mc.font, this.editor.getText(), _x + keyboardWidth / 2, _y - 20, 0xFFFFFF);
        boolean bl = drawCursor = this.cursorCounter / 6 % 2 == 0;
        if (drawCursor) {
            int width = MathHelper.ceil(this.fontRenderer.stringWidthDouble(this.editor.getText()));
            if (this.editor.getCursor() < this.editor.getText().length()) {
                width = MathHelper.ceil(this.fontRenderer.stringWidthDouble(this.editor.getText().substring(0, this.editor.getCursor())));
            }
            this.drawStringShadow(this.fontRenderer, "_", _x + keyboardWidth / 2 - MathHelper.ceil(this.fontRenderer.stringWidthDouble(this.editor.getText()) / 2.0) + width, _y - 20 + 1, 0xE0E0E0);
        }
    }

    @Override
    public void guiSpecificControllerInput(ControllerInput controller) {
        int keyboardWidth = this.keyboardLayout.getWidth();
        int keyboardHeight = this.keyboardLayout.getHeight();
        int _x = (this.width - keyboardWidth) / 2;
        int _y = this.height - keyboardHeight - 5;
        if (controller.buttonA.pressedThisFrame()) {
            this.mouseClicked((int)controller.cursorX, (int)controller.cursorY, 0);
        }
        if (controller.buttonA.releasedThisFrame()) {
            this.mouseReleased((int)controller.cursorX, (int)controller.cursorY, 0);
        }
        if (!controller.lockCursor) {
            int newX;
            Key newHover;
            int newY;
            int i;
            int y;
            int x;
            int stepSize;
            Key hovered;
            if (controller.digitalPad.up.pressedThisFrame()) {
                hovered = this.getHoveredKey((int)controller.cursorX, (int)controller.cursorY);
                stepSize = 9;
                x = hovered != null ? _x + hovered.getX() + hovered.getWidth() / 2 : MathHelper.clamp((int)controller.cursorX, this.keyboardLayout.getMinX() + _x, this.keyboardLayout.getMaxX() + _x);
                y = hovered != null ? _y + hovered.getY() + hovered.getHeight() / 2 : MathHelper.clamp((int)controller.cursorY, this.keyboardLayout.getMinY() + _y, this.keyboardLayout.getMaxY() + _y);
                for (i = 0; i < keyboardHeight / 9; ++i) {
                    for (newY = y - 9 * i; newY < _y; newY += keyboardHeight) {
                    }
                    while (newY > this.height - 5) {
                        newY -= keyboardHeight;
                    }
                    newHover = this.getHoveredKey(x, newY);
                    if (newHover == null || newHover == hovered) continue;
                    controller.cursorX = (float)(_x + newHover.getX()) + (float)newHover.getWidth() / 2.0f;
                    controller.cursorY = (float)(_y + newHover.getY()) + (float)newHover.getHeight() / 2.0f;
                    break;
                }
            }
            if (controller.digitalPad.down.pressedThisFrame()) {
                hovered = this.getHoveredKey((int)controller.cursorX, (int)controller.cursorY);
                stepSize = 9;
                x = hovered != null ? _x + hovered.getX() + hovered.getWidth() / 2 : MathHelper.clamp((int)controller.cursorX, this.keyboardLayout.getMinX() + _x, this.keyboardLayout.getMaxX() + _x);
                y = hovered != null ? _y + hovered.getY() + hovered.getHeight() / 2 : MathHelper.clamp((int)controller.cursorY, this.keyboardLayout.getMinY() + _y, this.keyboardLayout.getMaxY() + _y);
                for (i = 0; i < keyboardHeight / 9; ++i) {
                    for (newY = y + 9 * i; newY < _y; newY += keyboardHeight) {
                    }
                    while (newY > this.height - 5) {
                        newY -= keyboardHeight;
                    }
                    newHover = this.getHoveredKey(x, newY);
                    if (newHover == null || newHover == hovered) continue;
                    controller.cursorX = (float)(_x + newHover.getX()) + (float)newHover.getWidth() / 2.0f;
                    controller.cursorY = (float)(_y + newHover.getY()) + (float)newHover.getHeight() / 2.0f;
                    break;
                }
            }
            if (controller.digitalPad.left.pressedThisFrame()) {
                hovered = this.getHoveredKey((int)controller.cursorX, (int)controller.cursorY);
                stepSize = 9;
                x = hovered != null ? _x + hovered.getX() + hovered.getWidth() / 2 : MathHelper.clamp((int)controller.cursorX, this.keyboardLayout.getMinX() + _x, this.keyboardLayout.getMaxX() + _x);
                y = hovered != null ? _y + hovered.getY() + hovered.getHeight() / 2 : MathHelper.clamp((int)controller.cursorY, this.keyboardLayout.getMinY() + _y, this.keyboardLayout.getMaxY() + _y);
                for (i = 0; i < keyboardWidth / 9; ++i) {
                    for (newX = x - 9 * i; newX < _x; newX += keyboardWidth) {
                    }
                    while (newX > _x + keyboardWidth) {
                        newX -= keyboardWidth;
                    }
                    newHover = this.getHoveredKey(newX, y);
                    if (newHover == null || newHover == hovered) continue;
                    controller.cursorX = (float)(_x + newHover.getX()) + (float)newHover.getWidth() / 2.0f;
                    controller.cursorY = (float)(_y + newHover.getY()) + (float)newHover.getHeight() / 2.0f;
                    break;
                }
            }
            if (controller.digitalPad.right.pressedThisFrame()) {
                hovered = this.getHoveredKey((int)controller.cursorX, (int)controller.cursorY);
                stepSize = 9;
                x = hovered != null ? _x + hovered.getX() + hovered.getWidth() / 2 : MathHelper.clamp((int)controller.cursorX, this.keyboardLayout.getMinX() + _x, this.keyboardLayout.getMaxX() + _x);
                y = hovered != null ? _y + hovered.getY() + hovered.getHeight() / 2 : MathHelper.clamp((int)controller.cursorY, this.keyboardLayout.getMinY() + _y, this.keyboardLayout.getMaxY() + _y);
                for (i = 0; i < keyboardWidth / 9; ++i) {
                    for (newX = x + 9 * i; newX < _x; newX += keyboardWidth) {
                    }
                    while (newX > _x + keyboardWidth) {
                        newX -= keyboardWidth;
                    }
                    newHover = this.getHoveredKey(newX, y);
                    if (newHover == null || newHover == hovered) continue;
                    controller.cursorX = (float)(_x + newHover.getX()) + (float)newHover.getWidth() / 2.0f;
                    controller.cursorY = (float)(_y + newHover.getY()) + (float)newHover.getHeight() / 2.0f;
                    break;
                }
            }
        }
        Arrays.stream(this.keyboardLayout.getKeys()).forEach(key -> key.onButtonUse(this.mc, this, _x, _y));
    }

    @Override
    public void playControllerButtonSound(ControllerInput controller) {
        if (controller.buttonStart.pressedThisFrame()) {
            this.mc.sndManager.playSound("ui.ui_click", SoundCategory.GUI_SOUNDS, 1.0f, 1.0f);
        }
        if (controller.buttonB.pressedThisFrame()) {
            this.mc.sndManager.playSound("ui.ui_back", SoundCategory.GUI_SOUNDS, 1.0f, 1.0f);
        }
    }

    @Nullable
    public Key getHoveredKey(int mx, int my) {
        int keyboardWidth = this.keyboardLayout.getWidth();
        int keyboardHeight = this.keyboardLayout.getHeight();
        int _x = (this.width - keyboardWidth) / 2;
        int _y = this.height - keyboardHeight - 5;
        for (Key key : this.keyboardLayout.getKeys()) {
            if (!key.isHovered(_x, _y, mx, my)) continue;
            return key;
        }
        return null;
    }

    @Override
    public void setText(String text) {
        this.workingString = text;
    }

    @Override
    public String getText() {
        return this.workingString;
    }

    @Override
    public int maxLength() {
        return Integer.MAX_VALUE;
    }

    @Override
    public boolean isCharacterAllowed(char c) {
        return ChatAllowedCharacters.ALLOWED_CHARACTERS.indexOf(c) >= 0 || Character.isLetterOrDigit(c);
    }

    public static interface StringConsumer {
        public void apply(String var1);
    }

    public static interface KeyAction {
        public void apply(char var1, int var2, String var3);
    }
}

