/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.input.controller;

import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import net.minecraft.client.input.controller.ControllerType;

public abstract class ControllerTypeDatabase {
    private static Int2ObjectMap<ControllerType> controllers = null;

    public static ControllerType getControllerType(int vid, int pid) {
        int combined = (vid & 0xFFFF) << 16 | pid & 0xFFFF;
        if (controllers == null) {
            ControllerTypeDatabase.init();
        }
        return controllers.getOrDefault(combined, ControllerType.UNKNOWN);
    }

    private static void init() {
        controllers = new Int2ObjectArrayMap<ControllerType>();
        try (InputStream stream = ControllerTypeDatabase.class.getResourceAsStream("/controllers.csv");){
            if (stream != null) {
                String line;
                BufferedReader reader = new BufferedReader(new InputStreamReader(stream));
                while ((line = reader.readLine()) != null) {
                    String[] parts;
                    if (line.startsWith("#") || (parts = line.split(",")).length != 3) continue;
                    if (parts[0].startsWith("0x")) {
                        parts[0] = parts[0].substring(2);
                    }
                    if (parts[1].startsWith("0x")) {
                        parts[1] = parts[1].substring(2);
                    }
                    int vid = Integer.parseInt(parts[0], 16);
                    int pid = Integer.parseInt(parts[1], 16);
                    int combined = (vid & 0xFFFF) << 16 | pid & 0xFFFF;
                    controllers.put(combined, ControllerTypeDatabase.getControllerType(parts[2]));
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
    }

    private static ControllerType getControllerType(String id) {
        switch (id) {
            case "PS3Controller": {
                return ControllerType.PS3;
            }
            case "PS4Controller": {
                return ControllerType.PS4;
            }
            case "PS5Controller": {
                return ControllerType.PS5;
            }
            case "XBox360Controller": {
                return ControllerType.XBOX_360;
            }
            case "XBoxOneController": {
                return ControllerType.XBOX_ONE;
            }
            case "XInputController": {
                return ControllerType.XINPUT;
            }
            case "SwitchController": {
                return ControllerType.SWITCH;
            }
            case "SteamController": {
                return ControllerType.STEAM;
            }
            case "SteamDeckController": {
                return ControllerType.STEAM_DECK;
            }
        }
        return ControllerType.UNKNOWN;
    }
}

