/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.block.model;

import net.minecraft.client.render.block.color.BlockColor;
import net.minecraft.client.render.block.color.BlockColorDispatcher;
import net.minecraft.client.render.block.model.BlockModelStandard;
import net.minecraft.client.render.tessellator.Tessellator;
import net.minecraft.client.render.texture.stitcher.IconCoordinate;
import net.minecraft.client.render.texture.stitcher.TextureRegistry;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockLogic;
import net.minecraft.core.block.material.Material;
import net.minecraft.core.util.helper.Axis;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.util.phys.AABB;
import net.minecraft.core.world.WorldSource;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.opengl.GL11;

public class BlockModelGrass<T extends BlockLogic>
extends BlockModelStandard<T> {
    public static boolean fancyGrass = false;
    public static boolean useOverlay = false;
    private static final IconCoordinate[] overlayIndices = new IconCoordinate[]{null, null, TextureRegistry.getTexture("minecraft:block/grass/side_overlay"), TextureRegistry.getTexture("minecraft:block/grass/side_overlay"), TextureRegistry.getTexture("minecraft:block/grass/side_overlay"), TextureRegistry.getTexture("minecraft:block/grass/side_overlay")};
    protected IconCoordinate snowSide = TextureRegistry.getTexture("minecraft:block/grass/snowy_side");

    public BlockModelGrass(Block<T> block) {
        super(block);
    }

    @Override
    public boolean render(@NotNull Tessellator tessellator, @NotNull WorldSource worldSource, int x, int y, int z) {
        boolean didRender;
        AABB bounds = this.block.getBounds();
        boolean bl = didRender = this.isRetro() ? renderBlocks.renderStandardBlock(tessellator, worldSource, this, bounds, x, y, z, 1.0f, 1.0f, 1.0f) : renderBlocks.renderStandardBlock(tessellator, worldSource, this, bounds, x, y, z);
        if (!(!fancyGrass || this.retroBlockTextures.hasTexture() && this.isRetro())) {
            useOverlay = true;
            didRender |= renderBlocks.renderStandardBlock(tessellator, worldSource, this, bounds, x, y, z);
            useOverlay = false;
        }
        return didRender;
    }

    @Override
    public void renderStandalone(@NotNull Tessellator tessellator, int metadata, float brightness, float alpha, @Nullable Integer lightmapCoordinate) {
        GL11.glColor4f(brightness, brightness, brightness, alpha);
        float yOffset = 0.5f;
        AABB bounds = this.getBlockBoundsForItemRender();
        GL11.glTranslatef(-0.5f, 0.0f - yOffset, -0.5f);
        tessellator.startDrawingQuads();
        tessellator.setNormal(0.0f, -1.0f, 0.0f);
        renderBlocks.renderBottomFace(tessellator, bounds, 0.0, 0.0, 0.0, this.getBlockTextureFromSideAndMetadata(Side.BOTTOM, metadata));
        tessellator.draw();
        tessellator.startDrawingQuads();
        tessellator.setNormal(0.0f, 0.0f, -1.0f);
        renderBlocks.renderNorthFace(tessellator, bounds, 0.0, 0.0, 0.0, this.getBlockTextureFromSideAndMetadata(Side.NORTH, metadata));
        tessellator.draw();
        tessellator.startDrawingQuads();
        tessellator.setNormal(0.0f, 0.0f, 1.0f);
        renderBlocks.renderSouthFace(tessellator, bounds, 0.0, 0.0, 0.0, this.getBlockTextureFromSideAndMetadata(Side.SOUTH, metadata));
        tessellator.draw();
        tessellator.startDrawingQuads();
        tessellator.setNormal(-1.0f, 0.0f, 0.0f);
        renderBlocks.renderWestFace(tessellator, bounds, 0.0, 0.0, 0.0, this.getBlockTextureFromSideAndMetadata(Side.WEST, metadata));
        tessellator.draw();
        tessellator.startDrawingQuads();
        tessellator.setNormal(1.0f, 0.0f, 0.0f);
        renderBlocks.renderEastFace(tessellator, bounds, 0.0, 0.0, 0.0, this.getBlockTextureFromSideAndMetadata(Side.EAST, metadata));
        tessellator.draw();
        if (BlockModelGrass.renderBlocks.useInventoryTint && !this.isRetro()) {
            int l = ((BlockColor)BlockColorDispatcher.getInstance().getDispatch(this.block)).getFallbackColor(metadata, 0);
            float f4 = (float)(l >> 16 & 0xFF) / 255.0f;
            float f8 = (float)(l >> 8 & 0xFF) / 255.0f;
            float f9 = (float)(l & 0xFF) / 255.0f;
            GL11.glColor4f(f4 * brightness, f8 * brightness, f9 * brightness, alpha);
        }
        tessellator.startDrawingQuads();
        tessellator.setNormal(0.0f, 1.0f, 0.0f);
        renderBlocks.renderTopFace(tessellator, bounds, 0.0, 0.0, 0.0, this.getBlockTextureFromSideAndMetadata(Side.TOP, metadata));
        tessellator.draw();
        if (fancyGrass && !this.isRetro()) {
            useOverlay = true;
            tessellator.startDrawingQuads();
            tessellator.setNormal(0.0f, 0.0f, -1.0f);
            renderBlocks.renderNorthFace(tessellator, bounds, 0.0, 0.0, 0.0, this.getBlockTextureFromSideAndMetadata(Side.NORTH, metadata));
            tessellator.draw();
            tessellator.startDrawingQuads();
            tessellator.setNormal(0.0f, 0.0f, 1.0f);
            renderBlocks.renderSouthFace(tessellator, bounds, 0.0, 0.0, 0.0, this.getBlockTextureFromSideAndMetadata(Side.SOUTH, metadata));
            tessellator.draw();
            tessellator.startDrawingQuads();
            tessellator.setNormal(-1.0f, 0.0f, 0.0f);
            renderBlocks.renderWestFace(tessellator, bounds, 0.0, 0.0, 0.0, this.getBlockTextureFromSideAndMetadata(Side.WEST, metadata));
            tessellator.draw();
            tessellator.startDrawingQuads();
            tessellator.setNormal(1.0f, 0.0f, 0.0f);
            renderBlocks.renderEastFace(tessellator, bounds, 0.0, 0.0, 0.0, this.getBlockTextureFromSideAndMetadata(Side.EAST, metadata));
            tessellator.draw();
            useOverlay = false;
        }
        GL11.glTranslatef(0.5f, 0.5f, 0.5f);
    }

    @Override
    @Nullable
    public IconCoordinate getBlockTexture(WorldSource blockAccess, int x, int y, int z, Side side) {
        Material material = blockAccess.getBlockMaterial(x, y + 1, z);
        if ((material == Material.topSnow || material == Material.snow) && side.getAxis() != Axis.Y) {
            return this.snowSide;
        }
        return super.getBlockTexture(blockAccess, x, y, z, side);
    }

    @Override
    @Nullable
    public IconCoordinate getBlockTextureFromSideAndMetadata(Side side, int data) {
        if (useOverlay) {
            return overlayIndices[side.getId()];
        }
        return super.getBlockTextureFromSideAndMetadata(side, data);
    }

    @Override
    public boolean shouldSideBeColored(@NotNull WorldSource worldSource, int x, int y, int z, @NotNull Side side, int meta) {
        Material material = worldSource.getBlockMaterial(x, y + 1, z);
        if (material == Material.topSnow || material == Material.snow) {
            return false;
        }
        return useOverlay || side == Side.TOP;
    }
}

