/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.block.model;

import net.minecraft.client.render.block.model.BlockModelStandard;
import net.minecraft.client.render.tessellator.Tessellator;
import net.minecraft.client.render.texture.stitcher.IconCoordinate;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockLogic;
import net.minecraft.core.block.BlockLogicTrapDoor;
import net.minecraft.core.util.helper.Axis;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.util.helper.Sides;
import net.minecraft.core.world.WorldSource;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.opengl.GL11;

public class BlockModelTrapDoor<T extends BlockLogic>
extends BlockModelStandard<T> {
    public BlockModelTrapDoor(Block<T> block) {
        super(block);
        float offset = 0.1875f;
        this.withCustomItemBounds(0.0, 0.0, 0.0, 1.0, offset, 1.0);
    }

    @Override
    public boolean render(@NotNull Tessellator tessellator, @NotNull WorldSource worldSource, int x, int y, int z) {
        int metadata = worldSource.getBlockMetadata(x, y, z);
        boolean isUp = BlockLogicTrapDoor.isTrapdoorOpen(metadata);
        if (isUp) {
            switch (metadata & 3) {
                case 0: {
                    BlockModelTrapDoor.renderBlocks.uvRotateNorth = 2;
                    BlockModelTrapDoor.renderBlocks.uvRotateSouth = 1;
                    break;
                }
                case 1: {
                    BlockModelTrapDoor.renderBlocks.uvRotateTop = 3;
                    BlockModelTrapDoor.renderBlocks.uvRotateBottom = 3;
                    BlockModelTrapDoor.renderBlocks.uvRotateNorth = 1;
                    BlockModelTrapDoor.renderBlocks.uvRotateSouth = 2;
                    break;
                }
                case 2: {
                    BlockModelTrapDoor.renderBlocks.uvRotateTop = 2;
                    BlockModelTrapDoor.renderBlocks.uvRotateBottom = 1;
                    BlockModelTrapDoor.renderBlocks.uvRotateEast = 1;
                    BlockModelTrapDoor.renderBlocks.uvRotateWest = 2;
                    break;
                }
                case 3: {
                    BlockModelTrapDoor.renderBlocks.uvRotateTop = 1;
                    BlockModelTrapDoor.renderBlocks.uvRotateBottom = 2;
                    BlockModelTrapDoor.renderBlocks.uvRotateEast = 2;
                    BlockModelTrapDoor.renderBlocks.uvRotateWest = 1;
                }
            }
        } else if (BlockLogicTrapDoor.isUpperHalf(metadata)) {
            BlockModelTrapDoor.renderBlocks.uvRotateSouth = 3;
            BlockModelTrapDoor.renderBlocks.uvRotateNorth = 3;
            BlockModelTrapDoor.renderBlocks.uvRotateEast = 3;
            BlockModelTrapDoor.renderBlocks.uvRotateWest = 3;
        }
        super.render(tessellator, worldSource, x, y, z);
        renderBlocks.resetRenderBlocks();
        return true;
    }

    @Override
    public void renderStandalone(@NotNull Tessellator tessellator, int metadata, float brightness, float alpha, @Nullable Integer lightmapCoordinate) {
        GL11.glTranslatef(0.0f, 0.25f, 0.0f);
        super.renderStandalone(tessellator, metadata, brightness, alpha, lightmapCoordinate);
    }

    @Override
    @Nullable
    public IconCoordinate getBlockTextureFromSideAndMetadata(Side side, int data) {
        int orientation = data & 3;
        if (BlockLogicTrapDoor.isTrapdoorOpen(data)) {
            int index = Sides.orientationLookUpTrapdoorOpen[6 * orientation + side.getId()];
            return this.blockTextures.get(index);
        }
        if (side.getAxis() == Axis.Y) {
            return this.blockTextures.get(Side.BOTTOM);
        }
        return this.blockTextures.get(Side.SOUTH);
    }
}

