/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.customatlas;

import com.mojang.logging.LogUtils;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import net.minecraft.client.Minecraft;
import net.minecraft.client.render.customatlas.Atlas;
import net.minecraft.client.render.customatlas.AtlasTile;
import net.minecraft.client.render.texturepack.TexturePack;
import net.minecraft.client.render.texturepack.TexturePackCustom;
import net.minecraft.client.render.texturepack.TexturePackList;
import net.minecraft.client.util.helper.Textures;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

public class CustomAtlasHandler {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static Minecraft mc = Minecraft.getMinecraft();
    private static final Map<String, BufferedImage> textureOverrides = new HashMap<String, BufferedImage>();

    public static void beforeRefreshTextures() {
        textureOverrides.clear();
        List<TexturePack> texturePacks = CustomAtlasHandler.mc.texturePackList.selectedPacks;
        ArrayList<String> overrides = new ArrayList<String>();
        CustomAtlasHandler.log("Active Asset Packs: ");
        for (int texturePackIndex = 0; texturePackIndex < texturePacks.size(); ++texturePackIndex) {
            List<String> namespaces;
            Atlas atlas;
            TexturePack texturePack = texturePacks.get(texturePackIndex);
            CustomAtlasHandler.log("  " + texturePack.manifest.getName());
            if (texturePack.hasFile("/terrain.png")) {
                CustomAtlasHandler.log("    has terrain.png");
                atlas = Atlas.read(texturePack.hasFile("/terrain.tiles") ? texturePack.getResourceAsStream("/terrain.tiles") : CustomAtlasHandler.class.getResourceAsStream("/terrain.tiles"));
                CustomAtlasHandler.loadAtlas(texturePack, atlas, "/terrain.png", "/assets/minecraft/textures/block/");
            }
            if (texturePack.hasFile("/gui/items.png")) {
                CustomAtlasHandler.log("    has items.png");
                atlas = Atlas.read(texturePack.hasFile("/items.tiles") ? texturePack.getResourceAsStream("/items.tiles") : CustomAtlasHandler.class.getResourceAsStream("/items.tiles"));
                CustomAtlasHandler.loadAtlas(texturePack, atlas, "/gui/items.png", "/assets/minecraft/textures/item/");
            }
            if ((namespaces = CustomAtlasHandler.findEntries(texturePack, "/assets/", s -> s.endsWith("/"))) != null) {
                for (int namespaceIndex = 0; namespaceIndex < namespaces.size(); ++namespaceIndex) {
                    List<String> customItemAtlases;
                    String namespace = namespaces.get(namespaceIndex);
                    CustomAtlasHandler.log("    namespace: " + namespace);
                    List<String> customBlockAtlases = CustomAtlasHandler.findEntries(texturePack, namespace + "textures/block/", s -> s.endsWith(".tiles"));
                    if (customBlockAtlases != null) {
                        for (int i = 0; i < customBlockAtlases.size(); ++i) {
                            String customAtlasPath = customBlockAtlases.get(i);
                            CustomAtlasHandler.log("      found custom atlas: " + customAtlasPath);
                            CustomAtlasHandler.loadAtlas(texturePack, Atlas.read(texturePack.getResourceAsStream(customAtlasPath)), customAtlasPath.replace(".tiles", ".png"), namespace + "textures/block/");
                        }
                    }
                    if ((customItemAtlases = CustomAtlasHandler.findEntries(texturePack, namespace + "textures/item/", s -> s.endsWith(".tiles"))) == null) continue;
                    for (int i = 0; i < customItemAtlases.size(); ++i) {
                        String customAtlasPath = customItemAtlases.get(i);
                        CustomAtlasHandler.log("      found custom atlas: " + customAtlasPath);
                        CustomAtlasHandler.loadAtlas(texturePack, Atlas.read(texturePack.getResourceAsStream(customAtlasPath)), customAtlasPath.replace(".tiles", ".png"), namespace + "textures/item/");
                    }
                }
            }
            overrides.clear();
            overrides.addAll(textureOverrides.keySet());
            for (int i = 0; i < overrides.size(); ++i) {
                String override = (String)overrides.get(i);
                if (!texturePack.hasFile(override)) continue;
                textureOverrides.remove(override);
            }
        }
    }

    public static void loadAtlas(@NotNull TexturePack texturePack, @NotNull Atlas atlas, @NotNull String atlasTexturePath, @NotNull String pathPrefix) {
        if (atlas.width <= 0 || atlas.height <= 0) {
            throw new IllegalArgumentException("Invalid atlas size: " + atlas.width + "x" + atlas.height);
        }
        BufferedImage image = Textures.readImage(texturePack.getResourceAsStream(atlasTexturePath));
        if (image == null) {
            throw new RuntimeException("Atlas image does not exist: " + atlasTexturePath);
        }
        int tileWidth = image.getWidth() / atlas.width;
        int tileHeight = image.getHeight() / atlas.height;
        List<AtlasTile> atlasTiles = atlas.tileList;
        for (int tileIndex = 0; tileIndex < atlasTiles.size(); ++tileIndex) {
            AtlasTile atlasTile = atlasTiles.get(tileIndex);
            BufferedImage tileImage = image.getSubimage(tileWidth * atlasTile.x, tileHeight * atlasTile.y, tileWidth * atlasTile.sizeX, tileHeight * atlasTile.sizeY);
            String path = pathPrefix + atlasTile.name + ".png";
            textureOverrides.put(path, tileImage);
        }
    }

    public static List<String> findEntries(TexturePack texturePack, String path, Filter filter) {
        if (!path.startsWith("/")) {
            throw new IllegalArgumentException(path);
        }
        if (texturePack instanceof TexturePackCustom) {
            TexturePackCustom texturePackCustom = (TexturePackCustom)texturePack;
            if (texturePackCustom.file.isDirectory()) {
                ArrayList<String> result = new ArrayList<String>();
                File searchDirectory = new File(texturePackCustom.file, path.substring(1));
                File[] files = searchDirectory.listFiles();
                if (files == null) {
                    return null;
                }
                for (int i = 0; i < files.length; ++i) {
                    File file = files[i];
                    String relativePath = files[i].getAbsolutePath().substring(texturePackCustom.file.getAbsolutePath().length());
                    relativePath = relativePath.replace('\\', '/');
                    if (file.isDirectory()) {
                        relativePath = relativePath + "/";
                    }
                    if (filter != null && !filter.accept(relativePath)) continue;
                    result.add(relativePath);
                }
                return result;
            }
            if (texturePackCustom.file.isFile()) {
                path = path.substring(1);
                ArrayList<String> result = new ArrayList<String>();
                ZipFile zipFile = null;
                try {
                    zipFile = new ZipFile(texturePackCustom.file);
                    Enumeration<? extends ZipEntry> entries = zipFile.entries();
                    while (entries.hasMoreElements()) {
                        String entry = entries.nextElement().toString();
                        if (!entry.startsWith(path) || (entry = entry.substring(path.length())).length() == 0 || entry.indexOf(47) != entry.lastIndexOf(47)) continue;
                        entry = "/" + path + entry;
                        if (filter != null && !filter.accept(entry)) continue;
                        result.add(entry);
                    }
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
                finally {
                    try {
                        zipFile.close();
                    }
                    catch (Exception exception) {}
                }
                return result;
            }
        }
        return null;
    }

    public static BufferedImage getTextureOverride(TexturePackList texturePackList, String path) {
        return textureOverrides.get(path);
    }

    public static void log(String str) {
        LOGGER.info(str);
    }

    static interface Filter {
        public boolean accept(String var1);
    }
}

