/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.entity;

import net.minecraft.client.render.entity.MobRenderer;
import net.minecraft.core.entity.monster.MobSlime;
import net.minecraft.core.util.helper.MathHelper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.opengl.GL11;
import org.useless.dragonfly.models.entity.BoneTransform;
import org.useless.dragonfly.models.entity.StaticEntityModel;

public class MobRendererSlime
extends MobRenderer<MobSlime> {
    public MobRendererSlime(float shadowSize) {
        super(shadowSize);
    }

    @Override
    @Nullable
    protected StaticEntityModel getAndSetupModelForLayer(@NotNull MobSlime entity, float brightness, float partialTick, int layer) {
        StaticEntityModel model = this.getModel("main");
        GL11.glEnable(2977);
        GL11.glEnable(3042);
        GL11.glBlendFunc(770, 771);
        model.resetBones();
        int slimeSize = entity.getSlimeSize();
        float squishStrength = MathHelper.lerp(entity.oSquish, entity.squish, partialTick) / ((float)slimeSize * 0.5f + 1.0f);
        float scale = 1.0f / (squishStrength + 1.0f);
        BoneTransform cube = model.getTransform("cube");
        cube.scaleX = scale * (float)slimeSize;
        cube.scaleY = 1.0f / scale * (float)slimeSize;
        cube.scaleZ = scale * (float)slimeSize;
        return model;
    }
}

