/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.item.model;

import net.minecraft.client.entity.player.PlayerRemote;
import net.minecraft.client.render.item.model.ItemModel;
import net.minecraft.client.render.item.model.ItemModelDispatcher;
import net.minecraft.client.render.item.model.ItemModelStandard;
import net.minecraft.client.render.tessellator.Tessellator;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.entity.monster.MobSkeleton;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.item.Item;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.item.Items;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.opengl.GL11;

public class ItemModelBow
extends ItemModelStandard {
    public ItemModelBow(Item item, String namespace) {
        super(item, namespace);
    }

    @Override
    protected void renderSingle(@NotNull Tessellator tessellator, @Nullable Entity holder, @NotNull ItemStack itemStack, boolean items3d, float brightness, float alpha, float partialTick, boolean mirrorX) {
        super.renderSingle(tessellator, holder, itemStack, items3d, brightness, alpha, partialTick, mirrorX);
        Item nextArrow = null;
        if (holder instanceof Player) {
            Player entityplayer = (Player)holder;
            nextArrow = this.getNextArrow(entityplayer);
        } else if (holder instanceof MobSkeleton && ((MobSkeleton)holder).attackTime < 5) {
            nextArrow = Items.AMMO_ARROW;
        }
        if (nextArrow != null) {
            GL11.glPushMatrix();
            if (mirrorX) {
                GL11.glRotatef(-90.0f, 0.0f, 0.0f, 1.0f);
            } else {
                GL11.glRotatef(90.0f, 0.0f, 0.0f, 1.0f);
            }
            GL11.glTranslatef(1.0E-4f, 1.0E-4f, 0.0f);
            GL11.glScalef(1.0f, 1.0f, 0.999f);
            this.renderCoordinate(tessellator, ((ItemModel)ItemModelDispatcher.getInstance().getDispatch(nextArrow)).getIcon(holder, nextArrow.getDefaultStack()), items3d, mirrorX);
            GL11.glPopMatrix();
        }
    }

    public Item getNextArrow(Player player) {
        if (player instanceof PlayerRemote) {
            int id = player.getArrowId();
            if (id < 0 || id >= Item.itemsList.length) {
                return null;
            }
            return Item.itemsList[id];
        }
        return player.getNextArrow();
    }
}

