/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.terrain;

import java.util.HashSet;
import java.util.List;
import net.minecraft.client.render.LightmapHelper;
import net.minecraft.client.render.TileEntityRenderDispatcher;
import net.minecraft.client.render.block.model.BlockModel;
import net.minecraft.client.render.block.model.BlockModelDispatcher;
import net.minecraft.client.render.terrain.ChunkRenderer;
import net.minecraft.client.render.tessellator.Tessellator;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.block.entity.TileEntity;
import net.minecraft.core.world.World;
import net.minecraft.core.world.chunk.Chunk;
import net.minecraft.core.world.chunk.ChunkCache;
import org.lwjgl.opengl.GL11;

public class ChunkRendererLegacy
extends ChunkRenderer {
    public ChunkRendererLegacy(World world, List<TileEntity> globalRenderableTileEntities, int x, int y, int z, int size, int lists) {
        super(world, globalRenderableTileEntities, x, y, z, size, lists);
    }

    @Override
    public void rebuild() {
        if (!this.dirty) {
            return;
        }
        ++updates;
        int minX = this.posX;
        int minY = this.posY;
        int minZ = this.posZ;
        int maxX = this.posX + this.sizeX;
        int maxY = this.posY + this.sizeY;
        int maxZ = this.posZ + this.sizeZ;
        for (int i = 0; i < 2; ++i) {
            this.empty[i] = true;
        }
        Chunk.isLit = false;
        HashSet lastSpecialTileEntities = new HashSet(this.renderableBlockEntities);
        this.renderableBlockEntities.clear();
        boolean cacheRadius = true;
        ChunkCache chunkcache = new ChunkCache(this.world, minX - 1, minY - 1, minZ - 1, maxX + 1, maxY + 1, maxZ + 1);
        Tessellator tessellator = Tessellator.instance;
        for (int renderPass = 0; renderPass < 2; ++renderPass) {
            boolean needsMoreRenderPasses = false;
            boolean hasRenderedBlock = false;
            boolean hasStartedDrawing = false;
            for (int y = minY; y < maxY; ++y) {
                for (int z = minZ; z < maxZ; ++z) {
                    for (int x = minX; x < maxX; ++x) {
                        BlockModel model;
                        int blockRenderPass;
                        TileEntity tileentity;
                        int blockId = chunkcache.getBlockId(x, y, z);
                        if (blockId <= 0) continue;
                        if (!hasStartedDrawing) {
                            hasStartedDrawing = true;
                            GL11.glNewList(this.lists + renderPass, 4864);
                            GL11.glPushMatrix();
                            this.translateToPos();
                            float scale = 1.000001f;
                            GL11.glTranslatef((float)(-this.sizeZ) / 2.0f, (float)(-this.sizeY) / 2.0f, (float)(-this.sizeZ) / 2.0f);
                            GL11.glScalef(1.000001f, 1.000001f, 1.000001f);
                            GL11.glTranslatef((float)this.sizeZ / 2.0f, (float)this.sizeY / 2.0f, (float)this.sizeZ / 2.0f);
                            tessellator.startDrawingQuads();
                            tessellator.setTranslation(-this.posX, -this.posY, -this.posZ);
                            if (LightmapHelper.isLightmapEnabled()) {
                                tessellator.setLightmapCoord(LightmapHelper.getLightmapCoord(15, 15));
                            }
                        }
                        if (renderPass == 0 && Blocks.isEntityTile[blockId] && TileEntityRenderDispatcher.instance.hasRenderer(tileentity = chunkcache.getTileEntity(x, y, z))) {
                            this.renderableBlockEntities.add(tileentity);
                        }
                        if ((blockRenderPass = (model = (BlockModel)BlockModelDispatcher.getInstance().getDispatch(Blocks.blocksList[blockId])).renderLayer()) != renderPass) {
                            needsMoreRenderPasses = true;
                            continue;
                        }
                        if (LightmapHelper.isLightmapEnabled()) {
                            tessellator.setLightmapCoord(LightmapHelper.getLightmapCoord(15, 0));
                        }
                        hasRenderedBlock |= this.renderBlock(tessellator, this.world, model, x, y, z);
                    }
                }
            }
            if (hasStartedDrawing) {
                tessellator.draw();
                GL11.glPopMatrix();
                GL11.glEndList();
                tessellator.setTranslation(0.0, 0.0, 0.0);
            } else {
                hasRenderedBlock = false;
            }
            if (hasRenderedBlock) {
                this.empty[renderPass] = false;
            }
            if (!needsMoreRenderPasses) break;
        }
        HashSet newSpecialTileEntities = new HashSet(this.renderableBlockEntities);
        newSpecialTileEntities.removeAll(lastSpecialTileEntities);
        this.globalRenderableBlockEntities.addAll(newSpecialTileEntities);
        this.renderableBlockEntities.forEach(lastSpecialTileEntities::remove);
        this.globalRenderableBlockEntities.removeAll(lastSpecialTileEntities);
        this.skyLit = Chunk.isLit;
        this.compiled = true;
    }
}

