/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.terrain;

import com.b100.json.element.JsonObject;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.render.terrain.VertexAttribute;
import org.lwjgl.opengl.GL20;

public class VertexConfig {
    public int drawMode;
    public boolean enableColor = false;
    public boolean enableTexture = false;
    public boolean enableNormal = false;
    public boolean enableLightmap = false;
    public final List<VertexAttribute> attributes = new ArrayList<VertexAttribute>();

    public void enableDirect(ByteBuffer buffer) {
        int vertexSize = this.getVertexSize();
        int offset = 0;
        buffer.position(offset);
        GL20.glEnableClientState(32884);
        GL20.glVertexPointer(3, 5126, vertexSize, buffer);
        offset += 12;
        if (this.enableColor) {
            buffer.position(offset);
            GL20.glColorPointer(4, 5121, vertexSize, buffer);
            GL20.glEnableClientState(32886);
            offset += 4;
        } else {
            GL20.glDisableClientState(32886);
        }
        if (this.enableTexture) {
            buffer.position(offset);
            GL20.glTexCoordPointer(2, 5126, vertexSize, buffer);
            GL20.glEnableClientState(32888);
            offset += 8;
        } else {
            GL20.glDisableClientState(32888);
        }
        if (this.enableNormal) {
            buffer.position(offset);
            GL20.glNormalPointer(5120, vertexSize, buffer);
            GL20.glEnableClientState(32885);
            offset += 3;
        } else {
            GL20.glDisableClientState(32885);
        }
        GL20.glClientActiveTexture(33985);
        if (this.enableLightmap) {
            buffer.position(offset);
            GL20.glTexCoordPointer(2, 5122, vertexSize, buffer);
            GL20.glEnableClientState(32888);
            offset += 4;
        } else {
            GL20.glDisableClientState(32888);
        }
        GL20.glClientActiveTexture(33984);
        for (int i = 0; i < this.attributes.size(); ++i) {
            VertexAttribute attrib = this.attributes.get(i);
            buffer.position(offset);
            GL20.glEnableVertexAttribArray(attrib.id);
            GL20.glVertexAttribPointer(attrib.id, attrib.getSize(), attrib.type, false, vertexSize, buffer);
            offset += attrib.getTypeSize();
        }
    }

    public void enableVBO(int vbo) {
        GL20.glBindBuffer(34962, vbo);
        int vertexSize = this.getVertexSize();
        int offset = 0;
        GL20.glEnableClientState(32884);
        GL20.glVertexPointer(3, 5126, vertexSize, offset);
        offset += 12;
        if (this.enableColor) {
            GL20.glColorPointer(4, 5121, vertexSize, offset);
            GL20.glEnableClientState(32886);
            offset += 4;
        } else {
            GL20.glDisableClientState(32886);
        }
        if (this.enableTexture) {
            GL20.glTexCoordPointer(2, 5126, vertexSize, offset);
            GL20.glEnableClientState(32888);
            offset += 8;
        } else {
            GL20.glDisableClientState(32888);
        }
        if (this.enableNormal) {
            GL20.glNormalPointer(5120, vertexSize, offset);
            GL20.glEnableClientState(32885);
            offset += 3;
        } else {
            GL20.glDisableClientState(32885);
        }
        if (this.enableLightmap) {
            GL20.glClientActiveTexture(33985);
            GL20.glTexCoordPointer(2, 5122, vertexSize, offset);
            GL20.glEnableClientState(32888);
            offset += 4;
            GL20.glClientActiveTexture(33984);
        }
        for (int i = 0; i < this.attributes.size(); ++i) {
            VertexAttribute attrib = this.attributes.get(i);
            GL20.glEnableVertexAttribArray(attrib.id);
            GL20.glVertexAttribPointer(attrib.id, attrib.getSize(), attrib.type, false, vertexSize, offset);
            offset += attrib.getTypeSize();
        }
    }

    public void disable() {
        if (this.enableLightmap) {
            GL20.glClientActiveTexture(33985);
            GL20.glDisableClientState(32888);
            GL20.glClientActiveTexture(33984);
        }
        GL20.glBindBuffer(34962, 0);
        for (int i = 0; i < this.attributes.size(); ++i) {
            VertexAttribute attrib = this.attributes.get(i);
            GL20.glDisableVertexAttribArray(attrib.id);
        }
    }

    public int getVertexSize() {
        int size = 12;
        if (this.enableColor) {
            size += 4;
        }
        if (this.enableTexture) {
            size += 8;
        }
        if (this.enableNormal) {
            size += 3;
        }
        if (this.enableLightmap) {
            size += 4;
        }
        for (int i = 0; i < this.attributes.size(); ++i) {
            size += this.attributes.get(i).getTypeSize();
        }
        return size;
    }

    public VertexConfig copy() {
        VertexConfig copy = new VertexConfig();
        copy.drawMode = this.drawMode;
        copy.enableColor = this.enableColor;
        copy.enableTexture = this.enableTexture;
        copy.enableNormal = this.enableNormal;
        copy.enableLightmap = this.enableLightmap;
        copy.attributes.addAll(this.attributes);
        return copy;
    }

    public boolean equals(Object obj) {
        if (obj instanceof VertexConfig) {
            return VertexConfig.compare(this, (VertexConfig)obj) == 0;
        }
        return false;
    }

    public JsonObject toJson() {
        JsonObject object = new JsonObject();
        object.set("drawMode", this.drawMode);
        object.set("enableColor", this.enableColor);
        object.set("enableTexcoord", this.enableTexture);
        object.set("enableNormal", this.enableNormal);
        object.set("enableLightmap", this.enableLightmap);
        if (this.attributes.size() > 0) {
            JsonObject attribsJson = new JsonObject();
            attribsJson.set("size", this.attributes.size());
            for (int i = 0; i < this.attributes.size(); ++i) {
                VertexAttribute attribute = this.attributes.get(i);
                JsonObject attribObject = new JsonObject();
                attribObject.set("id", attribute.id);
                attribObject.set("type", attribute.type);
                attribsJson.set(attribute.name, attribObject);
            }
            object.set("attribs", attribsJson);
        }
        return object;
    }

    public static int compare(VertexConfig c1, VertexConfig c2) {
        if (c1.drawMode != c2.drawMode) {
            return 1;
        }
        if (c1.enableColor != c2.enableColor) {
            return 2;
        }
        if (c1.enableTexture != c2.enableTexture) {
            return 3;
        }
        if (c1.enableNormal != c2.enableNormal) {
            return 4;
        }
        if (c1.enableLightmap != c2.enableLightmap) {
            return 4;
        }
        if (c1.attributes.size() != c2.attributes.size()) {
            return 5;
        }
        for (int i = 0; i < c1.attributes.size(); ++i) {
            VertexAttribute attrib2;
            VertexAttribute attrib1 = c1.attributes.get(i);
            int compare = VertexAttribute.compare(attrib1, attrib2 = c2.attributes.get(i));
            if (compare == 0) continue;
            return (6 + i) * 1000 + compare;
        }
        return 0;
    }

    public static void compareThrow(VertexConfig config1, VertexConfig config2) {
        int compare = VertexConfig.compare(config1, config2);
        if (compare != 0) {
            System.err.println("VertexConfig Mismatch:\n" + config1 + "\n!=\n" + config2);
            throw new RuntimeException("VertexConfig mismatch " + compare + "!");
        }
    }

    public String toString() {
        return this.toJson().toString();
    }
}

