/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.block;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockLogic;
import net.minecraft.core.block.BlockLogicRepeater;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.block.entity.TileEntity;
import net.minecraft.core.block.material.Material;
import net.minecraft.core.current.util.BlockPos;
import net.minecraft.core.current.util.BlockState;
import net.minecraft.core.enums.EnumDropCause;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.item.Items;
import net.minecraft.core.util.helper.Axis;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.util.phys.AABB;
import net.minecraft.core.world.World;
import net.minecraft.core.world.WorldSource;
import net.minecraft.core.world.chunk.ChunkPosition;

public class BlockLogicWireRedstone
extends BlockLogic {
    private boolean shouldSignal = true;
    private final Set<ChunkPosition> toUpdate = new HashSet<ChunkPosition>();

    public BlockLogicWireRedstone(Block<?> block) {
        super(block, Material.decoration);
        this.setBlockBounds(0.0, 0.0, 0.0, 1.0, 0.0625, 1.0);
    }

    @Override
    public AABB getCollisionBoundingBoxFromPool(WorldSource world, int x, int y, int z) {
        return null;
    }

    @Override
    public boolean isSolidRender() {
        return false;
    }

    @Override
    public boolean isCubeShaped() {
        return false;
    }

    @Override
    public boolean canPlaceBlockAt(World world, int x, int y, int z) {
        return world.canPlaceOnSurfaceOfBlock(x, y - 1, z);
    }

    private void updatePowerStrength(World world, int x, int y, int z) {
        this.updatePowerStrength(world, x, y, z, x, y, z);
        ArrayList<ChunkPosition> toUpdate = new ArrayList<ChunkPosition>(this.toUpdate);
        this.toUpdate.clear();
        for (ChunkPosition pos : toUpdate) {
            world.notifyBlocksOfNeighborChange(pos.x, pos.y, pos.z, this.id());
        }
    }

    private void updatePowerStrength(World world, int x0, int y0, int z0, int x1, int y1, int z1) {
        int strength = world.getBlockMetadata(x0, y0, z0);
        int newStrength = 0;
        this.shouldSignal = false;
        boolean hasNeighborSignal = world.hasNeighborSignal(x0, y0, z0);
        this.shouldSignal = true;
        if (hasNeighborSignal) {
            newStrength = 15;
        } else {
            for (int i = 0; i < 4; ++i) {
                int xi = x0;
                int zi = z0;
                if (i == 0) {
                    --xi;
                }
                if (i == 1) {
                    ++xi;
                }
                if (i == 2) {
                    --zi;
                }
                if (i == 3) {
                    ++zi;
                }
                if (xi != x1 || y0 != y1 || zi != z1) {
                    newStrength = this.checkTarget(world, xi, y0, zi, newStrength);
                }
                if (world.isBlockNormalCube(xi, y0, zi) && !world.isBlockNormalCube(x0, y0 + 1, z0)) {
                    if (xi == x1 && y0 + 1 == y1 && zi == z1) continue;
                    newStrength = this.checkTarget(world, xi, y0 + 1, zi, newStrength);
                    continue;
                }
                if (world.isBlockNormalCube(xi, y0, zi) || xi == x1 && y0 - 1 == y1 && zi == z1) continue;
                newStrength = this.checkTarget(world, xi, y0 - 1, zi, newStrength);
            }
            newStrength = newStrength > 0 ? --newStrength : 0;
        }
        if (strength != newStrength) {
            int blockId = world.getBlockId(x0, y0, z0);
            if (blockId == this.id() || blockId == Blocks.FLUID_LAVA_STILL.id() || blockId == Blocks.FLUID_LAVA_FLOWING.id()) {
                world.noNeighborUpdate = true;
                world.setBlockMetadataWithNotify(x0, y0, z0, newStrength);
                world.markBlocksDirty(x0, y0, z0, x0, y0, z0);
                world.noNeighborUpdate = false;
            }
            for (int i = 0; i < 4; ++i) {
                int xi = x0;
                int zi = z0;
                int yi = y0 - 1;
                if (i == 0) {
                    --xi;
                }
                if (i == 1) {
                    ++xi;
                }
                if (i == 2) {
                    --zi;
                }
                if (i == 3) {
                    ++zi;
                }
                if (world.isBlockNormalCube(xi, y0, zi)) {
                    yi += 2;
                }
                int targetStrength = this.checkTarget(world, xi, y0, zi, -1);
                newStrength = world.getBlockMetadata(x0, y0, z0);
                if (newStrength > 0) {
                    --newStrength;
                }
                if (targetStrength >= 0 && targetStrength != newStrength) {
                    this.updatePowerStrength(world, xi, y0, zi, x0, y0, z0);
                }
                targetStrength = this.checkTarget(world, xi, yi, zi, -1);
                newStrength = world.getBlockMetadata(x0, y0, z0);
                if (newStrength > 0) {
                    --newStrength;
                }
                if (targetStrength < 0 || targetStrength == newStrength) continue;
                this.updatePowerStrength(world, xi, yi, zi, x0, y0, z0);
            }
            if (strength == 0 || newStrength == 0) {
                this.toUpdate.add(new ChunkPosition(x0, y0, z0));
                this.toUpdate.add(new ChunkPosition(x0 - 1, y0, z0));
                this.toUpdate.add(new ChunkPosition(x0 + 1, y0, z0));
                this.toUpdate.add(new ChunkPosition(x0, y0 - 1, z0));
                this.toUpdate.add(new ChunkPosition(x0, y0 + 1, z0));
                this.toUpdate.add(new ChunkPosition(x0, y0, z0 - 1));
                this.toUpdate.add(new ChunkPosition(x0, y0, z0 + 1));
            }
        }
    }

    private void checkCornerChangeAt(World world, int x, int y, int z) {
        if (world.getBlockId(x, y, z) == this.id()) {
            world.notifyBlocksOfNeighborChange(x, y, z, this.id());
            world.notifyBlocksOfNeighborChange(x - 1, y, z, this.id());
            world.notifyBlocksOfNeighborChange(x + 1, y, z, this.id());
            world.notifyBlocksOfNeighborChange(x, y, z - 1, this.id());
            world.notifyBlocksOfNeighborChange(x, y, z + 1, this.id());
            world.notifyBlocksOfNeighborChange(x, y - 1, z, this.id());
            world.notifyBlocksOfNeighborChange(x, y + 1, z, this.id());
        }
    }

    @Override
    public void onBlockPlacedByWorld(World world, int x, int y, int z) {
        super.onBlockPlacedByWorld(world, x, y, z);
        if (world.isClientSide) {
            return;
        }
        world.getWireHandler().onWireAdded(new BlockPos(x, y, z));
        world.notifyBlocksOfNeighborChange(x, y + 1, z, this.id());
        world.notifyBlocksOfNeighborChange(x, y - 1, z, this.id());
        this.checkCornerChangeAt(world, x - 1, y, z);
        this.checkCornerChangeAt(world, x + 1, y, z);
        this.checkCornerChangeAt(world, x, y, z - 1);
        this.checkCornerChangeAt(world, x, y, z + 1);
        if (world.isBlockNormalCube(x - 1, y, z)) {
            this.checkCornerChangeAt(world, x - 1, y + 1, z);
        } else {
            this.checkCornerChangeAt(world, x - 1, y - 1, z);
        }
        if (world.isBlockNormalCube(x + 1, y, z)) {
            this.checkCornerChangeAt(world, x + 1, y + 1, z);
        } else {
            this.checkCornerChangeAt(world, x + 1, y - 1, z);
        }
        if (world.isBlockNormalCube(x, y, z - 1)) {
            this.checkCornerChangeAt(world, x, y + 1, z - 1);
        } else {
            this.checkCornerChangeAt(world, x, y - 1, z - 1);
        }
        if (world.isBlockNormalCube(x, y, z + 1)) {
            this.checkCornerChangeAt(world, x, y + 1, z + 1);
        } else {
            this.checkCornerChangeAt(world, x, y - 1, z + 1);
        }
    }

    @Override
    public void onBlockRemoved(World world, int x, int y, int z, int data) {
        super.onBlockRemoved(world, x, y, z, data);
        if (world.isClientSide) {
            return;
        }
        world.notifyBlocksOfNeighborChange(x, y + 1, z, this.id());
        world.notifyBlocksOfNeighborChange(x, y - 1, z, this.id());
        world.getWireHandler().onWireRemoved(new BlockPos(x, y, z), new BlockState(this.id(), world.getBlockMetadata(x, y, z)));
        this.checkCornerChangeAt(world, x - 1, y, z);
        this.checkCornerChangeAt(world, x + 1, y, z);
        this.checkCornerChangeAt(world, x, y, z - 1);
        this.checkCornerChangeAt(world, x, y, z + 1);
        if (world.isBlockNormalCube(x - 1, y, z)) {
            this.checkCornerChangeAt(world, x - 1, y + 1, z);
        } else {
            this.checkCornerChangeAt(world, x - 1, y - 1, z);
        }
        if (world.isBlockNormalCube(x + 1, y, z)) {
            this.checkCornerChangeAt(world, x + 1, y + 1, z);
        } else {
            this.checkCornerChangeAt(world, x + 1, y - 1, z);
        }
        if (world.isBlockNormalCube(x, y, z - 1)) {
            this.checkCornerChangeAt(world, x, y + 1, z - 1);
        } else {
            this.checkCornerChangeAt(world, x, y - 1, z - 1);
        }
        if (world.isBlockNormalCube(x, y, z + 1)) {
            this.checkCornerChangeAt(world, x, y + 1, z + 1);
        } else {
            this.checkCornerChangeAt(world, x, y - 1, z + 1);
        }
    }

    private int checkTarget(World world, int x, int y, int z, int sourceStrength) {
        if (world.getBlockId(x, y, z) != this.id()) {
            return sourceStrength;
        }
        int targetStrength = world.getBlockMetadata(x, y, z);
        return Math.max(targetStrength, sourceStrength);
    }

    @Override
    public void onNeighborBlockChange(World world, int x, int y, int z, int blockId) {
        if (world.isClientSide || world.getWireHandler().onWireUpdated(new BlockPos(x, y, z))) {
            return;
        }
        int strength = world.getBlockMetadata(x, y, z);
        boolean canPlaceBlockAt = this.canPlaceBlockAt(world, x, y, z);
        if (!canPlaceBlockAt) {
            this.dropBlockWithCause(world, EnumDropCause.WORLD, x, y, z, strength, null, null);
            world.setBlockWithNotify(x, y, z, 0);
        } else {
            this.updatePowerStrength(world, x, y, z);
        }
        super.onNeighborBlockChange(world, x, y, z, blockId);
    }

    @Override
    public ItemStack[] getBreakResult(World world, EnumDropCause dropCause, int meta, TileEntity tileEntity) {
        return new ItemStack[]{new ItemStack(Items.DUST_REDSTONE)};
    }

    @Override
    public boolean getDirectSignal(World world, int x, int y, int z, Side side) {
        if (!this.shouldSignal) {
            return false;
        }
        return this.getSignal(world, x, y, z, side);
    }

    @Override
    public boolean getSignal(WorldSource worldSource, int x, int y, int z, Side side) {
        int newDirectionEast;
        int newDirectionWest;
        int newDirectionSouth;
        int newDirectionNorth;
        int newDirection;
        World world;
        int meta;
        int direction;
        boolean posZShouldConnectTo;
        if (!this.shouldSignal) {
            return false;
        }
        if (worldSource.getBlockMetadata(x, y, z) == 0) {
            return false;
        }
        if (side == Side.TOP) {
            return true;
        }
        boolean negXShouldConnectTo = BlockLogicWireRedstone.shouldConnectTo(worldSource, x - 1, y, z, Side.WEST) || !worldSource.isBlockNormalCube(x - 1, y, z) && BlockLogicWireRedstone.shouldConnectToDiagonal(worldSource, x - 1, y - 1, z, Side.NONE, Side.BOTTOM);
        boolean posXShouldConnectTo = BlockLogicWireRedstone.shouldConnectTo(worldSource, x + 1, y, z, Side.EAST) || !worldSource.isBlockNormalCube(x + 1, y, z) && BlockLogicWireRedstone.shouldConnectToDiagonal(worldSource, x + 1, y - 1, z, Side.NONE, Side.BOTTOM);
        boolean negZShouldConnectTo = BlockLogicWireRedstone.shouldConnectTo(worldSource, x, y, z - 1, Side.NORTH) || !worldSource.isBlockNormalCube(x, y, z - 1) && BlockLogicWireRedstone.shouldConnectToDiagonal(worldSource, x, y - 1, z - 1, Side.NONE, Side.BOTTOM);
        boolean bl = posZShouldConnectTo = BlockLogicWireRedstone.shouldConnectTo(worldSource, x, y, z + 1, Side.SOUTH) || !worldSource.isBlockNormalCube(x, y, z + 1) && BlockLogicWireRedstone.shouldConnectToDiagonal(worldSource, x, y - 1, z + 1, Side.NONE, Side.BOTTOM);
        if (!worldSource.isBlockNormalCube(x, y + 1, z)) {
            if (worldSource.isBlockNormalCube(x - 1, y, z) && BlockLogicWireRedstone.shouldConnectToDiagonal(worldSource, x - 1, y + 1, z, Side.NONE, Side.TOP)) {
                negXShouldConnectTo = true;
            }
            if (worldSource.isBlockNormalCube(x + 1, y, z) && BlockLogicWireRedstone.shouldConnectToDiagonal(worldSource, x + 1, y + 1, z, Side.NONE, Side.TOP)) {
                posXShouldConnectTo = true;
            }
            if (worldSource.isBlockNormalCube(x, y, z - 1) && BlockLogicWireRedstone.shouldConnectToDiagonal(worldSource, x, y + 1, z - 1, Side.NONE, Side.TOP)) {
                negZShouldConnectTo = true;
            }
            if (worldSource.isBlockNormalCube(x, y, z + 1) && BlockLogicWireRedstone.shouldConnectToDiagonal(worldSource, x, y + 1, z + 1, Side.NONE, Side.TOP)) {
                posZShouldConnectTo = true;
            }
        }
        if (worldSource instanceof World && (direction = ((meta = (world = (World)worldSource).getBlockMetadata(x, y, z)) & 0xF0) >> 4) != (newDirection = (newDirectionNorth = negZShouldConnectTo ? 1 : 0) | (newDirectionSouth = (posZShouldConnectTo ? 1 : 0) << 1) | (newDirectionWest = (negXShouldConnectTo ? 1 : 0) << 2) | (newDirectionEast = (posXShouldConnectTo ? 1 : 0) << 3))) {
            meta &= 0xFFFFFF0F;
            world.setBlockMetadata(x, y, z, meta |= (newDirection <<= 4));
        }
        boolean isXConnected = posXShouldConnectTo || negXShouldConnectTo;
        boolean isZConnected = posZShouldConnectTo || negZShouldConnectTo;
        return !isZConnected && !isXConnected && side.getAxis() != Axis.Y || side == Side.SOUTH && negZShouldConnectTo || side == Side.NORTH && posZShouldConnectTo || side == Side.EAST && negXShouldConnectTo || side == Side.WEST && posXShouldConnectTo || side == Side.NORTH && negZShouldConnectTo && !isXConnected || side == Side.SOUTH && posZShouldConnectTo && !isXConnected || side == Side.WEST && negXShouldConnectTo && !isZConnected || side == Side.EAST && posXShouldConnectTo && !isZConnected;
    }

    @Override
    public boolean isSignalSource() {
        return this.shouldSignal;
    }

    @Override
    public void animationTick(World world, int x, int y, int z, Random rand) {
        int meta = world.getBlockMetadata(x, y, z);
        if (meta == 0) {
            return;
        }
        double px = (double)x + 0.5 + ((double)rand.nextFloat() - 0.5) * 0.2;
        double py = (double)y + 0.0625;
        double pz = (double)z + 0.5 + ((double)rand.nextFloat() - 0.5) * 0.2;
        int redstoneBrightness = meta & 0xF;
        world.spawnParticle("reddust", px, py, pz, 0.0, 0.0, 0.0, redstoneBrightness);
    }

    public static boolean shouldConnectTo(WorldSource worldSource, int x, int y, int z, Side side) {
        Block<?> block = worldSource.getBlock(x, y, z);
        if (block == null) {
            return false;
        }
        if (block == Blocks.WIRE_REDSTONE) {
            return true;
        }
        if (block == Blocks.PUMPKIN_REDSTONE) {
            if (side == Side.NONE || side.isVertical()) {
                return false;
            }
            return Side.getSideById(worldSource.getBlockMetadata(x, y, z)).getOpposite() == side;
        }
        if (block == Blocks.REPEATER_IDLE || block == Blocks.REPEATER_ACTIVE) {
            Side direction = BlockLogicRepeater.getSideFromMeta(worldSource.getBlockMetadata(x, y, z));
            return side == direction || side == direction.getOpposite();
        }
        return block.isSignalSource();
    }

    public static boolean shouldConnectToDiagonal(WorldSource worldSource, int x, int y, int z, Side side1, Side side2) {
        if (side2 != Side.TOP && side2 != Side.BOTTOM) {
            return false;
        }
        int blockId = worldSource.getBlockId(x, y, z);
        return blockId == Blocks.WIRE_REDSTONE.id();
    }
}

