#version 120

#define FOG
#define RADIAL_FOG

uniform sampler2D texture;

uniform int isEyeInLiquid;

#ifdef RADIAL_FOG
uniform mat4 gbufferProjectionInverse;
uniform float viewWidth;
uniform float viewHeight;
#endif

varying vec2 texcoord;
varying vec4 color;

void main() {
	vec4 tex = texture2D(texture, texcoord);
	
	// Alpha test
	if(tex.a < 0.1f) {
		discard;
	}
	
	// Hide clouds when in water or lava
	if(isEyeInLiquid != 0) {
		discard;
	}
	
	vec4 col = color;
	
	#ifdef FOG
	float fogStrength = 0.0f;
	
	#ifndef RADIAL_FOG
	fogStrength = (gl_FogFragCoord - gl_Fog.start) * gl_Fog.scale;
	#endif
	
	#ifdef RADIAL_FOG
	vec4 fragPos = gbufferProjectionInverse * vec4((gl_FragCoord.xy / vec2(viewWidth, viewHeight)) * 2.0f - 1.0f, gl_FragCoord.z * 2.0f - 1.0f, 1.0f);
	fragPos /= fragPos.w;
	
	float dist = length(fragPos.xyz);
	float end = gl_Fog.end;
	float start = gl_Fog.start / gl_Fog.end;
	
	fogStrength = dist / end;
	fogStrength -= (start);
	fogStrength /= (1.0f - start);
	fogStrength = clamp(fogStrength, 0.0f, 1.0f);
	#endif
	col.a *= 1.0f - fogStrength;
	#endif
	
	gl_FragData[0] = tex * col;
}