/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.block.model;

import net.minecraft.client.render.LightmapHelper;
import net.minecraft.client.render.block.model.BlockModelStandard;
import net.minecraft.client.render.tessellator.Tessellator;
import net.minecraft.client.render.texture.stitcher.IconCoordinate;
import net.minecraft.client.render.texture.stitcher.TextureRegistry;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockLogic;
import net.minecraft.core.util.helper.MathHelper;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.world.WorldSource;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BlockModelPebbles<T extends BlockLogic>
extends BlockModelStandard<T> {
    protected IconCoordinate[] pebbles = new IconCoordinate[]{TextureRegistry.getTexture("minecraft:block/pebbles/0"), TextureRegistry.getTexture("minecraft:block/pebbles/1"), TextureRegistry.getTexture("minecraft:block/pebbles/2")};

    public BlockModelPebbles(Block<T> block) {
        super(block);
    }

    @Override
    public boolean render(@NotNull Tessellator tessellator, @NotNull WorldSource worldSource, int x, int y, int z) {
        float brightness = 1.0f;
        if (LightmapHelper.isLightmapEnabled()) {
            tessellator.setLightmapCoord(LightmapHelper.max(this.block.getLightmapCoord(worldSource, x, y, z), this.block.getLightmapCoord(worldSource, x, y - 1, z)));
        } else {
            brightness = Math.max(renderBlocks.getBlockBrightness(worldSource, x, y, z), renderBlocks.getBlockBrightness(worldSource, x, y - 1, z));
        }
        tessellator.setColorOpaque_F(brightness, brightness, brightness);
        renderBlocks.renderTopFace(tessellator, this.block.getBlockBoundsFromState(worldSource, x, y, z), x, y, z, this.getBlockTextureFromSideAndMetadata(Side.TOP, worldSource.getBlockMetadata(x, y, z)));
        return true;
    }

    @Override
    public boolean shouldItemRender3d() {
        return false;
    }

    @Override
    @Nullable
    public IconCoordinate getBlockTextureFromSideAndMetadata(Side side, int data) {
        return this.pebbles[MathHelper.clamp(data, 0, 2)];
    }
}

