/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.net;

import com.mojang.logging.LogUtils;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Properties;
import org.slf4j.Logger;

public class PropertyManager {
    public static Logger logger = LogUtils.getLogger();
    private Properties serverProperties = new Properties();
    private File serverPropertiesFile;

    public PropertyManager(File file) {
        this.serverPropertiesFile = file;
        if (file.exists()) {
            try {
                this.serverProperties.load(Files.newInputStream(file.toPath(), new OpenOption[0]));
            }
            catch (Exception exception) {
                logger.warn("Failed to load " + file, exception);
                this.generateNewProperties();
            }
        } else {
            logger.warn(file + " does not exist");
            this.generateNewProperties();
        }
    }

    public void generateNewProperties() {
        logger.info("Generating new properties file");
        this.saveProperties();
    }

    public void saveProperties() {
        try {
            this.serverProperties.store(Files.newOutputStream(this.serverPropertiesFile.toPath(), new OpenOption[0]), "Minecraft server properties");
        }
        catch (Exception exception) {
            logger.warn("Failed to save " + this.serverPropertiesFile, exception);
            this.generateNewProperties();
        }
    }

    public String getStringProperty(String s, String s1) {
        if (!this.serverProperties.containsKey(s)) {
            this.serverProperties.setProperty(s, s1);
            this.saveProperties();
        }
        return this.serverProperties.getProperty(s, s1);
    }

    public int getIntProperty(String s, int i) {
        try {
            return Integer.parseInt(this.getStringProperty(s, "" + i));
        }
        catch (Exception exception) {
            this.serverProperties.setProperty(s, "" + i);
            return i;
        }
    }

    public boolean getBooleanProperty(String s, boolean flag) {
        try {
            return Boolean.parseBoolean(this.getStringProperty(s, "" + flag));
        }
        catch (Exception exception) {
            this.serverProperties.setProperty(s, "" + flag);
            return flag;
        }
    }

    public void setProperty(String s, boolean flag) {
        this.serverProperties.setProperty(s, "" + flag);
        this.saveProperties();
    }

    public void setProperty(String s, int value) {
        this.serverProperties.setProperty(s, "" + value);
    }

    public void setProperty(String s1, String s2) {
        this.serverProperties.setProperty(s1, s2);
    }
}

