/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.console.shell.commands;

import bsh.CallStack;
import bsh.Interpreter;
import com.mojang.logging.CategorizedLogger;
import com.mojang.logging.LogUtils;
import java.io.File;
import java.net.URI;
import java.net.URL;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.stream.Stream;
import net.minecraft.client.Minecraft;
import net.minecraft.client.render.texturepack.TexturePack;

public class reloadScripts {
    private static final CategorizedLogger LOGGER = LogUtils.getLogger();

    public static void invoke(Interpreter env, CallStack callstack) {
        try {
            String[] internalFiles;
            LOGGER.warn("Clearing current state...");
            env.eval("clear()");
            LOGGER.warn("Loading internal commands...");
            env.eval("importCommands(\"net.minecraft.client.console.shell.commands\")");
            env.eval("importCommands(\"scripts.beanshell.commands\")");
            LOGGER.warn("Loading external commands...");
            File[] externalCommands = new File(Minecraft.getMinecraft().getMinecraftDir(), "/scripts/beanshell/commands").listFiles();
            if (externalCommands != null) {
                for (File file : externalCommands) {
                    if (!file.getAbsolutePath().endsWith(".bsh")) continue;
                    env.eval(("source(\"" + file.getAbsolutePath() + "\")").replace("\\", "/"));
                }
            }
            LOGGER.warn("Loading internal scripts...");
            for (String file : internalFiles = reloadScripts.getFilesInDirectory("/scripts/beanshell/")) {
                if (!file.endsWith(".bsh")) continue;
                env.eval("source(\"" + file.replace("/", ".") + "\")");
            }
            LOGGER.warn("Loading external scripts...");
            File[] externalFiles = new File(Minecraft.getMinecraft().getMinecraftDir(), "/scripts/beanshell/").listFiles();
            if (externalFiles != null) {
                for (File file : externalFiles) {
                    if (!file.getAbsolutePath().endsWith(".bsh")) continue;
                    env.eval(("source(\"" + file.getAbsolutePath() + "\")").replace("\\", "/"));
                }
            }
            LOGGER.info("Loaded commands and scripts.");
        }
        catch (Exception e) {
            LOGGER.error("Caught exception:", e);
            LOGGER.error("Could not reload scripts!");
        }
    }

    private static String[] getFilesInDirectory(String directory) {
        ArrayList<String> paths;
        block15: {
            paths = new ArrayList<String>();
            if (!directory.endsWith("/")) {
                directory = directory + "/";
            }
            try {
                Path myPath;
                URL url = TexturePack.class.getResource(directory);
                if (url == null) break block15;
                URI uri = url.toURI();
                FileSystem fileSystem = null;
                if (uri.getScheme().equals("jar")) {
                    try {
                        fileSystem = FileSystems.getFileSystem(uri);
                    }
                    catch (Exception e) {
                        fileSystem = FileSystems.newFileSystem(uri, Collections.emptyMap());
                    }
                    myPath = fileSystem.getPath(directory, new String[0]);
                } else {
                    myPath = Paths.get(uri);
                }
                try (Stream<Path> walk = Files.walk(myPath, 1, new FileVisitOption[0]);){
                    Iterator it = walk.iterator();
                    it.next();
                    while (it.hasNext()) {
                        paths.add(directory + ((Path)it.next()).getFileName().toString());
                    }
                }
                if (fileSystem != null) {
                    fileSystem.close();
                }
            }
            catch (Exception e) {
                LOGGER.error("Exception while loading all files in directory '{}'!", directory, (Throwable)e);
            }
        }
        return paths.toArray(new String[0]);
    }
}

