/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.sound;

import com.mojang.logging.LogUtils;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import paulscode.sound.codecs.CodecJOrbis;

public class CodecMus
extends CodecJOrbis {
    private static final Logger LOGGER = LogUtils.getLogger();

    protected InputStream openInputStream() {
        try {
            return new DecoderInputStream(this.url, this.urlConnection.getInputStream());
        }
        catch (IOException e) {
            LOGGER.error("Exception decoding stream '{}'!", (Object)this.url.getPath(), (Object)e);
            return null;
        }
    }

    private static class DecoderInputStream
    extends InputStream {
        private int hash;
        private final InputStream inputStream;
        byte[] buffer = new byte[1];

        public DecoderInputStream(URL url, InputStream inputstream) {
            this.inputStream = inputstream;
            String s = url.getPath();
            s = s.substring(s.lastIndexOf("/") + 1);
            this.hash = s.hashCode();
        }

        @Override
        public int read() {
            int i = this.read(this.buffer, 0, 1);
            if (i < 0) {
                return i;
            }
            return this.buffer[0];
        }

        @Override
        public int read(byte @NotNull [] b, int i, int j) {
            try {
                j = this.inputStream.read(b, i, j);
            }
            catch (IOException e) {
                LOGGER.error("CodecMus data read error!", e);
                return 0;
            }
            for (int k = 0; k < j; ++k) {
                int n = i + k;
                byte by = (byte)(b[n] ^ this.hash >> 8);
                b[n] = by;
                byte byte0 = by;
                this.hash = this.hash * 498729871 + 85731 * byte0;
            }
            return j;
        }
    }
}

