/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.block;

import java.util.Random;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockLogicVeryRotatable;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.block.entity.TileEntity;
import net.minecraft.core.block.material.Material;
import net.minecraft.core.entity.Mob;
import net.minecraft.core.enums.EnumDropCause;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.util.helper.Direction;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.world.World;
import net.minecraft.core.world.WorldSource;
import org.jetbrains.annotations.NotNull;

public class BlockLogicComparer
extends BlockLogicVeryRotatable {
    public final boolean isActive;

    public BlockLogicComparer(Block<?> block, boolean isActive) {
        super(block, Material.stone);
        this.isActive = isActive;
    }

    @Override
    public int tickDelay() {
        return 4;
    }

    @Override
    public void updateTick(World world, int x, int y, int z, Random rand) {
        this.updateState(world, x, y, z);
    }

    @Override
    public void onBlockPlacedByMob(World world, int x, int y, int z, @NotNull Side side, Mob mob, double xPlaced, double yPlaced) {
        super.onBlockPlacedByMob(world, x, y, z, side, mob, xPlaced, yPlaced);
        world.scheduleBlockUpdate(x, y, z, this.id(), this.tickDelay());
    }

    @Override
    public void onBlockPlacedByWorld(World world, int x, int y, int z) {
        super.onBlockPlacedByWorld(world, x, y, z);
        world.scheduleBlockUpdate(x, y, z, this.id(), this.tickDelay());
    }

    @Override
    public void onBlockPlacedOnSide(World world, int x, int y, int z, @NotNull Side side, double xPlaced, double yPlaced) {
        super.onBlockPlacedOnSide(world, x, y, z, side, xPlaced, yPlaced);
        world.scheduleBlockUpdate(x, y, z, this.id(), this.tickDelay());
    }

    @Override
    public void onNeighborBlockChange(World world, int x, int y, int z, int blockId) {
        world.scheduleBlockUpdate(x, y, z, this.id(), this.tickDelay());
    }

    public void updateState(World world, int x, int y, int z) {
        boolean backMatchesFront;
        Direction dir2 = BlockLogicVeryRotatable.metaToDirection(world.getBlockMetadata(x, y, z) & 7);
        int fx = x + dir2.getOffsetX();
        int fy = y + dir2.getOffsetY();
        int fz = z + dir2.getOffsetZ();
        int bx = x + dir2.getOpposite().getOffsetX();
        int by = y + dir2.getOpposite().getOffsetY();
        int bz = z + dir2.getOpposite().getOffsetZ();
        Block<?> fBlock = world.getBlock(fx, fy, fz);
        Block<?> bBlock = world.getBlock(bx, by, bz);
        int fMeta = world.getBlockMetadata(fx, fy, fz);
        int bMeta = world.getBlockMetadata(bx, by, bz);
        boolean bl = backMatchesFront = fBlock == bBlock && fMeta == bMeta;
        if (!this.isActive && backMatchesFront) {
            world.setBlockAndMetadataWithNotify(x, y, z, Blocks.COMPARER_ACTIVE.id(), world.getBlockMetadata(x, y, z));
        } else if (this.isActive && !backMatchesFront) {
            world.setBlockAndMetadataWithNotify(x, y, z, Blocks.COMPARER.id(), world.getBlockMetadata(x, y, z));
        }
    }

    @Override
    public void animationTick(World world, int x, int y, int z, Random rand) {
        if (!this.isActive) {
            return;
        }
        Random random = world.rand;
        int redstoneBrightness = 10;
        double d = 0.0625;
        for (int i = 0; i < 6; ++i) {
            double px = (double)x + (double)random.nextFloat();
            double py = (double)y + (double)random.nextFloat();
            double pz = (double)z + (double)random.nextFloat();
            if (i == 0 && !world.isBlockOpaqueCube(x, y + 1, z)) {
                py = (double)(y + 1) + d;
            }
            if (i == 1 && !world.isBlockOpaqueCube(x, y - 1, z)) {
                py = (double)(y + 0) - d;
            }
            if (i == 2 && !world.isBlockOpaqueCube(x, y, z + 1)) {
                pz = (double)(z + 1) + d;
            }
            if (i == 3 && !world.isBlockOpaqueCube(x, y, z - 1)) {
                pz = (double)(z + 0) - d;
            }
            if (i == 4 && !world.isBlockOpaqueCube(x + 1, y, z)) {
                px = (double)(x + 1) + d;
            }
            if (i == 5 && !world.isBlockOpaqueCube(x - 1, y, z)) {
                px = (double)(x + 0) - d;
            }
            if (!(px < (double)x || px > (double)(x + 1) || py < 0.0 || py > (double)(y + 1) || pz < (double)z) && !(pz > (double)(z + 1))) continue;
            world.spawnParticle("reddust", px, py, pz, 0.0, 0.0, 0.0, 10);
        }
    }

    @Override
    public boolean isSignalSource() {
        return true;
    }

    @Override
    public boolean getDirectSignal(World world, int x, int y, int z, Side side) {
        return false;
    }

    @Override
    public boolean getSignal(WorldSource worldSource, int x, int y, int z, Side side) {
        return this.isActive && BlockLogicVeryRotatable.metaToDirection(worldSource.getBlockMetadata(x, y, z)).getAxis() != side.getAxis();
    }

    @Override
    public ItemStack[] getBreakResult(World world, EnumDropCause dropCause, int meta, TileEntity tileEntity) {
        if (dropCause == EnumDropCause.IMPROPER_TOOL) {
            return null;
        }
        return new ItemStack[]{new ItemStack(Blocks.COMPARER)};
    }
}

