/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.block.model;

import java.util.Random;
import net.minecraft.client.render.block.model.BlockModelVeryRotatable;
import net.minecraft.client.render.texture.stitcher.IconCoordinate;
import net.minecraft.client.render.texture.stitcher.TextureRegistry;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockLogic;
import net.minecraft.core.util.helper.Axis;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.world.WorldSource;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BlockModelComparer<T extends BlockLogic>
extends BlockModelVeryRotatable<T> {
    public IconCoordinate[] frontVariants;
    public IconCoordinate[] frontOverlayVariants;
    public final Random random = new Random();

    public BlockModelComparer(Block<T> block, boolean isPowered) {
        super(block);
        this.frontVariants = new IconCoordinate[4];
        this.frontOverlayVariants = new IconCoordinate[this.frontVariants.length];
        for (int i = 0; i < this.frontVariants.length; ++i) {
            this.frontVariants[i] = TextureRegistry.getTexture("minecraft:block/comparer/front" + (isPowered ? "_active" : "") + i);
            this.frontOverlayVariants[i] = TextureRegistry.getTexture("minecraft:block/comparer/front" + (isPowered ? "_active" : "") + "_overlay" + i);
        }
    }

    @Override
    @Nullable
    public IconCoordinate getBlockTexture(WorldSource blockAccess, int x, int y, int z, Side side) {
        Side rotated = this.getRotatedSide(side, blockAccess.getBlockMetadata(x, y, z));
        if (rotated.getAxis() == Axis.Z) {
            this.random.setSeed(x * 374761393 + y * 668265263 + z * 968290493);
            return this.frontVariants[this.random.nextInt(this.frontVariants.length)];
        }
        return super.getBlockTexture(blockAccess, x, y, z, side);
    }

    @Override
    @Nullable
    public IconCoordinate getBlockOverbrightTexture(WorldSource blockAccess, int x, int y, int z, @NotNull Side side) {
        Side rotated = this.getRotatedSide(side, blockAccess.getBlockMetadata(x, y, z));
        if (rotated.getAxis() == Axis.Z) {
            this.random.setSeed(x * 374761393 + y * 668265263 + z * 968290493);
            return this.frontOverlayVariants[this.random.nextInt(this.frontVariants.length)];
        }
        return super.getBlockOverbrightTexture(blockAccess, x, y, z, side);
    }
}

