/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.customatlas;

import java.util.Comparator;
import org.jetbrains.annotations.NotNull;

public class AtlasTile {
    public static final Comparator<AtlasTile> sorter = (o1, o2) -> o1.x == o2.x ? o1.y - o2.y : o1.x - o2.x;
    @NotNull
    public final String name;
    public final int x;
    public final int y;
    public final int sizeX;
    public final int sizeY;

    public AtlasTile(@NotNull String name, int x, int y, int sizeX, int sizeY) {
        if (x < 0 || x > 65535) {
            throw new RuntimeException("x out of bounds: " + x);
        }
        if (y < 0 || y > 65535) {
            throw new RuntimeException("y out of bounds: " + y);
        }
        this.name = name;
        this.x = x;
        this.y = y;
        this.sizeX = sizeX;
        this.sizeY = sizeY;
    }

    public static int getIndex(int x, int y) {
        return (x & 0xFFFF) << 16 | y & 0xFFFF;
    }
}

