/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.block;

import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockLogic;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.block.material.Material;
import net.minecraft.core.util.phys.AABB;
import net.minecraft.core.world.World;
import net.minecraft.core.world.WorldSource;

public class BlockLogicStalk
extends BlockLogic {
    public BlockLogicStalk(Block<?> block) {
        super(block, Material.plant);
        block.setTicking(true);
        float offset = 0.2f;
        this.setBlockBounds(0.5f - offset, 0.0, 0.5f - offset, 0.5f + offset, offset * 3.0f, 0.5f + offset);
    }

    @Override
    public boolean canPlaceBlockAt(World world, int x, int y, int z) {
        return super.canPlaceBlockAt(world, x, y, z) && this.mayPlaceOn(world.getBlockId(x, y - 1, z));
    }

    protected boolean mayPlaceOn(int blockId) {
        return Blocks.solid[blockId];
    }

    @Override
    public boolean isSolidRender() {
        return false;
    }

    @Override
    public boolean isCubeShaped() {
        return false;
    }

    @Override
    public AABB getCollisionBoundingBoxFromPool(WorldSource world, int x, int y, int z) {
        return null;
    }

    @Override
    public boolean canBlockStay(World world, int x, int y, int z) {
        return this.mayPlaceOn(world.getBlockId(x, y - 1, z));
    }
}

