/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.item.block;

import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockLogicLadder;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.enums.EnumBlockSoundEffectType;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.item.block.ItemBlock;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.world.World;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ItemBlockLadder<T extends BlockLogicLadder>
extends ItemBlock<T> {
    public ItemBlockLadder(Block<T> block) {
        super(block);
    }

    @Override
    public boolean onUseItemOnBlock(@NotNull ItemStack stack, @Nullable Player player, @NotNull World world, int x, int y, int z, @NotNull Side side, double xPlaced, double yPlaced) {
        Side sideForPlacement;
        Block<?> clickedBlock = world.getBlock(x, y, z);
        BlockLogicLadder ladder = (BlockLogicLadder)this.block.getLogic();
        if (clickedBlock == this.block && player != null && !player.isSneaking()) {
            Side clickedLadderSide = ladder.getSideFromMeta(world.getBlockMetadata(x, y, z));
            while (world.getBlock(x, y, z) == this.block && ladder.getSideFromMeta(world.getBlockMetadata(x, y, z)) == clickedLadderSide) {
                --y;
            }
            int meta = ladder.getMetaForSide(clickedLadderSide);
            if (ladder.canExistAt(world, x, y, z, meta)) {
                return this.placeBlock(world, x, y, z, meta, player, stack, clickedLadderSide, 0.5, 0.5);
            }
            return false;
        }
        if (!world.canPlaceInsideBlock(x, y, z)) {
            x += side.getOffsetX();
            y += side.getOffsetY();
            z += side.getOffsetZ();
        }
        if ((sideForPlacement = ladder.getSideForPlacement(world, x, y, z, side)) == null) {
            return false;
        }
        int meta = ladder.getMetaForSide(sideForPlacement);
        if (ladder.canExistAt(world, x, y, z, meta)) {
            return this.placeBlock(world, x, y, z, meta, player, stack, sideForPlacement, xPlaced, yPlaced);
        }
        return false;
    }

    public boolean placeBlock(World world, int x, int y, int z, int meta, @Nullable Player player, ItemStack stack, Side side, double xPlaced, double yPlaced) {
        if (world.canPlaceInsideBlock(x, y, z) && world.canBlockBePlacedAt(this.block.id(), x, y, z, false, side) && stack.consumeItem(player) && world.setBlockAndMetadataWithNotify(x, y, z, this.block.id(), meta)) {
            this.block.onBlockPlacedByMob(world, x, y, z, side, player, xPlaced, yPlaced);
            world.playBlockSoundEffect(player, (float)x + 0.5f, (float)y + 0.5f, (float)z + 0.5f, this.block, EnumBlockSoundEffectType.PLACE);
            return true;
        }
        return false;
    }
}

