/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.entity.particle;

import com.mojang.nbt.tags.CompoundTag;
import net.minecraft.client.render.LightmapHelper;
import net.minecraft.client.render.tessellator.Tessellator;
import net.minecraft.client.render.texture.stitcher.IconCoordinate;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.util.helper.MathHelper;
import net.minecraft.core.world.World;
import org.jetbrains.annotations.NotNull;

public class Particle
extends Entity {
    protected IconCoordinate tex;
    protected float uo;
    protected float vo;
    protected int age;
    protected int lifetime;
    protected float size;
    protected float gravity;
    protected float rCol;
    protected float gCol;
    protected float bCol;

    public Particle(@NotNull World world, double x, double y, double z, double xa, double ya, double za) {
        super(world);
        this.setSize(0.2f, 0.2f);
        this.heightOffset = this.bbHeight / 2.0f;
        this.setPos(x, y, z);
        this.xo = this.x;
        this.yo = this.y;
        this.zo = this.z;
        this.bCol = 1.0f;
        this.gCol = 1.0f;
        this.rCol = 1.0f;
        this.xd = xa + (double)((float)(Math.random() * 2.0 - 1.0) * 0.4f);
        this.yd = ya + (double)((float)(Math.random() * 2.0 - 1.0) * 0.4f);
        this.zd = za + (double)((float)(Math.random() * 2.0 - 1.0) * 0.4f);
        float speed = (float)(Math.random() + Math.random() + 1.0) * 0.15f;
        float dd = MathHelper.sqrt(this.xd * this.xd + this.yd * this.yd + this.zd * this.zd);
        this.xd = this.xd / (double)dd * (double)speed * 0.4;
        this.yd = this.yd / (double)dd * (double)speed * 0.4 + 0.1;
        this.zd = this.zd / (double)dd * (double)speed * 0.4;
        this.uo = this.random.nextFloat() * 3.0f;
        this.vo = this.random.nextFloat() * 3.0f;
        this.size = (this.random.nextFloat() * 0.5f + 0.5f) * 2.0f;
        this.lifetime = (int)(4.0f / (this.random.nextFloat() * 0.9f + 0.1f));
        this.age = 0;
    }

    @Override
    public boolean isInWaterOrRain() {
        return false;
    }

    public Particle setPower(float power) {
        this.xd *= (double)power;
        this.yd = (this.yd - 0.1) * (double)power + 0.1;
        this.zd *= (double)power;
        return this;
    }

    public Particle setScale(float scale) {
        this.setSize(0.2f * scale, 0.2f * scale);
        this.size *= scale;
        return this;
    }

    @Override
    protected boolean makeStepSound() {
        return false;
    }

    @Override
    protected void defineSynchedData() {
    }

    @Override
    public void tick() {
        this.xo = this.x;
        this.yo = this.y;
        this.zo = this.z;
        if (this.age++ >= this.lifetime) {
            this.remove();
        }
        this.yd -= 0.04 * (double)this.gravity;
        this.move(this.xd, this.yd, this.zd);
        this.xd *= 0.98;
        this.yd *= 0.98;
        this.zd *= 0.98;
        if (this.onGround) {
            this.xd *= 0.7;
            this.zd *= 0.7;
        }
    }

    public void render(Tessellator t, float partialTick, double xOff, double yOff, double zOff, float xa, float ya, float za, float xa2, float za2) {
        if (this.tex == null) {
            return;
        }
        float u0 = (float)this.tex.getIconUMin();
        float u2 = (float)this.tex.getIconUMax();
        float v0 = (float)this.tex.getIconVMin();
        float v2 = (float)this.tex.getIconVMax();
        float r = 0.1f * this.size;
        float x = (float)(this.xo + (this.x - this.xo) * (double)partialTick - xOff);
        float y = (float)(this.yo + (this.y - this.yo) * (double)partialTick - yOff);
        float z = (float)(this.zo + (this.z - this.zo) * (double)partialTick - zOff);
        float br = 1.0f;
        if (LightmapHelper.isLightmapEnabled()) {
            t.setLightmapCoord(this.getLightmapCoord(partialTick));
        } else {
            br = this.getBrightness(partialTick);
        }
        t.setColorOpaque_F(this.rCol * br, this.gCol * br, this.bCol * br);
        t.addVertexWithUV(x - xa * r - xa2 * r, y - ya * r, z - za * r - za2 * r, u2, v2);
        t.addVertexWithUV(x - xa * r + xa2 * r, y + ya * r, z - za * r + za2 * r, u2, v0);
        t.addVertexWithUV(x + xa * r + xa2 * r, y + ya * r, z + za * r + za2 * r, u0, v0);
        t.addVertexWithUV(x + xa * r - xa2 * r, y - ya * r, z + za * r - za2 * r, u0, v2);
    }

    public int getParticleTexture() {
        return 0;
    }

    @Override
    public void addAdditionalSaveData(@NotNull CompoundTag tag) {
    }

    @Override
    public void readAdditionalSaveData(@NotNull CompoundTag tag) {
    }
}

