/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.block.model;

import net.minecraft.client.render.block.model.BlockModelStandard;
import net.minecraft.client.render.tessellator.Tessellator;
import net.minecraft.client.render.texture.stitcher.IconCoordinate;
import net.minecraft.client.render.texture.stitcher.TextureRegistry;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockLogic;
import net.minecraft.core.block.BlockLogicChest;
import net.minecraft.core.util.helper.Axis;
import net.minecraft.core.util.helper.Direction;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.world.WorldSource;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.useless.dragonfly.DisplayPos;

public class BlockModelChest<T extends BlockLogic>
extends BlockModelStandard<T> {
    protected static final DisplayPos CHEST_GUI = new DisplayPos(0.0f, 0.0f, 0.0f, 30.0f, 45.0f, 0.0f, 0.625f, 0.625f, 0.625f);
    protected static final DisplayPos CHEST_HEAD = new DisplayPos(0.0f, 0.0f, 0.0f, 0.0f, -180.0f, 0.0f, 1.0f, 1.0f, 1.0f);
    protected static final DisplayPos CHEST_FIRST_PERSON_RIGHT_HAND = new DisplayPos(0.0f, 0.0f, 0.0f, 0.0f, -45.0f, 0.0f, 0.4f, 0.4f, 0.4f);
    protected IconCoordinate chestFrontSingle;
    protected IconCoordinate chestFrontLeft;
    protected IconCoordinate chestFrontRight;
    protected IconCoordinate chestBackLeft;
    protected IconCoordinate chestBackRight;
    protected IconCoordinate chestTopLeft;
    protected IconCoordinate chestTopRight;
    protected IconCoordinate chestSide;
    protected IconCoordinate chestTop;

    public BlockModelChest(Block<T> block, String rootKey) {
        super(block);
        this.chestFrontSingle = TextureRegistry.getTexture(rootKey + "front");
        this.chestFrontLeft = TextureRegistry.getTexture(rootKey + "left_front");
        this.chestFrontRight = TextureRegistry.getTexture(rootKey + "right_front");
        this.chestTopLeft = TextureRegistry.getTexture(rootKey + "top_left");
        this.chestTopRight = TextureRegistry.getTexture(rootKey + "top_right");
        this.chestBackLeft = TextureRegistry.getTexture(rootKey + "left_back");
        this.chestBackRight = TextureRegistry.getTexture(rootKey + "right_back");
        this.chestSide = TextureRegistry.getTexture(rootKey + "side");
        this.chestTop = TextureRegistry.getTexture(rootKey + "top");
        this.setDisplayPos("gui", CHEST_GUI);
        this.setDisplayPos("head", CHEST_HEAD);
        this.setDisplayPos("firstperson_righthand", CHEST_FIRST_PERSON_RIGHT_HAND);
    }

    @Override
    public boolean render(@NotNull Tessellator tessellator, @NotNull WorldSource worldSource, int x, int y, int z) {
        int meta = worldSource.getBlockMetadata(x, y, z);
        Direction dir2 = BlockLogicChest.getDirectionFromMeta(meta);
        switch (dir2) {
            case NORTH: {
                BlockModelChest.renderBlocks.uvRotateTop = 3;
                BlockModelChest.renderBlocks.uvRotateBottom = 3;
                break;
            }
            case EAST: {
                BlockModelChest.renderBlocks.uvRotateTop = 2;
                BlockModelChest.renderBlocks.uvRotateBottom = 1;
                break;
            }
            case WEST: {
                BlockModelChest.renderBlocks.uvRotateTop = 1;
                BlockModelChest.renderBlocks.uvRotateBottom = 2;
            }
        }
        renderBlocks.renderStandardBlock(tessellator, worldSource, this, this.block.getBlockBoundsFromState(worldSource, x, y, z), x, y, z);
        renderBlocks.resetRenderBlocks();
        return true;
    }

    @Override
    @Nullable
    public IconCoordinate getBlockTexture(WorldSource blockAccess, int x, int y, int z, Side side) {
        int meta = blockAccess.getBlockMetadata(x, y, z);
        Side facing = BlockLogicChest.getDirectionFromMeta(meta).getSide();
        BlockLogicChest.Type type = BlockLogicChest.getTypeFromMeta(meta);
        if (side == Side.TOP || side == Side.BOTTOM) {
            if (type == BlockLogicChest.Type.RIGHT) {
                return this.chestTopRight;
            }
            if (type == BlockLogicChest.Type.LEFT) {
                return this.chestTopLeft;
            }
            return this.chestTop;
        }
        if (type == BlockLogicChest.Type.SINGLE && side == facing) {
            return this.chestFrontSingle;
        }
        if (type == BlockLogicChest.Type.LEFT) {
            if (side == facing) {
                return this.chestFrontLeft;
            }
            if (side == facing.getOpposite()) {
                return this.chestBackRight;
            }
        }
        if (type == BlockLogicChest.Type.RIGHT) {
            if (side == facing) {
                return this.chestFrontRight;
            }
            if (side == facing.getOpposite()) {
                return this.chestBackLeft;
            }
        }
        if (side.getAxis() != Axis.Y) {
            return this.chestSide;
        }
        return this.chestTop;
    }

    @Override
    @Nullable
    public IconCoordinate getBlockTextureFromSideAndMetadata(Side side, int data) {
        if (side == Side.SOUTH) {
            return this.chestFrontSingle;
        }
        if (side.isHorizontal()) {
            return this.chestSide;
        }
        return this.chestTop;
    }
}

