/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.texture.stitcher;

import com.mojang.logging.LogUtils;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Stream;
import net.minecraft.client.render.texture.stitcher.AtlasStitcher;
import net.minecraft.client.render.texture.stitcher.IconCoordinate;
import net.minecraft.core.Global;
import net.minecraft.core.util.HardIllegalArgumentException;
import net.minecraft.core.util.collection.NamespaceID;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

public class TextureRegistry {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static HashMap<String, AtlasStitcher> stitcherMap = new HashMap();
    public static HashMap<AtlasStitcher, String> stitcherMapReverse = new HashMap();
    public static AtlasStitcher blockAtlas = TextureRegistry.register("block", new AtlasStitcher("textures/block", false, true, "/assets/minecraft/textures/block/texture_missing.png"));
    public static AtlasStitcher itemAtlas = TextureRegistry.register("item", new AtlasStitcher("textures/item", false, true, "/assets/minecraft/textures/item/texture_missing.png"));
    public static AtlasStitcher particleAtlas = TextureRegistry.register("particle", new AtlasStitcher("textures/particle", false, true, null));
    public static AtlasStitcher artAtlas = TextureRegistry.register("art", new AtlasStitcher("textures/art", false, true, null));
    public static AtlasStitcher guiSpriteAtlas = TextureRegistry.register("gui", new AtlasStitcher("textures/gui/sprites", true, false, null));
    public static AtlasStitcher signAtlas = TextureRegistry.register("sign", new AtlasStitcher("textures/gui/sign", false, false, null));
    private static final DateFormat dateFormat;
    private static final Map<String, String> atlasNameRemappings;

    @NotNull
    public static IconCoordinate getTexture(@NotNull String key) {
        try {
            return TextureRegistry.getTexture(NamespaceID.getTemp(key));
        }
        catch (HardIllegalArgumentException e) {
            throw new RuntimeException(e);
        }
    }

    @NotNull
    public static IconCoordinate getTexture(@NotNull NamespaceID id) {
        int slashIndex = id.value().indexOf("/");
        AtlasStitcher atlas = stitcherMap.get(id.value().substring(0, slashIndex));
        if (atlas == null) {
            throw new IllegalArgumentException("Failed to find atlas '" + id.value().substring(0, slashIndex) + "'!");
        }
        return atlas.getTexture(id, NamespaceID.getTemp(id.namespace(), id.value().substring(slashIndex + 1)));
    }

    public static boolean hasTexture(@NotNull String key) {
        try {
            return TextureRegistry.hasTexture(NamespaceID.getTemp(key));
        }
        catch (HardIllegalArgumentException e) {
            throw new RuntimeException(e);
        }
    }

    public static boolean hasTexture(@NotNull NamespaceID id) {
        int slashIndex = id.value().indexOf("/");
        AtlasStitcher atlas = stitcherMap.get(id.value().substring(0, slashIndex));
        if (atlas == null) {
            throw new IllegalArgumentException("Failed to find atlas '" + id.value().substring(0, slashIndex) + "'!");
        }
        return atlas.textureMap.containsKey(NamespaceID.getTemp(id.namespace(), id.value().substring(slashIndex + 1)));
    }

    public static AtlasStitcher register(String id, AtlasStitcher atlas) {
        stitcherMap.put(id, atlas);
        stitcherMapReverse.put(atlas, id);
        return atlas;
    }

    public static void initializeAllFiles(String namespace, AtlasStitcher atlas, boolean subDirectories) throws URISyntaxException, IOException, NullPointerException {
        String[] files;
        String path = String.format("%s/%s/%s", "/assets", namespace, atlas.directoryPath);
        for (String s : files = TextureRegistry.getFilesAndSubFiles(path, subDirectories)) {
            NamespaceID id = NamespaceID.getTemp(namespace, s.replace(".png", "").replace("//", "/"));
            atlas.getTexture(NamespaceID.getTemp(id.namespace(), stitcherMapReverse.get(atlas) + "/" + id.value()), id);
        }
    }

    public static String[] getFilesAndSubFiles(String directory, boolean searchSubDirectories) throws IOException, URISyntaxException {
        Path myPath;
        URI uri;
        ArrayList<String> paths = new ArrayList<String>();
        if (!directory.endsWith("/")) {
            directory = directory + "/";
        }
        String[] dirs = directory.split("/");
        String currentDir = dirs[dirs.length - 1].replace("/", "");
        ArrayList<String> subDirectories = new ArrayList<String>();
        try {
            uri = Objects.requireNonNull(TextureRegistry.class.getResource(directory)).toURI();
        }
        catch (NullPointerException npe) {
            LOGGER.warn("Failed to load directory '{}'! Skipping!", (Object)directory);
            return new String[0];
        }
        FileSystem fileSystem = null;
        if (uri.getScheme().equals("jar")) {
            fileSystem = FileSystems.newFileSystem(uri, Collections.emptyMap());
            myPath = fileSystem.getPath(directory, new String[0]);
        } else {
            myPath = Paths.get(uri);
        }
        Stream<Path> walk = Files.walk(myPath, 1, new FileVisitOption[0]);
        Iterator it = walk.iterator();
        while (it.hasNext()) {
            Path file = (Path)it.next();
            String name = file.getFileName().toString();
            if (name.contains(".")) {
                if (!name.endsWith(".png")) continue;
                paths.add(name);
                continue;
            }
            if (!searchSubDirectories || name.replace("/", "").equals(currentDir)) continue;
            subDirectories.add(directory + name);
        }
        walk.close();
        if (fileSystem != null) {
            fileSystem.close();
        }
        if (searchSubDirectories) {
            for (String dir2 : subDirectories) {
                String[] files;
                for (String f : files = TextureRegistry.getFilesAndSubFiles(dir2, searchSubDirectories)) {
                    paths.add(dir2.replaceFirst(directory, "") + "/" + f);
                }
            }
        }
        return paths.toArray(new String[0]);
    }

    public static void dumpTilesToFolder(@NotNull File folder) {
        for (Map.Entry<String, AtlasStitcher> stitcherEntry : stitcherMap.entrySet()) {
            try {
                AtlasStitcher stitcher = stitcherEntry.getValue();
                File tileFile = new File(folder, atlasNameRemappings.getOrDefault(stitcherEntry.getKey(), stitcherEntry.getKey()) + ".tiles");
                tileFile.createNewFile();
                try (FileWriter writer = new FileWriter(tileFile);){
                    writer.append("# Auto generated tiles mapping for atlas '").append(stitcherEntry.getKey()).append("'\n");
                    writer.append("# generated for version '").append(Global.VERSION).append("' at '").append(dateFormat.format(new Date())).append("'\n");
                    writer.append("size=").append(Integer.toString(stitcher.atlas.getWidth())).append("x").append(Integer.toString(stitcher.atlas.getHeight())).append("\n");
                    for (Map.Entry<NamespaceID, IconCoordinate> entry : stitcher.textureMap.entrySet()) {
                        IconCoordinate coordinate = entry.getValue();
                        writer.append(Integer.toString(coordinate.iconX)).append(",").append(Integer.toString(coordinate.iconY));
                        writer.append("=");
                        writer.append(entry.getKey().value());
                        writer.append(" <").append(Integer.toString(coordinate.width)).append(",").append(Integer.toString(coordinate.height)).append(">");
                        writer.append("\n");
                    }
                }
                catch (IOException e) {
                    LOGGER.error("Failed to write tile map to file '{}'!", (Object)tileFile.getPath(), (Object)e);
                }
            }
            catch (IOException e) {
                LOGGER.error("Failed to create tile map for atlas '{}'!", (Object)stitcherEntry.getKey(), (Object)e);
            }
        }
    }

    static {
        try {
            for (AtlasStitcher stitcher : stitcherMap.values()) {
                TextureRegistry.initializeAllFiles("minecraft", stitcher, stitcher != artAtlas);
            }
        }
        catch (Exception e) {
            LOGGER.warn("Failed to fully initialize assets, some issue may occur!", e);
        }
        dateFormat = new SimpleDateFormat("yyyy-MM-dd_HH.mm.ss");
        atlasNameRemappings = new HashMap<String, String>();
        atlasNameRemappings.put("block", "terrain");
        atlasNameRemappings.put("item", "items");
    }
}

