/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.block.model;

import net.minecraft.client.render.LightmapHelper;
import net.minecraft.client.render.block.model.BlockModelStandard;
import net.minecraft.client.render.tessellator.Tessellator;
import net.minecraft.client.render.texture.stitcher.IconCoordinate;
import net.minecraft.client.render.texture.stitcher.TextureRegistry;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockLogic;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.world.WorldSource;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BlockModelCropsPumpkin<T extends BlockLogic>
extends BlockModelStandard<T> {
    public static final IconCoordinate[] GROWTH_STAGE_TEXTURES_TOP = new IconCoordinate[]{TextureRegistry.getTexture("minecraft:block/crops_pumpkin/stage1_top"), TextureRegistry.getTexture("minecraft:block/crops_pumpkin/stage2_top"), TextureRegistry.getTexture("minecraft:block/crops_pumpkin/stage3_top"), TextureRegistry.getTexture("minecraft:block/crops_pumpkin/stage4_top")};
    public static final IconCoordinate[] GROWTH_STAGE_TEXTURES_SIDE = new IconCoordinate[]{TextureRegistry.getTexture("minecraft:block/crops_pumpkin/stage1_side"), TextureRegistry.getTexture("minecraft:block/crops_pumpkin/stage2_side"), TextureRegistry.getTexture("minecraft:block/crops_pumpkin/stage3_side"), TextureRegistry.getTexture("minecraft:block/crops_pumpkin/stage4_side")};
    public static final IconCoordinate LEAF_TEXTURE = TextureRegistry.getTexture("minecraft:block/crops_pumpkin/stage0");

    public BlockModelCropsPumpkin(Block<T> block) {
        super(block);
    }

    @Override
    public boolean render(@NotNull Tessellator tessellator, @NotNull WorldSource worldSource, int x, int y, int z) {
        float brightness = 1.0f;
        if (LightmapHelper.isLightmapEnabled()) {
            tessellator.setLightmapCoord(this.block.getLightmapCoord(worldSource, x, y, z));
        } else {
            brightness = renderBlocks.getBlockBrightness(worldSource, x, y, z);
        }
        tessellator.setColorOpaque_F(brightness, brightness, brightness);
        int meta = worldSource.getBlockMetadata(x, y, z);
        IconCoordinate leafTexture = LEAF_TEXTURE;
        if (BlockModelCropsPumpkin.renderBlocks.overrideBlockTexture != null) {
            leafTexture = BlockModelCropsPumpkin.renderBlocks.overrideBlockTexture;
        }
        double uMin = leafTexture.getIconUMin();
        double uMax = leafTexture.getIconUMax();
        double vMin = leafTexture.getIconVMin();
        double vMax = leafTexture.getIconVMax();
        double xMin = (double)x + 0.5 - 0.25;
        double xMax = (double)x + 0.5 + 0.25;
        double yMin = (double)y + 0.0;
        double yMax = (double)y + 0.1875;
        double zMin = (double)z + 0.5 - 0.5;
        double zMax = (double)z + 0.5 + 0.5;
        double extra = 0.625;
        tessellator.addVertexWithUV(xMin - extra, yMax, zMax, uMin, vMin);
        tessellator.addVertexWithUV(xMax, yMin, zMax, uMin, vMax);
        tessellator.addVertexWithUV(xMax, yMin, zMin, uMax, vMax);
        tessellator.addVertexWithUV(xMin - extra, yMax, zMin, uMax, vMin);
        tessellator.addVertexWithUV(xMin - extra, yMax, zMin, uMin, vMin);
        tessellator.addVertexWithUV(xMax, yMin, zMin, uMin, vMax);
        tessellator.addVertexWithUV(xMax, yMin, zMax, uMax, vMax);
        tessellator.addVertexWithUV(xMin - extra, yMax, zMax, uMax, vMin);
        tessellator.addVertexWithUV(xMax + extra, yMax, zMin, uMin, vMin);
        tessellator.addVertexWithUV(xMin, yMin, zMin, uMin, vMax);
        tessellator.addVertexWithUV(xMin, yMin, zMax, uMax, vMax);
        tessellator.addVertexWithUV(xMax + extra, yMax, zMax, uMax, vMin);
        tessellator.addVertexWithUV(xMax + extra, yMax, zMax, uMin, vMin);
        tessellator.addVertexWithUV(xMin, yMin, zMax, uMin, vMax);
        tessellator.addVertexWithUV(xMin, yMin, zMin, uMax, vMax);
        tessellator.addVertexWithUV(xMax + extra, yMax, zMin, uMax, vMin);
        if (meta >= 1) {
            renderBlocks.renderStandardBlock(tessellator, worldSource, this, this.block.getBlockBoundsFromState(worldSource, x, y, z), x, y, z);
        }
        return true;
    }

    @Override
    public boolean shouldItemRender3d() {
        return false;
    }

    @Override
    @Nullable
    public IconCoordinate getBlockTextureFromSideAndMetadata(Side side, int data) {
        if (data < 1 || data > 4) {
            data = 1;
        }
        if (side == Side.TOP || side == Side.BOTTOM) {
            return GROWTH_STAGE_TEXTURES_TOP[data - 1];
        }
        return GROWTH_STAGE_TEXTURES_SIDE[data - 1];
    }
}

