/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.options.components;

import com.mojang.logging.LogUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.options.components.ButtonComponent;
import net.minecraft.client.gui.options.components.OptionsComponent;
import net.minecraft.client.render.tessellator.Tessellator;
import net.minecraft.core.lang.I18n;
import net.minecraft.core.lang.Language;
import net.minecraft.core.lang.LanguageSeeker;
import org.lwjgl.opengl.GL11;
import org.slf4j.Logger;

public class LanguagePackListComponent
implements OptionsComponent {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final int BUTTON_HEIGHT = 32;
    private List<Language> languages = null;
    private final List<LanguagePackComponent> buttons = new ArrayList<LanguagePackComponent>();

    @Override
    public void init(Minecraft mc) {
        this.buttons.clear();
        try {
            this.languages = LanguageSeeker.getAvailableLanguages();
            for (int i = 0; i < this.languages.size(); ++i) {
                Language language = this.languages.get(i);
                this.buttons.add(new LanguagePackComponent(i, language));
            }
        }
        catch (IOException e) {
            LOGGER.error("Exception while getting available languages!", e);
        }
    }

    @Override
    public int getHeight() {
        return this.buttons.size() * 32;
    }

    @Override
    public void render(int x, int y, int width, int relativeMouseX, int relativeMouseY) {
        for (int i = 0; i < this.buttons.size(); ++i) {
            LanguagePackComponent button = this.buttons.get(i);
            button.render(x, 3 + y + i * 35, width, relativeMouseX, relativeMouseY);
        }
    }

    @Override
    public void onMouseClick(int mouseButton, int x, int y, int width, int relativeMouseX, int relativeMouseY) {
        for (int i = 0; i < this.buttons.size(); ++i) {
            LanguagePackComponent button = this.buttons.get(i);
            if (relativeMouseX < 0 || relativeMouseX > width || relativeMouseY < 3 + i * 35 || relativeMouseY > 3 + i * 35 + 32) continue;
            String lang = button.languagePack.getId();
            ButtonComponent.mc.gameSettings.language.set(lang);
            I18n.getInstance().reload(lang);
            ButtonComponent.mc.currentScreen.init();
        }
    }

    @Override
    public void onMouseMove(int x, int y, int width, int relativeMouseX, int relativeMouseY) {
    }

    @Override
    public void onMouseRelease(int mouseButton, int x, int y, int width, int relativeMouseX, int relativeMouseY) {
    }

    @Override
    public void onKeyPress(int keyCode, char character) {
    }

    @Override
    public boolean matchesSearchTerm(String term) {
        return false;
    }

    private static class LanguagePackComponent {
        private final Minecraft mc = Minecraft.getMinecraft();
        public final int index;
        public final Language languagePack;
        public final int height = 32;

        public LanguagePackComponent(int index, Language languagePack) {
            this.index = index;
            this.languagePack = languagePack;
        }

        public void render(int x, int y, int width, int mouseX, int mouseY) {
            Tessellator tessellator = Tessellator.instance;
            if (((String)this.mc.gameSettings.language.value).equals(this.languagePack.getId())) {
                GL11.glColor4f(1.0f, 1.0f, 1.0f, 1.0f);
                GL11.glDisable(3553);
                tessellator.startDrawingQuads();
                tessellator.setColorOpaque_I(2139127936);
                tessellator.addVertexWithUV(x - 2, y + 32 + 2, 0.0, 0.0, 1.0);
                tessellator.addVertexWithUV(x + width + 2, y + 32 + 2, 0.0, 1.0, 1.0);
                tessellator.addVertexWithUV(x + width + 2, y - 2, 0.0, 1.0, 1.0);
                tessellator.addVertexWithUV(x - 2, y - 2, 0.0, 0.0, 0.0);
                tessellator.setColorOpaque_I(0);
                tessellator.addVertexWithUV(x - 1, y + 32 + 1, 0.0, 0.0, 1.0);
                tessellator.addVertexWithUV(x + width + 1, y + 32 + 1, 0.0, 1.0, 1.0);
                tessellator.addVertexWithUV(x + width + 1, y - 1, 0.0, 1.0, 1.0);
                tessellator.addVertexWithUV(x - 1, y - 1, 0.0, 0.0, 0.0);
                tessellator.draw();
                GL11.glEnable(3553);
            }
            StringBuilder sb = new StringBuilder();
            String name = this.languagePack.getName();
            String region = this.languagePack.getRegion();
            if (name != null) {
                sb.append(name);
            } else {
                sb.append("Unknown Language");
            }
            if (region != null) {
                sb.append(" (").append(region).append(")");
            }
            String fullName = sb.toString();
            StringBuilder credits = new StringBuilder();
            ListIterator<String> creditsList = this.languagePack.getCredits().listIterator();
            boolean empty = true;
            while (creditsList.hasNext()) {
                credits.append((String)creditsList.next());
                if (creditsList.hasNext()) {
                    credits.append(", ");
                }
                empty = false;
            }
            this.mc.font.renderCentered(Tessellator.instance, fullName, x + width / 2, y + 1).setShadow().call();
            this.mc.font.renderCentered(Tessellator.instance, empty ? "Unknown Credits" : credits, x + width / 2, y + 12).setShadow().setColor(0x808080).call();
        }
    }
}

