/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.options.data;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.options.components.OptionsComponent;
import net.minecraft.core.item.ItemStack;

public class OptionsPage {
    private static final int COMPONENT_SPACING = 4;
    private final String translationKey;
    private final List<OptionsComponent> components = new ArrayList<OptionsComponent>();
    private final ItemStack icon;

    public OptionsPage(String translationKey, ItemStack icon) {
        this.translationKey = translationKey;
        this.icon = icon;
    }

    public OptionsPage withComponent(OptionsComponent component) {
        this.components.add(component);
        return this;
    }

    public String getTranslationKey() {
        return this.translationKey;
    }

    public List<OptionsComponent> getComponents() {
        return this.components;
    }

    public void initComponents(Minecraft mc) {
        for (OptionsComponent component : this.components) {
            component.init(mc);
        }
    }

    public int getHeight() {
        int height = 0;
        for (OptionsComponent component : this.components) {
            height += component.getHeight() + 4;
        }
        return height -= 4;
    }

    public ItemStack getIcon() {
        return this.icon;
    }
}

