/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.console.shell.commands;

import bsh.CallStack;
import bsh.ClassIdentifier;
import bsh.Interpreter;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import net.minecraft.client.console.shell.RawOutputWrapper;
import net.minecraft.core.net.command.TextFormatting;

public class methods {
    public static RawOutputWrapper invoke(Interpreter env, CallStack callstack, Object o) {
        return methods.inner(o.getClass());
    }

    public static RawOutputWrapper invoke(Interpreter env, CallStack callstack, ClassIdentifier clazz) {
        return methods.inner(clazz.getTargetClass());
    }

    private static RawOutputWrapper inner(Class<?> clazz) {
        Method[] methods2;
        if (clazz == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        for (Method method : methods2 = clazz.getMethods()) {
            Class<?> returnType = method.getReturnType();
            sb.append(TextFormatting.WHITE).append("    ").append(TextFormatting.ORANGE).append(Modifier.toString(method.getModifiers())).append(" ");
            if (returnType.isPrimitive()) {
                sb.append(TextFormatting.ORANGE);
            } else {
                sb.append(TextFormatting.WHITE);
            }
            sb.append(returnType.getSimpleName()).append(" ").append(TextFormatting.LIGHT_BLUE).append(method.getName()).append(TextFormatting.WHITE).append("(");
            Parameter[] parameters = method.getParameters();
            for (int i = 0; i < method.getParameterCount(); ++i) {
                Parameter parameter = parameters[i];
                String modifierString = Modifier.toString(parameter.getModifiers());
                if (!modifierString.isEmpty()) {
                    sb.append(TextFormatting.ORANGE).append(modifierString).append(" ");
                }
                if (parameter.getType().isPrimitive()) {
                    sb.append(TextFormatting.ORANGE);
                } else {
                    sb.append(TextFormatting.WHITE);
                }
                sb.append(parameter.getType().getSimpleName()).append(" ").append(TextFormatting.WHITE).append(parameter.getName());
                if (i >= parameters.length - 1) continue;
                sb.append(", ");
            }
            sb.append(TextFormatting.WHITE).append(");\n");
        }
        return new RawOutputWrapper(sb.toString());
    }
}

