/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.modelviewer.categories;

import java.io.File;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.entity.particle.ParticleDispatcher;
import net.minecraft.client.gui.ButtonElement;
import net.minecraft.client.gui.modelviewer.ScreenModelViewer;
import net.minecraft.client.gui.modelviewer.categories.ModelViewerCategory;
import net.minecraft.client.gui.modelviewer.categories.entries.particle.ParticleEntry;
import net.minecraft.client.gui.modelviewer.categories.entries.particle.ParticleEntryBlock;
import net.minecraft.client.gui.modelviewer.categories.entries.particle.ParticleEntryBubble;
import net.minecraft.client.gui.modelviewer.categories.entries.particle.ParticleEntryGeneric;
import net.minecraft.client.gui.modelviewer.categories.entries.particle.ParticleEntryItem;
import net.minecraft.client.gui.modelviewer.categories.entries.particle.ParticleEntryLeaf;
import net.minecraft.client.gui.modelviewer.categories.entries.particle.ParticleEntryNote;
import net.minecraft.client.gui.modelviewer.categories.entries.particle.ParticleEntryRedstone;
import net.minecraft.client.gui.modelviewer.elements.ListenerSliderElement;
import net.minecraft.core.lang.I18n;
import org.jetbrains.annotations.NotNull;

public class ViewerCategoryParticle
extends ModelViewerCategory<ModelViewerCategory.Info> {
    public Map<String, ParticleEntry> entryMap = new HashMap<String, ParticleEntry>();
    public List<ParticleEntry> entriesList;
    public double spawnRadius = 0.0;
    public ParticleEntry currentEntry;

    public ViewerCategoryParticle(ScreenModelViewer modelViewer) {
        super(modelViewer);
        this.initEntries();
        this.entriesList = new ArrayList<ParticleEntry>(this.entryMap.values());
        this.entriesList.sort(Comparator.comparing(o -> o.getParticleName(I18n.getInstance())));
    }

    private void initEntries() {
        for (String s : ParticleDispatcher.getInstance().getParticleIds()) {
            this.entryMap.put(s, new ParticleEntryGeneric(s));
        }
        this.entryMap.put("bubble", new ParticleEntryBubble());
        this.entryMap.put("note", new ParticleEntryNote());
        this.entryMap.put("reddust", new ParticleEntryRedstone());
        this.entryMap.put("item", new ParticleEntryItem());
        this.entryMap.put("block", new ParticleEntryBlock());
        this.entryMap.put("fallingleaf", new ParticleEntryLeaf());
    }

    private void setCurrentEntry(ParticleEntry entry) {
        if (this.currentEntry != null) {
            this.currentEntry.onClose();
        }
        this.currentEntry = entry;
        if (this.currentEntry != null) {
            this.currentEntry.onOpen();
        }
    }

    @Override
    public String getCategoryNameKey() {
        return "model.category.particle.name";
    }

    @Override
    public String getCurrentDisplayInfo(I18n translator) {
        return translator.translateKeyAndFormat("model.category.particle.info", this.currentEntry.getParticleName(translator));
    }

    @Override
    public void addContextButtons(List<ButtonElement> buttonList) {
        ButtonElement lastButton = buttonList.get(buttonList.size() - 1);
        ListenerSliderElement radiusSlider = new ListenerSliderElement(-1, this.modelViewer.width - 120, lastButton.yPosition + 21, 120, 20, I18n.getInstance().translateKeyAndFormat("model.category.particle.radius.slider", Float.valueOf((float)((int)(this.spawnRadius * 100.0)) / 100.0f)), (float)this.spawnRadius);
        radiusSlider.setOnValueChanged(() -> {
            this.spawnRadius = radiusSlider.sliderValue;
            radiusSlider.displayString = I18n.getInstance().translateKeyAndFormat("model.category.particle.radius.slider", Float.valueOf((float)((int)(this.spawnRadius * 100.0)) / 100.0f));
        });
        buttonList.add(radiusSlider);
        int xPos = this.modelViewer.width;
        int yPos = radiusSlider.getY() + radiusSlider.getHeight() + 1;
        List<ButtonElement> buttons = this.currentEntry.getEntryButtons(this.mc, this.modelViewer);
        if (buttons != null) {
            for (ButtonElement button : buttons) {
                button.setX(button.getX() + xPos);
                button.setY(button.getY() + yPos);
            }
            buttonList.addAll(buttons);
        }
    }

    @Override
    public void cycleCategoryEntry(int offset) {
        this.setCurrentEntry(this.entriesList.get((this.entriesList.indexOf(this.currentEntry) + this.entriesList.size() + offset) % this.entriesList.size()));
        this.mc.particleEngine.setWorld(this.mc.currentWorld);
        this.modelViewer.init();
    }

    @Override
    public void onOpen() {
        this.spawnRadius = 0.0;
        this.setCurrentEntry(this.entriesList.get(0));
    }

    @Override
    public void onClose() {
        this.mc.particleEngine.setWorld(this.mc.currentWorld);
        this.currentEntry.onClose();
    }

    @Override
    public void onTick() {
        double offX = 0.0;
        double offY = 0.0;
        double offZ = 0.0;
        if (this.spawnRadius > 0.0) {
            offX = this.mc.currentWorld.rand.nextDouble() - this.mc.currentWorld.rand.nextDouble();
            offY = this.mc.currentWorld.rand.nextDouble() - this.mc.currentWorld.rand.nextDouble();
            offZ = this.mc.currentWorld.rand.nextDouble() - this.mc.currentWorld.rand.nextDouble();
        }
        this.currentEntry.spawnParticle(this.mc, this.mc.currentWorld, this.mc.thePlayer.x + (offX *= this.spawnRadius), this.mc.thePlayer.y + (double)this.mc.thePlayer.getHeadHeight() + (offY *= this.spawnRadius), this.mc.thePlayer.z + (offZ *= this.spawnRadius));
    }

    @Override
    public void queueBulkRender(@NotNull File outputDir, List<ModelViewerCategory.Info> renderInfos) {
    }

    @Override
    public void setupRender(ModelViewerCategory.Info info) {
    }
}

