/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.options.components;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.IntegerSliderElement;
import net.minecraft.client.gui.options.components.ButtonComponent;
import net.minecraft.client.option.OptionToggleable;
import net.minecraft.client.render.window.CursorShape;

public class ToggleableOptionComponent<E>
extends ButtonComponent {
    protected final OptionToggleable<E> option;
    protected final IntegerSliderElement slider;

    public ToggleableOptionComponent(OptionToggleable<E> option) {
        super("options." + option.name);
        this.option = option;
        this.option.addCallback(__ -> this.onChanged());
        this.slider = new IntegerSliderElement(0, 0, 0, 150, 20, option);
    }

    @Override
    public void resetValue() {
        this.option.set(this.option.getDefaultValue());
        this.slider.sliderValue = this.option.getValueIndex();
        this.onChanged();
        this.option.onUpdate();
    }

    @Override
    protected void buttonClicked(int mouseButton, int x, int y, int width, int height, int relativeMouseX, int relativeMouseY) {
        this.slider.mouseClicked(mc, this.slider.xPosition + relativeMouseX, this.slider.yPosition + relativeMouseY);
        this.onChanged();
        this.option.onUpdate();
    }

    @Override
    protected void buttonDragged(int x, int y, int width, int height, int relativeMouseX, int relativeMouseY) {
        this.onChanged();
        this.option.onUpdate();
    }

    @Override
    protected void buttonReleased(int mouseButton, int x, int y, int width, int height, int relativeMouseX, int relativeMouseY) {
        this.slider.mouseReleased(this.slider.xPosition + relativeMouseX, this.slider.yPosition + relativeMouseY);
        this.onChanged();
        this.option.onUpdate();
    }

    @Override
    protected void renderButton(int x, int y, int relativeButtonX, int relativeButtonY, int buttonWidth, int buttonHeight, int relativeMouseX, int relativeMouseY) {
        super.renderButton(x, y, relativeButtonX, relativeButtonY, buttonWidth, buttonHeight, relativeMouseX, relativeMouseY);
        this.slider.xPosition = x + relativeButtonX;
        this.slider.yPosition = y + relativeButtonY;
        this.slider.width = buttonWidth;
        this.slider.height = buttonHeight;
        this.slider.drawButton(mc, x + relativeMouseX, y + relativeMouseY);
        if (relativeMouseX >= relativeButtonX && relativeMouseX < relativeButtonX + buttonWidth && relativeMouseY >= relativeButtonY && relativeButtonY < relativeButtonY + buttonHeight) {
            ToggleableOptionComponent.mc.currentScreen.setDesiredCursor(CursorShape.HAND);
        }
    }

    @Override
    public void init(Minecraft mc) {
        this.slider.sliderValue = this.option.getValueIndex();
        this.onChanged();
    }

    protected void onChanged() {
        this.slider.displayString = this.option.getDisplayStringValue();
    }

    @Override
    public boolean isDefault() {
        return this.option.value.equals(this.option.getDefaultValue());
    }
}

