/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.tileentity;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.render.TextureManager;
import net.minecraft.client.render.TileEntityRenderDispatcher;
import net.minecraft.client.render.camera.ICamera;
import net.minecraft.client.render.font.FontRenderer;
import net.minecraft.client.render.tessellator.Tessellator;
import net.minecraft.core.block.entity.TileEntity;
import net.minecraft.core.block.entity.TileEntityDispatcher;
import net.minecraft.core.util.collection.NamespaceID;
import net.minecraft.core.world.World;
import org.jetbrains.annotations.NotNull;
import org.useless.dragonfly.data.entity.mojang.EntityGeometryMojangData;
import org.useless.dragonfly.models.entity.StaticEntityModel;

public abstract class TileEntityRenderer<T extends TileEntity> {
    @NotNull
    private final @NotNull Map<@NotNull String, @NotNull StaticEntityModel> modelMap = new HashMap<String, StaticEntityModel>();
    protected TileEntityRenderDispatcher renderDispatcher = null;
    protected Class<? extends T> appliedClass = null;

    public void tick() {
    }

    public abstract void doRender(Tessellator var1, T var2, double var3, double var5, double var7, float var9);

    protected void bindTexture(String texturePath) {
        TextureManager textureManager = this.renderDispatcher.textureManager;
        textureManager.bindTexture(textureManager.loadTexture(texturePath));
    }

    public void init(@NotNull Class<? extends T> appliedClass, @NotNull TileEntityRenderDispatcher renderDispatcher) {
        this.renderDispatcher = renderDispatcher;
        this.appliedClass = appliedClass;
    }

    public void onWorldChanged(World world) {
    }

    @NotNull
    protected StaticEntityModel getModel(@NotNull String localId) {
        StaticEntityModel model = this.modelMap.get(localId);
        if (model != null) {
            return model;
        }
        NamespaceID id = TileEntityDispatcher.getIDFromClass(this.appliedClass);
        model = id != null ? EntityGeometryMojangData.Cache.getModelForEntity(id, localId) : EntityGeometryMojangData.Cache.getFallbackModel();
        this.modelMap.put(localId, model);
        return model;
    }

    @NotNull
    public final TileEntityRenderer<T> setModel(@NotNull String localId, @NotNull String modelId, double inflation) {
        this.modelMap.put(localId, EntityGeometryMojangData.Cache.getModel(modelId, inflation));
        return this;
    }

    public FontRenderer getFont() {
        return this.renderDispatcher.getFont();
    }

    public boolean isVisible(@NotNull T tileEntity, @NotNull ICamera camera, float partialTick) {
        return true;
    }
}

